/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.DecimalAvgAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001f\t)B)Z2j[\u0006d\u0017I^4BO\u001e4UO\\2uS>t'BA\u0002\u0005\u00031\twm\u001a4v]\u000e$\u0018n\u001c8t\u0015\t)a!A\u0005gk:\u001cG/[8og*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\u0011\t\"\u0003\u0006\u000f\u000e\u0003\u0011I!a\u0005\u0003\u0003#\u0005;wM]3hCR,g)\u001e8di&|g\u000e\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005!Q.\u0019;i\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0015\tKw\rR3dS6\fG\u000e\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\t)B)Z2j[\u0006d\u0017I^4BG\u000e,X.\u001e7bi>\u0014\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\ti\u0002\u0001C\u0003&\u0001\u0011\u0005c%A\tde\u0016\fG/Z!dGVlW\u000f\\1u_J$\u0012\u0001\b\u0005\u0006Q\u0001!\t!K\u0001\u000bC\u000e\u001cW/\\;mCR,Gc\u0001\u00161eA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5u\u0011\u0015\tt\u00051\u0001\u001d\u0003\r\t7m\u0019\u0005\u0006g\u001d\u0002\r\u0001N\u0001\u0006m\u0006dW/\u001a\t\u0003WUJ!A\u000e\u0017\u0003\u0007\u0005s\u0017\u0010C\u00039\u0001\u0011\u0005\u0011(A\u0004sKR\u0014\u0018m\u0019;\u0015\u0007)R4\bC\u00032o\u0001\u0007A\u0004C\u00034o\u0001\u0007A\u0007C\u0003>\u0001\u0011\u0005c(\u0001\u0005hKR4\u0016\r\\;f)\t!r\bC\u00032y\u0001\u0007A\u0004C\u0003B\u0001\u0011\u0005!)A\u0003nKJ<W\rF\u0002+\u0007\u0012CQ!\r!A\u0002qAQ!\u0012!A\u0002\u0019\u000b1!\u001b;t!\r9%\nH\u0007\u0002\u0011*\u0011\u0011\nG\u0001\u0005Y\u0006tw-\u0003\u0002L\u0011\nA\u0011\n^3sC\ndW\rC\u0003N\u0001\u0011\u0005a*\u0001\tsKN,G/Q2dk6,H.\u0019;peR\u0011!f\u0014\u0005\u0006c1\u0003\r\u0001\b\u0005\u0006#\u0002!\tAU\u0001\u0013O\u0016$\u0018iY2v[Vd\u0017\r^8s)f\u0004X-F\u0001Ta\t!\u0006\rE\u0002V9zk\u0011A\u0016\u0006\u0003/b\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u00033j\u000baaY8n[>t'BA.\t\u0003\r\t\u0007/[\u0005\u0003;Z\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\t\u0003?\u0002d\u0001\u0001B\u0005b!\u0006\u0005\t\u0011!B\u0001E\n\u0019q\f\n\u001b\u0012\u0005\r$\u0004CA\u0016e\u0013\t)GFA\u0004O_RD\u0017N\\4")
public class DecimalAvgAggFunction
extends AggregateFunction<BigDecimal, DecimalAvgAccumulator> {
    @Override
    public DecimalAvgAccumulator createAccumulator() {
        return new DecimalAvgAccumulator();
    }

    public void accumulate(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
        }
    }

    public void retract(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).subtract(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
        }
    }

    @Override
    public BigDecimal getValue(DecimalAvgAccumulator acc) {
        return BoxesRunTime.unboxToLong((Object)acc.f1) == 0L ? null : ((BigDecimal)acc.f0).divide(BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1)));
    }

    public void merge(DecimalAvgAccumulator acc, Iterable<DecimalAvgAccumulator> its) {
        for (DecimalAvgAccumulator a : its) {
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
        }
    }

    public void resetAccumulator(DecimalAvgAccumulator acc) {
        acc.f0 = BigDecimal.ZERO;
        acc.f1 = BoxesRunTime.boxToLong((long)0L);
    }

    public TypeInformation<?> getAccumulatorType() {
        return new TupleTypeInfo(((Object)((Object)new DecimalAvgAccumulator())).getClass(), new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }
}

