/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.DecimalSumWithRetractAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001f\t\u0001C)Z2j[\u0006d7+^7XSRD'+\u001a;sC\u000e$\u0018iZ4Gk:\u001cG/[8o\u0015\t\u0019A!\u0001\u0007bO\u001e4WO\\2uS>t7O\u0003\u0002\u0006\r\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0003\u0012%QaR\"\u0001\u0003\n\u0005M!!!E!hOJ,w-\u0019;f\rVt7\r^5p]B\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0005[\u0006$\bNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"A\u0003\"jO\u0012+7-[7bYB\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002!\t\u0016\u001c\u0017.\\1m'Vlw+\u001b;i%\u0016$(/Y2u\u0003\u000e\u001cW/\\;mCR|'\u000fC\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011Q\u0004\u0001\u0005\u0006K\u0001!\tEJ\u0001\u0012GJ,\u0017\r^3BG\u000e,X.\u001e7bi>\u0014H#\u0001\u000f\t\u000b!\u0002A\u0011A\u0015\u0002\u0015\u0005\u001c7-^7vY\u0006$X\rF\u0002+aI\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\")\u0011g\na\u00019\u0005\u0019\u0011mY2\t\u000bM:\u0003\u0019\u0001\u001b\u0002\u000bY\fG.^3\u0011\u0005-*\u0014B\u0001\u001c-\u0005\r\te.\u001f\u0005\u0006q\u0001!\t!O\u0001\be\u0016$(/Y2u)\rQ#h\u000f\u0005\u0006c]\u0002\r\u0001\b\u0005\u0006g]\u0002\r\u0001\u000e\u0005\u0006{\u0001!\tEP\u0001\tO\u0016$h+\u00197vKR\u0011Ac\u0010\u0005\u0006cq\u0002\r\u0001\b\u0005\u0006\u0003\u0002!\tAQ\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004U\r#\u0005\"B\u0019A\u0001\u0004a\u0002\"B#A\u0001\u00041\u0015aA5ugB\u0019qI\u0013\u000f\u000e\u0003!S!!\u0013\r\u0002\t1\fgnZ\u0005\u0003\u0017\"\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\u0006\u001b\u0002!\tAT\u0001\u0011e\u0016\u001cX\r^!dGVlW\u000f\\1u_J$\"AK(\t\u000bEb\u0005\u0019\u0001\u000f\t\u000bE\u0003A\u0011\u0001*\u0002%\u001d,G/Q2dk6,H.\u0019;peRK\b/\u001a\u000b\u0002'B\u0012A\u000b\u0019\t\u0004+rsV\"\u0001,\u000b\u0005]C\u0016\u0001\u0003;za\u0016LgNZ8\u000b\u0005eS\u0016AB2p[6|gN\u0003\u0002\\\u0011\u0005\u0019\u0011\r]5\n\u0005u3&a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\u0011\u0005}\u0003G\u0002\u0001\u0003\nCB\u000b\t\u0011!A\u0003\u0002\t\u00141a\u0018\u00134#\t\u0019G\u0007\u0005\u0002,I&\u0011Q\r\f\u0002\b\u001d>$\b.\u001b8h\u0001")
public class DecimalSumWithRetractAggFunction
extends AggregateFunction<BigDecimal, DecimalSumWithRetractAccumulator> {
    @Override
    public DecimalSumWithRetractAccumulator createAccumulator() {
        return new DecimalSumWithRetractAccumulator();
    }

    public void accumulate(DecimalSumWithRetractAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
        }
    }

    public void retract(DecimalSumWithRetractAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).subtract(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
        }
    }

    @Override
    public BigDecimal getValue(DecimalSumWithRetractAccumulator acc) {
        return BoxesRunTime.unboxToLong((Object)acc.f1) == 0L ? null : (BigDecimal)acc.f0;
    }

    public void merge(DecimalSumWithRetractAccumulator acc, Iterable<DecimalSumWithRetractAccumulator> its) {
        for (DecimalSumWithRetractAccumulator a : its) {
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
        }
    }

    public void resetAccumulator(DecimalSumWithRetractAccumulator acc) {
        acc.f0 = BigDecimal.ZERO;
        acc.f1 = BoxesRunTime.boxToLong((long)0L);
    }

    public TypeInformation<?> getAccumulatorType() {
        return new TupleTypeInfo(((Object)((Object)new DecimalSumWithRetractAccumulator())).getClass(), new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }
}

