/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.calcite.com.google.common.primitives.Primitives;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Call;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.TableFunctionCall;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.utils.AggSqlFunction$;
import org.apache.flink.table.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction$;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.logical.LogicalTableFunctionCall;
import org.apache.flink.table.plan.schema.FlinkTableFunctionImpl;
import org.apache.flink.util.InstantiationUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class UserDefinedFunctionUtils$ {
    public static final UserDefinedFunctionUtils$ MODULE$;

    static {
        new UserDefinedFunctionUtils$();
    }

    public void checkForInstantiation(Class<?> clazz) {
        if (InstantiationUtil.isPublic(clazz)) {
            if (InstantiationUtil.isProperClass(clazz)) {
                if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
                    throw ValidationException$.MODULE$.apply("The class is an inner class, but not statically accessible.");
                }
                return;
            }
            throw ValidationException$.MODULE$.apply("Function class is no proper class, it is either abstract, an interface, or a primitive type.");
        }
        throw ValidationException$.MODULE$.apply("Function class is not public.");
    }

    public void checkNotSingleton(Class<?> clazz) {
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])clazz.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Field x$1) {
                return x$1.getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).contains((Object)"MODULE$")) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableFunction implemented by class ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is a Scala object, it is forbidden since concurrent risks."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Option<Class<?>[]> getEvalMethodSignature(UserDefinedFunction function, Seq<TypeInformation<?>> signature) {
        return this.getUserDefinedMethod(function, "eval", this.typeInfoToClass(signature)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?>[] apply(Method x$2) {
                return x$2.getParameterTypes();
            }
        });
    }

    public Option<Class<?>[]> getAccumulateMethodSignature(AggregateFunction<?, ?> function, Seq<TypeInformation<?>> signature) {
        TypeInformation accType = TypeExtractor.createTypeInfo(function, AggregateFunction.class, function.getClass(), (int)1);
        Seq input = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new TypeInformation[]{accType}).$plus$plus(signature, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)))).toSeq();
        return this.getUserDefinedMethod(function, "accumulate", this.typeInfoToClass(input)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?>[] apply(Method x$3) {
                return x$3.getParameterTypes();
            }
        });
    }

    public TypeInformation<?>[] getParameterTypes(UserDefinedFunction function, Class<?>[] signature) {
        return (TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])signature).map((Function1)new Serializable(function){
            public static final long serialVersionUID = 0L;
            private final UserDefinedFunction function$1;

            public final TypeInformation<?> apply(Class<?> c) {
                try {
                    return TypeExtractor.getForClass(c);
                }
                catch (InvalidTypesException invalidTypesException) {
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parameter types of function '", "' cannot be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.function$1.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"automatically determined. Please provide type information manually."})).s((Seq)Nil$.MODULE$)).toString());
                }
            }
            {
                this.function$1 = function$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
    }

    public Option<Method> getUserDefinedMethod(UserDefinedFunction function, String methodName, Class<?>[] methodSignature) {
        Method[] methods = this.checkAndExtractMethods(function, methodName);
        Method[] filtered = (Method[])Predef$.MODULE$.refArrayOps((Object[])methods).filter((Function1)new Serializable(methodSignature){
            public static final long serialVersionUID = 0L;
            public final Class[] methodSignature$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Method x0$1) {
                Method method = x0$1;
                if (method.isVarArgs()) {
                    if (!method.isVarArgs()) throw new MatchError((Object)method);
                    Class[] signatures = method.getParameterTypes();
                    if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.methodSignature$1).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this, signatures){
                        public static final long serialVersionUID = 0L;
                        private final Class[] signatures$1;

                        public final boolean apply(Tuple2<Class<?>, Object> x0$3) {
                            Tuple2<Class<?>, Object> tuple2;
                            block4: {
                                boolean bl;
                                block3: {
                                    block2: {
                                        tuple2 = x0$3;
                                        if (tuple2 == null) break block2;
                                        Class clazz = (Class)tuple2._1();
                                        int i = tuple2._2$mcI$sp();
                                        if (i >= this.signatures$1.length - 1) break block2;
                                        bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(clazz, this.signatures$1[i]);
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    Class clazz = (Class)tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (i < this.signatures$1.length - 1) break block4;
                                    bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(clazz, ((Class)Predef$.MODULE$.refArrayOps((Object[])this.signatures$1).last()).getComponentType());
                                }
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.signatures$1 = signatures$1;
                        }
                    })) return true;
                    if (!Predef$.MODULE$.refArrayOps((Object[])this.methodSignature$1).isEmpty()) return false;
                    if (signatures.length != 1) return false;
                    return true;
                }
                Class<?>[] signatures = method.getParameterTypes();
                if (this.methodSignature$1.length != signatures.length) return false;
                if (!Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])signatures).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final boolean apply(Tuple2<Class<?>, Object> x0$2) {
                        Tuple2<Class<?>, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Class clazz = (Class)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            boolean bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(this.$outer.methodSignature$1[i], clazz);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })) return false;
                return true;
            }
            {
                this.methodSignature$1 = methodSignature$1;
            }
        });
        int fixedMethodsCount = Predef$.MODULE$.refArrayOps((Object[])filtered).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method x$4) {
                return !x$4.isVarArgs();
            }
        });
        Method[] found = (Method[])Predef$.MODULE$.refArrayOps((Object[])filtered).filter((Function1)new Serializable(fixedMethodsCount){
            public static final long serialVersionUID = 0L;
            private final int fixedMethodsCount$1;

            public final boolean apply(Method cur) {
                return this.fixedMethodsCount$1 > 0 && !cur.isVarArgs() || this.fixedMethodsCount$1 == 0 && cur.isVarArgs();
            }
            {
                this.fixedMethodsCount$1 = fixedMethodsCount$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])found).isEmpty() && Predef$.MODULE$.refArrayOps((Object[])methods).exists((Function1)new Serializable(methodSignature){
            public static final long serialVersionUID = 0L;
            public final Class[] methodSignature$1;

            public final boolean apply(Method method) {
                Class[] signatures = method.getParameterTypes();
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])signatures).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this, signatures){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getUserDefinedMethod.1 $outer;
                    private final Class[] signatures$2;

                    public final boolean apply(Tuple2<Class<?>, Object> x0$4) {
                        Tuple2<Class<?>, Object> tuple2;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    tuple2 = x0$4;
                                    if (tuple2 == null) break block2;
                                    Class clazz = (Class)tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (i >= this.signatures$2.length - 1) break block2;
                                    bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(this.$outer.methodSignature$1[i], clazz);
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                Class clazz = (Class)tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                if (i != this.signatures$2.length - 1) break block4;
                                bl = clazz.getName().equals("scala.collection.Seq");
                            }
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.signatures$2 = signatures$2;
                    }
                });
            }
            {
                this.methodSignature$1 = methodSignature$1;
            }
        })) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scala-style variable arguments in '", "' methods are not supported. Please "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{methodName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add a @scala.annotation.varargs annotation."})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (found.length > 1) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found multiple '", "' methods which match the signature."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{methodName})));
        }
        return Predef$.MODULE$.refArrayOps((Object[])found).headOption();
    }

    public boolean ifMethodExistInFunction(String method, UserDefinedFunction function) {
        Method[] methods = (Method[])Predef$.MODULE$.refArrayOps((Object[])function.getClass().getMethods()).filter((Function1)new Serializable(method){
            public static final long serialVersionUID = 0L;
            private final String method$1;

            public final boolean apply(Method m) {
                String string = m.getName();
                String string2 = this.method$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.method$1 = method$1;
            }
        });
        return !Predef$.MODULE$.refArrayOps((Object[])methods).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public Method[] checkAndExtractMethods(UserDefinedFunction function, String methodName) {
        void var3_3;
        Method[] methods = (Method[])Predef$.MODULE$.refArrayOps((Object[])function.getClass().getMethods()).filter((Function1)new Serializable(function, methodName){
            public static final long serialVersionUID = 0L;
            private final UserDefinedFunction function$2;
            private final String methodName$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Method m) {
                int modifiers = m.getModifiers();
                String string = m.getName();
                String string2 = this.methodName$1;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!Modifier.isPublic(modifiers)) return false;
                if (Modifier.isAbstract(modifiers)) return false;
                if (!(this.function$2 instanceof TableFunction)) return true;
                if (Modifier.isStatic(modifiers)) return false;
                return true;
            }
            {
                this.function$2 = function$2;
                this.methodName$1 = methodName$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])methods).isEmpty()) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function class '", "' does not implement at least "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{function.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one method named '", "' which is public, not abstract and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{methodName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(in case of table functions) not static."})).s((Seq)Nil$.MODULE$)).toString());
        }
        return var3_3;
    }

    public Class<?>[][] getMethodSignatures(UserDefinedFunction function, String methodName) {
        return (Class[][])Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractMethods(function, methodName)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?>[] apply(Method x$5) {
                return x$5.getParameterTypes();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Class.class))));
    }

    public SqlFunction createScalarSqlFunction(String name, ScalarFunction function, FlinkTypeFactory typeFactory) {
        return new ScalarSqlFunction(name, function, typeFactory);
    }

    public Seq<SqlFunction> createTableSqlFunctions(String name, TableFunction<?> tableFunction, TypeInformation<?> resultType2, FlinkTypeFactory typeFactory) {
        Tuple3<String[], int[], TypeInformation<?>[]> tuple3 = this.getFieldInfo(resultType2);
        if (tuple3 != null) {
            Tuple2 tuple2;
            String[] fieldNames = (String[])tuple3._1();
            int[] fieldIndexes = (int[])tuple3._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple22._1();
            int[] fieldIndexes2 = (int[])tuple22._2();
            Method[] evalMethods = this.checkAndExtractMethods(tableFunction, "eval");
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])evalMethods).map((Function1)new Serializable(name, tableFunction, resultType2, typeFactory, fieldNames2, fieldIndexes2){
                public static final long serialVersionUID = 0L;
                private final String name$1;
                private final TableFunction tableFunction$1;
                private final TypeInformation resultType$1;
                private final FlinkTypeFactory typeFactory$1;
                private final String[] fieldNames$1;
                private final int[] fieldIndexes$1;

                public final TableSqlFunction apply(Method method) {
                    FlinkTableFunctionImpl<T> function = new FlinkTableFunctionImpl<T>(this.resultType$1, this.fieldIndexes$1, this.fieldNames$1, method);
                    return TableSqlFunction$.MODULE$.apply(this.name$1, this.tableFunction$1, this.resultType$1, this.typeFactory$1, function);
                }
                {
                    this.name$1 = name$1;
                    this.tableFunction$1 = tableFunction$1;
                    this.resultType$1 = resultType$1;
                    this.typeFactory$1 = typeFactory$1;
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldIndexes$1 = fieldIndexes$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError(tuple3);
    }

    public SqlFunction createAggregateSqlFunction(String name, AggregateFunction<?, ?> aggFunction, TypeInformation<?> typeInfo, FlinkTypeFactory typeFactory) {
        this.checkAndExtractMethods(aggFunction, "accumulate");
        TypeInformation<?> resultType2 = this.getResultTypeOfAggregateFunction(aggFunction, typeInfo);
        return AggSqlFunction$.MODULE$.apply(name, aggFunction, resultType2, typeFactory, aggFunction.requiresOver());
    }

    public TypeInformation<?> getResultTypeOfAggregateFunction(AggregateFunction<?, ?> aggregateFunction, TypeInformation<?> extractedType) {
        TypeInformation resultType2;
        TypeInformation typeInformation;
        try {
            Method method = aggregateFunction.getClass().getMethod("getResultType", new Class[0]);
            typeInformation = (TypeInformation)method.invoke(aggregateFunction, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new TableException("Unexpected exception:", throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            typeInformation = resultType2 = null;
        }
        return resultType2 == null ? (extractedType == null ? TypeExtractor.createTypeInfo(aggregateFunction, AggregateFunction.class, aggregateFunction.getClass(), (int)0) : extractedType) : resultType2;
    }

    public TypeInformation<?> getResultTypeOfAggregateFunction$default$2() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeInformation<?> getResultTypeOfScalarFunction(ScalarFunction function, Class<?>[] signature) {
        TypeInformation typeInformation;
        TypeInformation userDefinedTypeInfo = function.getResultType(signature);
        if (userDefinedTypeInfo != null) {
            typeInformation = userDefinedTypeInfo;
            return typeInformation;
        }
        try {
            typeInformation = TypeExtractor.getForClass(this.getResultTypeClassOfScalarFunction(function, signature));
            return typeInformation;
        }
        catch (InvalidTypesException invalidTypesException) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Return type of scalar function '", "' cannot be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{function.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"automatically determined. Please provide type information manually."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Class<?> getResultTypeClassOfScalarFunction(ScalarFunction function, Class<?>[] signature) {
        Method evalMethod = (Method)Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractMethods(function, "eval")).find((Function1)new Serializable(signature){
            public static final long serialVersionUID = 0L;
            private final Class[] signature$1;

            public final boolean apply(Method m) {
                return Predef$.MODULE$.refArrayOps((Object[])this.signature$1).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])m.getParameterTypes()));
            }
            {
                this.signature$1 = signature$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Given signature is invalid.");
            }
        });
        return evalMethod.getReturnType();
    }

    public Tuple3<String[], int[], TypeInformation<?>[]> getFieldInfo(TypeInformation<?> inputType) {
        return new Tuple3((Object)TableEnvironment$.MODULE$.getFieldNames(inputType), (Object)TableEnvironment$.MODULE$.getFieldIndices(inputType), TableEnvironment$.MODULE$.getFieldTypes(inputType));
    }

    public String signatureToString(Class<?>[] signature) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])signature).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?> clazz) {
                return clazz == null ? "null" : clazz.getCanonicalName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")");
    }

    public String signatureToString(Seq<TypeInformation<?>> signature) {
        return this.signatureToString(this.typeInfoToClass(signature));
    }

    public String signaturesToString(UserDefinedFunction function, String name) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getMethodSignatures(function, name)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?>[] signature) {
                return UserDefinedFunctionUtils$.MODULE$.signatureToString(signature);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
    }

    public Class<?>[] typeInfoToClass(Seq<TypeInformation<?>> typeInfos) {
        return (Class[])((TraversableOnce)typeInfos.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(TypeInformation<?> typeInfo) {
                return typeInfo == null ? null : typeInfo.getTypeClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(Class<?> candidate, Class<?> expected) {
        if (candidate == null) return true;
        Class<?> clazz = candidate;
        Class<?> clazz2 = expected;
        if (clazz == null) {
            if (clazz2 == null) return true;
        } else if (clazz.equals(clazz2)) return true;
        Class<?> clazz3 = expected;
        Class<Object> clazz4 = Object.class;
        if (clazz3 == null) {
            if (clazz4 == null) return true;
        } else if (clazz3.equals(clazz4)) return true;
        if (expected.isPrimitive()) {
            Class<?> clazz5 = Primitives.wrap(expected);
            Class<?> clazz6 = candidate;
            if (clazz5 == null) {
                if (clazz6 == null) return true;
            } else if (clazz5.equals(clazz6)) return true;
        }
        Class<?> clazz7 = candidate;
        Class<Date> clazz8 = Date.class;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            Class<?> clazz9 = expected;
            Class<Integer> clazz10 = Integer.TYPE;
            if (clazz9 == null) {
                if (clazz10 == null) return true;
            } else if (clazz9.equals(clazz10)) return true;
            Class<?> clazz11 = expected;
            Class<Integer> clazz12 = Integer.class;
            if (clazz11 == null) {
                if (clazz12 == null) return true;
            } else if (clazz11.equals(clazz12)) return true;
        }
        Class<?> clazz13 = candidate;
        Class<Time> clazz14 = Time.class;
        if (!(clazz13 != null ? !clazz13.equals(clazz14) : clazz14 != null)) {
            Class<?> clazz15 = expected;
            Class<Integer> clazz16 = Integer.TYPE;
            if (clazz15 == null) {
                if (clazz16 == null) return true;
            } else if (clazz15.equals(clazz16)) return true;
            Class<?> clazz17 = expected;
            Class<Integer> clazz18 = Integer.class;
            if (clazz17 == null) {
                if (clazz18 == null) return true;
            } else if (clazz17.equals(clazz18)) return true;
        }
        Class<?> clazz19 = candidate;
        Class<Timestamp> clazz20 = Timestamp.class;
        if (!(clazz19 != null ? !clazz19.equals(clazz20) : clazz20 != null)) {
            Class<?> clazz21 = expected;
            Class<Long> clazz22 = Long.TYPE;
            if (clazz21 == null) {
                if (clazz22 == null) return true;
            } else if (clazz21.equals(clazz22)) return true;
            Class<?> clazz23 = expected;
            Class<Long> clazz24 = Long.class;
            if (clazz23 == null) {
                if (clazz24 == null) return true;
            } else if (clazz23.equals(clazz24)) return true;
        }
        if (!candidate.isArray()) return false;
        if (!expected.isArray()) return false;
        if (!(candidate.getComponentType() instanceof Object)) return false;
        Class<?> clazz25 = expected.getComponentType();
        Class<Object> clazz26 = Object.class;
        if (clazz25 != null) {
            if (!clazz25.equals(clazz26)) return false;
            return true;
        }
        if (clazz26 == null) return true;
        return false;
    }

    public String serialize(UserDefinedFunction function) throws Exception {
        byte[] byteArray = InstantiationUtil.serializeObject((Object)function);
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    public UserDefinedFunction deserialize(String data) throws Exception {
        byte[] byteData = Base64.decodeBase64((String)data);
        return (UserDefinedFunction)InstantiationUtil.deserializeObject((byte[])byteData, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public LogicalTableFunctionCall createLogicalFunctionCall(TableEnvironment tableEnv, String udtf) {
        ObjectRef alias2 = new ObjectRef((Object)None$.MODULE$);
        LogicalTableFunctionCall functionCall = this.unwrap$1(ExpressionParser$.MODULE$.parseExpression(udtf), tableEnv, alias2).as((Option<Seq<String>>)((Option)alias2.elem)).toLogicalTableFunctionCall(null);
        return functionCall;
    }

    public Seq<TypeInformation<?>> getOperandTypeInfo(SqlCallBinding callBinding) {
        IndexedSeq operandTypes = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), callBinding.getOperandCount()).map((Function1)new Serializable(callBinding){
            public static final long serialVersionUID = 0L;
            private final SqlCallBinding callBinding$1;

            public final RelDataType apply(int i) {
                return this.callBinding$1.getOperandType(i);
            }
            {
                this.callBinding$1 = callBinding$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)operandTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataType operandType) {
                SqlTypeName sqlTypeName = operandType.getSqlTypeName();
                SqlTypeName sqlTypeName2 = SqlTypeName.NULL;
                return !(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)((Object)sqlTypeName2)) : sqlTypeName2 != null) ? null : FlinkTypeFactory$.MODULE$.toTypeInfo(operandType);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private final TableFunctionCall unwrap$1(Expression expr, TableEnvironment tableEnv$1, ObjectRef alias$1) {
        Expression expression2;
        while (true) {
            Expression function;
            if ((expression2 = expr) instanceof Alias) {
                Alias alias2 = (Alias)expression2;
                Expression child = alias2.child();
                String name = alias2.name();
                Seq<String> extraNames = alias2.extraNames();
                alias$1.elem = new Some(((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus(extraNames, Seq$.MODULE$.canBuildFrom()));
                expr = child;
                continue;
            }
            if (!(expression2 instanceof Call)) break;
            Call call = (Call)expression2;
            String name = call.functionName();
            Seq<Expression> args = call.args();
            expr = function = tableEnv$1.functionCatalog().lookupFunction(name, args);
        }
        if (expression2 instanceof TableFunctionCall) {
            TableFunctionCall tableFunctionCall;
            TableFunctionCall tableFunctionCall2 = tableFunctionCall = (TableFunctionCall)expression2;
            return tableFunctionCall2;
        }
        throw new TableException("Table(TableEnv, String) constructor only accept String that define table function followed by some Alias.");
    }

    private UserDefinedFunctionUtils$() {
        MODULE$ = this;
    }
}

