/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0005#\tIb\t\\5oW2{w-[2bY*{\u0017N\\\"p]Z,'\u000f^3s\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'ii\u0011\u0001\u0006\u0006\u0003+Y\tqaY8om\u0016\u0014HO\u0003\u0002\u00181\u0005\u0019!/\u001a7\u000b\u0005ea\u0011aB2bY\u000eLG/Z\u0005\u00037Q\u0011QbQ8om\u0016\u0014H/\u001a:Sk2,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u0015\u0011\u0003\u0001\"\u0011$\u0003\u001di\u0017\r^2iKN$\"\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u000f\t{w\u000e\\3b]\")1&\ta\u0001Y\u0005!1-\u00197m!\tis&D\u0001/\u0015\t9\u0001$\u0003\u00021]\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"B\u000b\u0001\t\u0003\u0012DCA\u001a8!\t!T'D\u0001\u0017\u0013\t1dCA\u0004SK2tu\u000eZ3\t\u000b]\t\u0004\u0019A\u001a\t\u000be\u0002A\u0011\u0002\u001e\u0002+!\f7/R9vC2LG/\u001f)sK\u0012L7-\u0019;fgR\u0019Ae\u000f\"\t\u000bqB\u0004\u0019A\u001f\u0002\t)|\u0017N\u001c\t\u0003}\u0001k\u0011a\u0010\u0006\u0003\u0007YI!!Q \u0003\u00171{w-[2bY*{\u0017N\u001c\u0005\u0006\u0007b\u0002\r\u0001R\u0001\tU>Lg.\u00138g_B\u0011Q\tS\u0007\u0002\r*\u0011qIF\u0001\u0005G>\u0014X-\u0003\u0002J\r\nA!j\\5o\u0013:4w\u000eC\u0003L\u0001\u0011%A*A\bjgNKgn\u001a7f%><(j\\5o)\t!S\nC\u0003=\u0015\u0002\u0007Q\bC\u0003P\u0001\u0011%\u0001+A\u0006jgNKgn\u001a7f%><HC\u0001\u0013R\u0011\u0015\u0011f\n1\u00014\u0003\u0011qw\u000eZ3")
public class FlinkLogicalJoinConverter
extends ConverterRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        JoinInfo joinInfo;
        LogicalJoin join = (LogicalJoin)call.rel(0);
        return this.hasEqualityPredicates(join, joinInfo = join.analyzeCondition()) || this.isSingleRowJoin(join);
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.LOGICAL());
        RelNode newLeft = RelOptRule.convert(join.getLeft(), FlinkConventions$.MODULE$.LOGICAL());
        RelNode newRight = RelOptRule.convert(join.getRight(), FlinkConventions$.MODULE$.LOGICAL());
        return new FlinkLogicalJoin(rel.getCluster(), traitSet, newLeft, newRight, join.getCondition(), join.getJoinType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasEqualityPredicates(LogicalJoin join, JoinInfo joinInfo) {
        if (joinInfo.pairs().isEmpty()) return false;
        if (joinInfo.isEqui()) return true;
        JoinRelType joinRelType = join.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.INNER;
        if (joinRelType != null) {
            if (!((Object)((Object)joinRelType)).equals((Object)joinRelType2)) return false;
            return true;
        }
        if (joinRelType2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSingleRowJoin(LogicalJoin join) {
        JoinRelType joinRelType = join.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.INNER;
        JoinRelType joinRelType3 = joinRelType;
        if (!(joinRelType2 != null ? !((Object)((Object)joinRelType2)).equals((Object)joinRelType3) : joinRelType3 != null)) {
            if (this.isSingleRow(join.getRight())) return true;
            if (this.isSingleRow(join.getLeft())) {
                return true;
            }
        }
        JoinRelType joinRelType4 = JoinRelType.LEFT;
        JoinRelType joinRelType5 = joinRelType;
        if (!(joinRelType4 != null ? !((Object)((Object)joinRelType4)).equals((Object)joinRelType5) : joinRelType5 != null) && this.isSingleRow(join.getRight())) {
            return true;
        }
        JoinRelType joinRelType6 = JoinRelType.RIGHT;
        JoinRelType joinRelType7 = joinRelType;
        if (joinRelType6 == null) {
            if (joinRelType7 != null) {
                return false;
            }
        } else if (!((Object)((Object)joinRelType6)).equals((Object)joinRelType7)) return false;
        if (!this.isSingleRow(join.getLeft())) return false;
        return true;
    }

    private boolean isSingleRow(RelNode node) {
        boolean bl;
        RelNode relNode;
        while (true) {
            if ((relNode = node) instanceof RelSubset) {
                RelSubset relSubset = (RelSubset)relNode;
                node = relSubset.getOriginal();
                continue;
            }
            if (relNode instanceof Project) {
                Project project = (Project)relNode;
                node = project.getInput();
                continue;
            }
            if (relNode instanceof Filter) {
                Filter filter = (Filter)relNode;
                node = filter.getInput();
                continue;
            }
            if (!(relNode instanceof Calc)) break;
            Calc calc = (Calc)relNode;
            node = calc.getInput();
        }
        if (relNode instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)relNode;
            bl = aggregate.getGroupSet().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public FlinkLogicalJoinConverter() {
        super(LogicalJoin.class, Convention.NONE, FlinkConventions$.MODULE$.LOGICAL(), "FlinkLogicalJoinConverter");
    }
}

