/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.validate.FunctionCatalog;
import org.apache.flink.table.validate.FunctionCatalog$;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001#\t\t\u0003+^:i\r&dG/\u001a:J]R|G+\u00192mKN{WO]2f'\u000e\fgNU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M9R\"\u0001\u000b\u000b\u0005\u001d)\"B\u0001\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001\u0007\u000b\u0003\u0015I+Gn\u00149u%VdW\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!)q\u0004\u0001C!A\u00059Q.\u0019;dQ\u0016\u001cHCA\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000b\u0010A\u0002%\nAaY1mYB\u00111CK\u0005\u0003WQ\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003.\u0001\u0011\u0005c&A\u0004p]6\u000bGo\u00195\u0015\u0005=\u0012\u0004C\u0001\u00121\u0013\t\t4E\u0001\u0003V]&$\b\"\u0002\u0015-\u0001\u0004I\u0003\"\u0002\u001b\u0001\t\u0013)\u0014A\u00059vg\"4\u0015\u000e\u001c;fe&sGo\\*dC:$ra\f\u001c8\u0001\u0016KV\rC\u0003)g\u0001\u0007\u0011\u0006C\u00039g\u0001\u0007\u0011(\u0001\u0003dC2\u001c\u0007C\u0001\u001e?\u001b\u0005Y$BA\u0002=\u0015\tid!A\u0003o_\u0012,7/\u0003\u0002@w\t\u0001b\t\\5oW2{w-[2bY\u000e\u000bGn\u0019\u0005\u0006\u0003N\u0002\rAQ\u0001\u0005g\u000e\fg\u000e\u0005\u0002;\u0007&\u0011Ai\u000f\u0002\u001c\r2Lgn\u001b'pO&\u001c\u0017\r\u001c+bE2,7k\\;sG\u0016\u001c6-\u00198\t\u000b\u0019\u001b\u0004\u0019A$\u0002!Q\f'\r\\3T_V\u00148-\u001a+bE2,\u0007G\u0001%Q!\rIEJT\u0007\u0002\u0015*\u00111JB\u0001\u0007g\u000eDW-\\1\n\u00055S%\u0001\u0005+bE2,7k\\;sG\u0016$\u0016M\u00197f!\ty\u0005\u000b\u0004\u0001\u0005\u0013E+\u0015\u0011!A\u0001\u0006\u0003\u0011&aA0%gE\u00111K\u0016\t\u0003EQK!!V\u0012\u0003\u000f9{G\u000f[5oOB\u0011!eV\u0005\u00031\u000e\u00121!\u00118z\u0011\u0015Q6\u00071\u0001\\\u0003A1\u0017\u000e\u001c;fe\u0006\u0014G.Z*pkJ\u001cW\r\r\u0002]GB\u0019Q\f\u00192\u000e\u0003yS!a\u0018\u0005\u0002\u000fM|WO]2fg&\u0011\u0011M\u0018\u0002\u0016\r&dG/\u001a:bE2,G+\u00192mKN{WO]2f!\ty5\rB\u0005e3\u0006\u0005\t\u0011!B\u0001%\n\u0019q\f\n\u001b\t\u000b\u0019\u001c\u0004\u0019A4\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\t\u0003Q.t!AI5\n\u0005)\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A[\u0012\b\u000b=\u0014\u0001\u0012\u00019\u0002CA+8\u000f\u001b$jYR,'/\u00138u_R\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3\u0011\u0005u\th!B\u0001\u0003\u0011\u0003\u00118CA9t!\t\u0011C/\u0003\u0002vG\t1\u0011I\\=SK\u001aDQAG9\u0005\u0002]$\u0012\u0001\u001d\u0005\bsF\u0014\r\u0011\"\u0001{\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\n\t\rq\f\b\u0015!\u0003\u0013\u0003%Iej\u0015+B\u001d\u000e+\u0005\u0005")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)((Object)tableSource2)).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)scan.tableSource());
        this.pushFilterIntoScan(call, calc, scan, tableSourceTable, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, TableSourceTable<?> tableSourceTable, FilterableTableSource<?> filterableSource, String description) {
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        FunctionCatalog functionCatalog = FunctionCatalog$.MODULE$.withBuiltIns();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), functionCatalog);
        if (tuple2 != null) {
            RexProgram newRexProgram;
            RexProgram rexProgram;
            RexNode rexNode;
            Tuple2 tuple22;
            Expression[] predicates = (Expression[])tuple2._1();
            RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
            Expression[] predicates2 = (Expression[])tuple23._1();
            RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
            if (Predef$.MODULE$.refArrayOps((Object[])predicates2).isEmpty()) {
                return;
            }
            LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
            Predef$.MODULE$.refArrayOps((Object[])predicates2).foreach((Function1)new Serializable(this, remainingPredicates){
                public static final long serialVersionUID = 0L;
                private final LinkedList remainingPredicates$1;

                public final boolean apply(Expression e) {
                    return this.remainingPredicates$1.add(e);
                }
                {
                    this.remainingPredicates$1 = remainingPredicates$1;
                }
            });
            TableSource<?> newTableSource = filterableSource.applyPredicate(remainingPredicates);
            RelBuilder relBuilder = call.builder();
            if (remainingPredicates.isEmpty() && !Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2).nonEmpty()) {
                rexNode = null;
            } else {
                relBuilder.push(scan);
                Buffer remainingConditions = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(Expression expr) {
                        return expr.toRexNode(this.relBuilder$1);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2));
                rexNode = (RexNode)remainingConditions.reduce((Function2)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(RexNode l, RexNode r) {
                        return this.relBuilder$1.and(l, r);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                });
            }
            RexNode remainingCondition = rexNode;
            FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), newTableSource);
            if (remainingCondition == null && program.projectsOnlyIdentity()) {
                rexProgram = null;
            } else {
                List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1)new Serializable(this, program){
                    public static final long serialVersionUID = 0L;
                    private final RexProgram program$1;

                    public final RexNode apply(RexLocalRef ref) {
                        return this.program$1.expandLocalRef(ref);
                    }
                    {
                        this.program$1 = program$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).asJava();
                rexProgram = newRexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
            }
            if (newRexProgram == null) {
                call.transformTo(newScan);
            } else {
                Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
                call.transformTo(newCalc);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }
}

