/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.RowTimeWindowPropertyCollector;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001=\u0011Q\u0006R1uCN+G\u000fV;nE2,G+[7f/&tGm\\<BO\u001e\u0014V\rZ;dK\u001e\u0013x.\u001e9Gk:\u001cG/[8o\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t!!\u0011\t\u0002D\u0007\u000e\u000e\u0003IQ!a\u0005\u000b\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u000b\u0017\u0003\u0019\u0019w.\\7p]*\u0011q\u0003C\u0001\u0004CBL\u0017BA\r\u0013\u0005]\u0011\u0016n\u00195He>,\bOU3ek\u000e,g)\u001e8di&|g\u000e\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005)A/\u001f9fg&\u0011q\u0004\b\u0002\u0004%><\bcA\u0011%M5\t!E\u0003\u0002$\r\u000591m\u001c3fO\u0016t\u0017BA\u0013#\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\u0014)\u001b\u0005\u0011\u0011BA\u0015\u0003\u0005U9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]ND\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u0011\u0011%L\u0005\u0003]\t\u0012QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005Qq/\u001b8e_^\u001c\u0016N_3\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\t1{gn\u001a\u0005\tq\u0001\u0011\t\u0011)A\u0005s\u0005qq/\u001b8e_^\u001cF/\u0019:u!>\u001c\bc\u0001\u001a;y%\u00111h\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Ij\u0014B\u0001 4\u0005\rIe\u000e\u001e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005s\u0005aq/\u001b8e_^,e\u000e\u001a)pg\"A!\t\u0001B\u0001B\u0003%A(\u0001\flKf\u001c\u0018I\u001c3BO\u001e\u0014XmZ1uKN\f%/\u001b;z\u0011\u0015!\u0005\u0001\"\u0001F\u0003\u0019a\u0014N\\5u}Q1ai\u0012%J\u0015.\u0003\"a\n\u0001\t\u000b-\u001a\u0005\u0019\u0001\u0017\t\u000bA\u001a\u0005\u0019A\u0019\t\u000ba\u001a\u0005\u0019A\u001d\t\u000b\u0001\u001b\u0005\u0019A\u001d\t\u000b\t\u001b\u0005\u0019\u0001\u001f\t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0015!C2pY2,7\r^8s+\u0005y\u0005CA\u0014Q\u0013\t\t&A\u0001\u0010S_^$\u0016.\\3XS:$wn\u001e)s_B,'\u000f^=D_2dWm\u0019;pe\"I1\u000b\u0001a\u0001\u0002\u0004%I\u0001V\u0001\u000eG>dG.Z2u_J|F%Z9\u0015\u0005UC\u0006C\u0001\u001aW\u0013\t96G\u0001\u0003V]&$\bbB-S\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0004BB.\u0001A\u0003&q*\u0001\u0006d_2dWm\u0019;pe\u0002Bq!\u0018\u0001A\u0002\u0013Ea,A\bbO\u001e\u0014XmZ1uK\n+hMZ3s+\u0005Q\u0002b\u00021\u0001\u0001\u0004%\t\"Y\u0001\u0014C\u001e<'/Z4bi\u0016\u0014UO\u001a4fe~#S-\u001d\u000b\u0003+\nDq!W0\u0002\u0002\u0003\u0007!\u0004\u0003\u0004e\u0001\u0001\u0006KAG\u0001\u0011C\u001e<'/Z4bi\u0016\u0014UO\u001a4fe\u0002B\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011\u00020\u0002\r=,H\u000f];u\u0011%A\u0007\u00011AA\u0002\u0013%\u0011.\u0001\u0006pkR\u0004X\u000f^0%KF$\"!\u00166\t\u000fe;\u0017\u0011!a\u00015!1A\u000e\u0001Q!\ni\tqa\\;uaV$\b\u0005C\u0005o\u0001\u0001\u0007\t\u0019!C\t=\u0006a\u0011mY2v[Vd\u0017\r^8sg\"I\u0001\u000f\u0001a\u0001\u0002\u0004%\t\"]\u0001\u0011C\u000e\u001cW/\\;mCR|'o]0%KF$\"!\u0016:\t\u000fe{\u0017\u0011!a\u00015!1A\u000f\u0001Q!\ni\tQ\"Y2dk6,H.\u0019;peN\u0004\u0003b\u0002<\u0001\u0005\u0004%\ta^\u0001\u0004\u0019>;U#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005md\u0011!B:mMRR\u0017BA?{\u0005\u0019aunZ4fe\"1q\u0010\u0001Q\u0001\na\fA\u0001T(HA!Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011CA\u0003\u0003!1WO\\2uS>tW#\u0001\u0014\t\u0017\u0005%\u0001\u00011AA\u0002\u0013E\u00111B\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004+\u00065\u0001\u0002C-\u0002\b\u0005\u0005\t\u0019\u0001\u0014\t\u000f\u0005E\u0001\u0001)Q\u0005M\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003+\u0001A\u0011IA\f\u0003\u0011y\u0007/\u001a8\u0015\u0007U\u000bI\u0002\u0003\u0005\u0002\u001c\u0005M\u0001\u0019AA\u000f\u0003\u0019\u0019wN\u001c4jOB!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$!\tQbY8oM&<WO]1uS>t\u0017\u0002BA\u0014\u0003C\u0011QbQ8oM&<WO]1uS>t\u0007bBA\u0016\u0001\u0011\u0005\u0013QF\u0001\u0007e\u0016$WoY3\u0015\u000bU\u000by#a\u0011\t\u0011\u0005E\u0012\u0011\u0006a\u0001\u0003g\tqA]3d_J$7\u000fE\u0003\u00026\u0005}\"$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u00028\tA\u0011\n^3sC\ndW\r\u0003\u0005\u0002F\u0005%\u0002\u0019AA$\u0003\ryW\u000f\u001e\t\u0006\u0003\u0013\nyEG\u0007\u0003\u0003\u0017R1!!\u0014\t\u0003\u0011)H/\u001b7\n\t\u0005E\u00131\n\u0002\n\u0007>dG.Z2u_J\u0004")
public class DataSetTumbleTimeWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final long windowSize;
    private final Option<Object> windowStartPos;
    private final Option<Object> windowEndPos;
    private final int keysAndAggregatesArity;
    private RowTimeWindowPropertyCollector collector;
    private Row aggregateBuffer;
    private Row output;
    private Row accumulators;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private RowTimeWindowPropertyCollector collector() {
        return this.collector;
    }

    private void collector_$eq(RowTimeWindowPropertyCollector x$1) {
        this.collector = x$1;
    }

    public Row aggregateBuffer() {
        return this.aggregateBuffer;
    }

    public void aggregateBuffer_$eq(Row x$1) {
        this.aggregateBuffer = x$1;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    public Row accumulators() {
        return this.accumulators;
    }

    public void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getClass().getClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
        this.collector_$eq(new RowTimeWindowPropertyCollector(this.windowStartPos, this.windowEndPos));
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        Row last = null;
        Iterator<Row> iterator = records.iterator();
        this.function().resetAccumulator(this.accumulators());
        while (iterator.hasNext()) {
            Row record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            last = record;
        }
        this.function().setForwardedFields(last, this.output());
        this.function().setAggregationResults(this.accumulators(), this.output());
        long startTs = BoxesRunTime.unboxToLong((Object)last.getField(this.keysAndAggregatesArity));
        this.collector().wrappedCollector_$eq(out);
        this.collector().windowStart_$eq(startTs);
        this.collector().windowEnd_$eq(startTs + this.windowSize);
        this.collector().collect(this.output());
    }

    public DataSetTumbleTimeWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, long windowSize, Option<Object> windowStartPos, Option<Object> windowEndPos, int keysAndAggregatesArity) {
        this.genAggregations = genAggregations;
        this.windowSize = windowSize;
        this.windowStartPos = windowStartPos;
        this.windowEndPos = windowEndPos;
        this.keysAndAggregatesArity = keysAndAggregatesArity;
        Compiler$class.$init$(this);
        this.aggregateBuffer = new Row(keysAndAggregatesArity + 1);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

