/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000e\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tIbC\u0001\u0003D%><\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u000591m\u001c3fO\u0016t\u0017BA\u0010\u001d\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\t\"\u0013\t\u0011#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\t\u0011\u0011\u0002!Q1A\u0005\n\u0015\nqbZ3o\u0003\u001e<'/Z4bi&|gn]\u000b\u0002MA\u00111dJ\u0005\u0003Qq\u0011QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\tU\u0001\u0011\t\u0011)A\u0005M\u0005\u0001r-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\t\u0005\tY\u0001\u0011)\u0019!C\u0005[\u0005!\u0012mZ4sK\u001e\fG/[8o'R\fG/\u001a+za\u0016,\u0012A\f\t\u0003_Yj\u0011\u0001\r\u0006\u0003cI\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005M\"\u0014\u0001\u00026bm\u0006T!!\u000e\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u00028a\tY!k\\<UsB,\u0017J\u001c4p\u0011!I\u0004A!A!\u0002\u0013q\u0013!F1hOJ,w-\u0019;j_:\u001cF/\u0019;f)f\u0004X\r\t\u0005\tw\u0001\u0011)\u0019!C\u0005y\u0005\u0011r-\u001a8fe\u0006$XMU3ue\u0006\u001cG/[8o+\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002\"p_2,\u0017M\u001c\u0005\t\t\u0002\u0011\t\u0011)A\u0005{\u0005\u0019r-\u001a8fe\u0006$XMU3ue\u0006\u001cG/[8oA!Aa\t\u0001BC\u0002\u0013%q)A\u0006rk\u0016\u0014\u0018pQ8oM&<W#\u0001%\u0011\u0005%[U\"\u0001&\u000b\u0005U2\u0011B\u0001'K\u0005E\u0019FO]3b[F+XM]=D_:4\u0017n\u001a\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0011\u0006a\u0011/^3ss\u000e{gNZ5hA!)\u0001\u000b\u0001C\u0001#\u00061A(\u001b8jiz\"RAU*U+Z\u0003\"!\u0005\u0001\t\u000b\u0011z\u0005\u0019\u0001\u0014\t\u000b1z\u0005\u0019\u0001\u0018\t\u000bmz\u0005\u0019A\u001f\t\u000b\u0019{\u0005\u0019\u0001%\t\u000fa\u0003!\u0019!C\u00013\u0006\u0019AjT$\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u0007\u0002\u000bMdg\r\u000e6\n\u0005}c&A\u0002'pO\u001e,'\u000f\u0003\u0004b\u0001\u0001\u0006IAW\u0001\u0005\u0019>;\u0005\u0005C\u0005d\u0001\u0001\u0007\t\u0019!C\u0005I\u0006Aa-\u001e8di&|g.F\u0001!\u0011%1\u0007\u00011AA\u0002\u0013%q-\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002iWB\u0011a([\u0005\u0003U~\u0012A!\u00168ji\"9A.ZA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!1a\u000e\u0001Q!\n\u0001\n\u0011BZ;oGRLwN\u001c\u0011\t\u0013A\u0004\u0001\u0019!a\u0001\n\u0013\t\u0018A\u00028foJ{w/F\u0001\u0015\u0011%\u0019\b\u00011AA\u0002\u0013%A/\u0001\u0006oK^\u0014vn^0%KF$\"\u0001[;\t\u000f1\u0014\u0018\u0011!a\u0001)!1q\u000f\u0001Q!\nQ\tqA\\3x%><\b\u0005C\u0005z\u0001\u0001\u0007\t\u0019!C\u0005c\u00069\u0001O]3w%><\b\"C>\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u0003-\u0001(/\u001a<S_^|F%Z9\u0015\u0005!l\bb\u00027{\u0003\u0003\u0005\r\u0001\u0006\u0005\u0007\u007f\u0002\u0001\u000b\u0015\u0002\u000b\u0002\u0011A\u0014XM\u001e*po\u0002B!\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003=\u0003!1\u0017N]:u%><\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\tABZ5sgR\u0014vn^0%KF$2\u0001[A\u0006\u0011!a\u0017QAA\u0001\u0002\u0004i\u0004bBA\b\u0001\u0001\u0006K!P\u0001\nM&\u00148\u000f\u001e*po\u0002B1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\u0005)1\u000f^1uKV\u0011\u0011q\u0003\t\u0007\u00033\t\t#!\n\u000e\u0005\u0005m!\u0002BA\n\u0003;Q1!a\b5\u0003\u0019\u0019w.\\7p]&!\u00111EA\u000e\u0005)1\u0016\r\\;f'R\fG/\u001a\t\u0005\u0003O\tY#\u0004\u0002\u0002*)\u0011q\u0003C\u0005\u0005\u0003[\tICA\u0002S_^D1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024\u0005I1\u000f^1uK~#S-\u001d\u000b\u0004Q\u0006U\u0002\"\u00037\u00020\u0005\u0005\t\u0019AA\f\u0011!\tI\u0004\u0001Q!\n\u0005]\u0011AB:uCR,\u0007\u0005C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\n\u0005}\u0012\u0001C2oiN#\u0018\r^3\u0016\u0005\u0005\u0005\u0003CBA\r\u0003C\t\u0019\u0005\u0005\u0003\u0002F\u00055SBAA$\u0015\u0011\tI%a\u0013\u0002\t1\fgn\u001a\u0006\u0002g%!\u0011qJA$\u0005\u0011auN\\4\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011QK\u0001\rG:$8\u000b^1uK~#S-\u001d\u000b\u0004Q\u0006]\u0003\"\u00037\u0002R\u0005\u0005\t\u0019AA!\u0011!\tY\u0006\u0001Q!\n\u0005\u0005\u0013!C2oiN#\u0018\r^3!\u0011\u001d\ty\u0006\u0001C!\u0003C\nAa\u001c9f]R\u0019\u0001.a\u0019\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003O\naaY8oM&<\u0007\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055\u0004\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003c\nYGA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003k\u0002A\u0011IA<\u00039\u0001(o\\2fgN,E.Z7f]R$r\u0001[A=\u0003{\nI\nC\u0004\u0002|\u0005M\u0004\u0019\u0001\u000b\u0002\r%t\u0007/\u001e;D\u0011!\ty(a\u001dA\u0002\u0005\u0005\u0015aA2uqB!\u00111QAK!\u0019\t))!%\u0015)5\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005gk:\u001cG/[8og*\u0019Q'!$\u000b\u0007\u0005=\u0005\"A\u0005tiJ,\u0017-\\5oO&!\u00111SAD\u0005=\u0001&o\\2fgN4UO\\2uS>t\u0017\u0002BAL\u0003#\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002\u001c\u0006M\u0004\u0019AAO\u0003\ryW\u000f\u001e\t\u0006\u0003?\u000b)\u000bF\u0007\u0003\u0003CS1!a)\t\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0016\u0011\u0015\u0002\n\u0007>dG.Z2u_JDq!a+\u0001\t\u0003\ni+A\u0004p]RKW.\u001a:\u0015\u000f!\fy+a.\u0002@\"A\u0011\u0011WAU\u0001\u0004\t\u0019,A\u0005uS6,7\u000f^1naB\u0019a(!.\n\u0007\u0005=s\b\u0003\u0005\u0002\u0000\u0005%\u0006\u0019AA]!\u0011\t\u0019)a/\n\t\u0005u\u0016\u0011\u0013\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\tY*!+A\u0002\u0005u\u0005")
public class GroupAggProcessFunction
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final StreamQueryConfig queryConfig;
    private final Logger LOG;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private RowTypeInfo aggregationStateType() {
        return this.aggregationStateType;
    }

    private boolean generateRetraction() {
        return this.generateRetraction;
    }

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType());
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types$.MODULE$.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime2);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
            inputCnt = Predef$.MODULE$.long2Long(0L);
        } else {
            this.firstRow_$eq(false);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
        } else {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (this.generateRetraction() && !this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row())) {
                    return;
                }
                out.collect((Object)this.prevRow());
            }
            out.collect((Object)this.newRow());
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.needToCleanupState(timestamp)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
        }
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.queryConfig = queryConfig;
        super(queryConfig);
        Compiler$class.$init$(this);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

