/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001=\u0011\u0001\u0004\u0015:pGRKW.\u001a\"pk:$W\r\u001a*b]\u001e,wJ^3s\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u001b!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\u0011!!\u0003A!A!\u0002\u0013)\u0013aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005m1\u0013BA\u0014\u001d\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002+A\u0014XmY3eS:<G+[7f\u0005>,h\u000eZ1ssB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!Aj\u001c8h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014AE1hOJ,w-\u0019;fgRK\b/Z%oM>\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0013QL\b/Z;uS2\u001c(BA\u001c9\u0003\u0011Q\u0017M^1\u000b\u0005eB\u0011aA1qS&\u00111\b\u000e\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003%Ig\u000e];u)f\u0004X\rE\u0002@\tRi\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u0003\u0007b\naaY8n[>t\u0017BA#A\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0003\u0013.k\u0011A\u0013\u0006\u0003s\u0019I!\u0001\u0014&\u0003#M#(/Z1n#V,'/_\"p]\u001aLw\rC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\u0007!F\u00136\u000bV+\u0011\u0005E\u0001\u0001\"\u0002\u0013N\u0001\u0004)\u0003\"B\u0015N\u0001\u0004Q\u0003\"B\u0019N\u0001\u0004\u0011\u0004\"B\u001fN\u0001\u0004q\u0004\"B$N\u0001\u0004A\u0005\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0003Y\u0003\u0019yW\u000f\u001e9viV\tA\u0003C\u0005[\u0001\u0001\u0007\t\u0019!C\u00057\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005q{\u0006CA\u0016^\u0013\tqFF\u0001\u0003V]&$\bb\u00021Z\u0003\u0003\u0005\r\u0001F\u0001\u0004q\u0012\n\u0004B\u00022\u0001A\u0003&A#A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0017\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u00051\u0007cA4kY6\t\u0001N\u0003\u0002j\u0005\u0006)1\u000f^1uK&\u00111\u000e\u001b\u0002\u000b-\u0006dW/Z*uCR,\u0007CA7p\u001b\u0005q'BA\f\t\u0013\t\u0001hNA\u0002S_^D\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011B:\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\taF\u000fC\u0004ac\u0006\u0005\t\u0019\u00014\t\rY\u0004\u0001\u0015)\u0003g\u0003E\t7mY;nk2\fGo\u001c:Ti\u0006$X\r\t\u0005\nq\u0002\u0001\r\u00111A\u0005\ne\f1B]8x\u001b\u0006\u00048\u000b^1uKV\t!\u0010\u0005\u0003hw*j\u0018B\u0001?i\u0005!i\u0015\r]*uCR,\u0007\u0003\u0002@\u0002\u00061l\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003vi&d'\"A\u001c\n\u0007\u0005\u001dqP\u0001\u0003MSN$\bbCA\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001b\tqB]8x\u001b\u0006\u00048\u000b^1uK~#S-\u001d\u000b\u00049\u0006=\u0001\u0002\u00031\u0002\n\u0005\u0005\t\u0019\u0001>\t\u000f\u0005M\u0001\u0001)Q\u0005u\u0006a!o\\<NCB\u001cF/\u0019;fA!I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011D\u0001\u0004\u0019>;UCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0019\u0005)1\u000f\u001c45U&!\u0011QEA\u0010\u0005\u0019aunZ4fe\"A\u0011\u0011\u0006\u0001!\u0002\u0013\tY\"\u0001\u0003M\u001f\u001e\u0003\u0003bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0005\u0003_\t\u0001BZ;oGRLwN\\\u000b\u0002A!Y\u00111\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001b\u000311WO\\2uS>tw\fJ3r)\ra\u0016q\u0007\u0005\tA\u0006E\u0012\u0011!a\u0001A!9\u00111\b\u0001!B\u0013\u0001\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\ty\u0004\u0001C!\u0003\u0003\nAa\u001c9f]R\u0019A,a\u0011\t\u0011\u0005\u0015\u0013Q\ba\u0001\u0003\u000f\naaY8oM&<\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055\u0003\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003#\nYEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003+\u0002A\u0011IA,\u00039\u0001(o\\2fgN,E.Z7f]R$r\u0001XA-\u0003;\nI\bC\u0004\u0002\\\u0005M\u0003\u0019\u0001\u000b\u0002\u000b%t\u0007/\u001e;\t\u0011\u0005}\u00131\u000ba\u0001\u0003C\n1a\u0019;y!\u0011\t\u0019'!\u001e\u0011\r\u0005\u0015\u0014\u0011\u000f\u000b\u0015\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!\u00034v]\u000e$\u0018n\u001c8t\u0015\rI\u0014Q\u000e\u0006\u0004\u0003_B\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\t\u0019(a\u001a\u0003\u001fA\u0013xnY3tg\u001a+hn\u0019;j_:LA!a\u001e\u0002r\t91i\u001c8uKb$\b\u0002CA>\u0003'\u0002\r!! \u0002\u0007=,H\u000fE\u0003\u0002\u0000\u0005\rE#\u0004\u0002\u0002\u0002*\u0019\u0011\u0011\u0001\u0005\n\t\u0005\u0015\u0015\u0011\u0011\u0002\n\u0007>dG.Z2u_JDq!!#\u0001\t\u0003\nY)A\u0004p]RKW.\u001a:\u0015\u000fq\u000bi)!%\u0002\u001a\"9\u0011qRAD\u0001\u0004Q\u0013!\u0003;j[\u0016\u001cH/Y7q\u0011!\ty&a\"A\u0002\u0005M\u0005\u0003BA2\u0003+KA!a&\u0002r\tqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CA>\u0003\u000f\u0003\r!! ")
public class ProcTimeBoundedRangeOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingTimeBoundary;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("overState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow input, ProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime2);
        ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime2));
        if (rowList == null) {
            rowList = new ArrayList<Row>();
            ctx.timerService().registerProcessingTimeTimer(currentTime2 + 1L);
        }
        rowList.add(input.row());
        this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime2), rowList);
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        int iElemenets;
        if (this.needToCleanupState(timestamp)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
            return;
        }
        long currentTime2 = timestamp - 1L;
        int i = 0;
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        long limit = currentTime2 - this.precedingTimeBoundary;
        Iterator iter = this.rowMapState().keys().iterator();
        ArrayList<Long> markToRemove = new ArrayList<Long>();
        while (iter.hasNext()) {
            Object object;
            long elementKey = BoxesRunTime.unboxToLong(iter.next());
            if (elementKey < limit) {
                List elementsRemove = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)elementKey));
                for (int iRemove = 0; iRemove < elementsRemove.size(); ++iRemove) {
                    Row retractRow = (Row)elementsRemove.get(iRemove);
                    this.function().retract(accumulators, retractRow);
                }
                object = BoxesRunTime.boxToBoolean((boolean)markToRemove.add(BoxesRunTime.boxToLong((long)elementKey)));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        for (i = 0; i < markToRemove.size(); ++i) {
            this.rowMapState().remove(markToRemove.get(i));
        }
        List currentElements = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime2));
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().accumulate(accumulators, input);
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().setForwardedFields(input, this.output().row());
            this.function().setAggregationResults(accumulators, this.output().row());
            out.collect((Object)this.output());
        }
        this.accumulatorState().update((Object)accumulators);
    }

    public ProcTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, long precedingTimeBoundary, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.precedingTimeBoundary = precedingTimeBoundary;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(queryConfig);
        Compiler$class.$init$(this);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

