/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm.impl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;

public class ResultImpl
implements Result {
    final List<Aggregate> aggregates = new ArrayList<Aggregate>();
    final double benefit;
    final double cost;
    private final double costLimit;
    private final List<Algorithm.CostBenefit> costBenefitList = new ArrayList<Algorithm.CostBenefit>();

    public ResultImpl(List<Aggregate> materializedAggregates, List<Algorithm.CostBenefit> costBenefitList, double costLimit, double cost, double benefit) {
        this.costLimit = costLimit;
        this.aggregates.addAll(materializedAggregates);
        this.costBenefitList.addAll(costBenefitList);
        assert (this.aggregates.size() == costBenefitList.size());
        this.cost = cost;
        this.benefit = benefit;
    }

    @Override
    public List<Aggregate> getAggregates() {
        return this.aggregates;
    }

    @Override
    public List<Algorithm.CostBenefit> getCostBenefits() {
        return this.costBenefitList;
    }

    @Override
    public void describe(PrintWriter pw) {
        int j2 = -1;
        for (Aggregate aggregate : this.getAggregates()) {
            ++j2;
            pw.print("AggregateTable: ");
            int i = 0;
            for (Attribute attribute : aggregate.getAttributes()) {
                if (i++ > 0) {
                    pw.print(", ");
                }
                pw.print(attribute.getLabel());
            }
            pw.println("; ");
            this.costBenefitList.get(j2).describe(pw);
            pw.println();
        }
        pw.println("Cost limit: " + this.costLimit);
        pw.println("Actual cost: " + this.cost);
        pw.println("Benefit: " + this.benefit);
        pw.println("Cost/benefit ratio: " + this.cost / this.benefit);
    }
}

