/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;

public class Signer {
    private static final String SIGNATURE = "&s=";
    private SignerSecretProvider secretProvider;

    public Signer(SignerSecretProvider secretProvider) {
        if (secretProvider == null) {
            throw new IllegalArgumentException("secretProvider cannot be NULL");
        }
        this.secretProvider = secretProvider;
    }

    public synchronized String sign(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        byte[] secret = this.secretProvider.getCurrentSecret();
        String signature = this.computeSignature(secret, str);
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) throws SignerException {
        int index = signedStr.lastIndexOf(SIGNATURE);
        if (index == -1) {
            throw new SignerException("Invalid signed text: " + signedStr);
        }
        String originalSignature = signedStr.substring(index + SIGNATURE.length());
        String rawValue = signedStr.substring(0, index);
        this.checkSignatures(rawValue, originalSignature);
        return rawValue;
    }

    protected String computeSignature(byte[] secret, String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(str.getBytes(Charset.forName("UTF-8")));
            md.update(secret);
            byte[] digest = md.digest();
            return new Base64(0).encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    protected void checkSignatures(String rawValue, String originalSignature) throws SignerException {
        boolean isValid = false;
        byte[][] secrets = this.secretProvider.getAllSecrets();
        for (int i = 0; i < secrets.length; ++i) {
            String currentSignature;
            byte[] secret = secrets[i];
            if (secret == null || !originalSignature.equals(currentSignature = this.computeSignature(secret, rawValue))) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new SignerException("Invalid signature");
        }
    }
}

