/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class TestFileSignerSecretProvider {
    @Test
    public void testGetSecrets() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        String secretValue = "hadoop";
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write(secretValue);
        ((Writer)writer).close();
        FileSignerSecretProvider secretProvider = new FileSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret.file", secretFile.getAbsolutePath());
        secretProvider.init(secretProviderProps, null, -1L);
        Assert.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])secretProvider.getCurrentSecret());
        byte[][] allSecrets = secretProvider.getAllSecrets();
        Assert.assertEquals((long)1L, (long)allSecrets.length);
        Assert.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])allSecrets[0]);
    }

    @Test
    public void testEmptySecretFileThrows() throws Exception {
        File secretFile = File.createTempFile("test_empty_secret", ".txt");
        Assert.assertTrue((boolean)secretFile.exists());
        final FileSignerSecretProvider secretProvider = new FileSignerSecretProvider();
        final Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret.file", secretFile.getAbsolutePath());
        Exception exception = (Exception)Assert.assertThrows(RuntimeException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                secretProvider.init(secretProviderProps, null, -1L);
            }
        });
        Assert.assertTrue((boolean)exception.getMessage().startsWith("No secret in signature secret file:"));
    }
}

