/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Arrays;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ConfigurableZookeeperFactory;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.hadoop.security.authentication.util.ZookeeperClient;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.data.ACL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestZookeeperClientCreation {
    private ZookeeperClient clientConfigurer;
    private CuratorFrameworkFactory.Builder cfBuilder;

    @BeforeEach
    public void setup() {
        this.clientConfigurer = (ZookeeperClient)Mockito.spy((Object)ZookeeperClient.configure());
        this.clientConfigurer.withConnectionString("dummy");
        this.cfBuilder = (CuratorFrameworkFactory.Builder)Mockito.spy((Object)CuratorFrameworkFactory.builder());
        Mockito.when((Object)this.clientConfigurer.createFrameworkFactoryBuilder()).thenReturn((Object)this.cfBuilder);
    }

    @Test
    public void testConnectionStringSet() {
        this.clientConfigurer.withConnectionString("conn").create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectString("conn");
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testZookeeperFactorySet() {
        ZookeeperFactory zkFactory = (ZookeeperFactory)Mockito.mock(ZookeeperFactory.class);
        this.clientConfigurer.withZookeeperFactory(zkFactory).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zookeeperFactory(zkFactory);
        this.verifyDummyConnectionString();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testNameSpaceSet() {
        this.clientConfigurer.withNamespace("someNS/someSubSpace").create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).namespace("someNS/someSubSpace");
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testSessionTimeoutSet() {
        this.clientConfigurer.withSessionTimeout(20000).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(20000);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testDefaultSessionTimeoutIsAffectedBySystemProperty() {
        System.setProperty("curator-default-session-timeout", "20000");
        this.setup();
        this.clientConfigurer.create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(20000);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
        System.clearProperty("curator-default-session-timeout");
    }

    @Test
    public void testConnectionTimeoutSet() {
        this.clientConfigurer.withConnectionTimeout(50).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(50);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testDefaultConnectionTimeoutIsAffectedBySystemProperty() {
        System.setProperty("curator-default-connection-timeout", "50");
        this.setup();
        this.clientConfigurer.create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(50);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
        System.clearProperty("curator-default-connection-timeout");
    }

    @Test
    public void testRetryPolicySet() {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        this.clientConfigurer.withRetryPolicy(policy).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).retryPolicy(policy);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testSaslAutTypeWithIBMJava() {
        this.testSaslAuthType("IBMJava");
    }

    @Test
    public void testSaslAuthTypeWithNonIBMJava() {
        this.testSaslAuthType("OracleJava");
    }

    @Test
    public void testSSLConfiguration() {
        this.clientConfigurer.enableSSL(true).withKeystore("keystoreLoc").withKeystorePassword("ksPass").withTruststore("truststoreLoc").withTruststorePassword("tsPass").create();
        ArgumentCaptor clientConfCaptor = ArgumentCaptor.forClass(ZKClientConfig.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zkClientConfig((ZKClientConfig)clientConfCaptor.capture());
        ZKClientConfig conf = (ZKClientConfig)clientConfCaptor.getValue();
        MatcherAssert.assertThat((Object)conf.getProperty("zookeeper.client.secure"), (Matcher)CoreMatchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)conf.getProperty("zookeeper.clientCnxnSocket"), (Matcher)CoreMatchers.is((Object)"org.apache.zookeeper.ClientCnxnSocketNetty"));
        try (ClientX509Util sslOpts = new ClientX509Util();){
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslKeystoreLocationProperty()), (Matcher)CoreMatchers.is((Object)"keystoreLoc"));
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslKeystorePasswdProperty()), (Matcher)CoreMatchers.is((Object)"ksPass"));
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslTruststoreLocationProperty()), (Matcher)CoreMatchers.is((Object)"truststoreLoc"));
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslTruststorePasswdProperty()), (Matcher)CoreMatchers.is((Object)"tsPass"));
        }
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
    }

    @Test
    public void testNoConnectionString() {
        this.clientConfigurer.withConnectionString(null);
        Throwable t = Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"Zookeeper connection string cannot be null!"));
    }

    @Test
    public void testNoRetryPolicy() {
        this.clientConfigurer.withRetryPolicy(null);
        Throwable t = Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"Zookeeper connection retry policy cannot be null!"));
    }

    @Test
    public void testNoAuthType() {
        this.clientConfigurer.withAuthType(null);
        Throwable t = Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"Zookeeper authType cannot be null!"));
    }

    @Test
    public void testUnrecognizedAuthType() {
        this.clientConfigurer.withAuthType("something");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"Zookeeper authType must be one of [none, sasl]!"));
    }

    @Test
    public void testSaslAuthTypeWithoutKeytab() {
        this.clientConfigurer.withAuthType("sasl");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"Zookeeper client's Kerberos Keytab must be specified!"));
    }

    @Test
    public void testSaslAuthTypeWithEmptyKeytab() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"Zookeeper client's Kerberos Keytab must be specified!"));
    }

    @Test
    public void testSaslAuthTypeWithoutPrincipal() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"Zookeeper client's Kerberos Principal must be specified!"));
    }

    @Test
    public void testSaslAuthTypeWithEmptyPrincipal() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"Zookeeper client's Kerberos Principal must be specified!"));
    }

    @Test
    public void testSaslAuthTypeWithoutJaasLoginEntryName() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal").withJaasLoginEntryName(null);
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"JAAS Login Entry name must be specified!"));
    }

    @Test
    public void testSaslAuthTypeWithEmptyJaasLoginEntryName() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal").withJaasLoginEntryName("");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"JAAS Login Entry name must be specified!"));
    }

    @Test
    public void testSSLWithoutKeystore() {
        this.clientConfigurer.enableSSL(true);
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"The keystore location parameter is empty for the ZooKeeper client connection."));
    }

    @Test
    public void testSSLWithEmptyKeystore() {
        this.clientConfigurer.enableSSL(true).withKeystore("");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"The keystore location parameter is empty for the ZooKeeper client connection."));
    }

    @Test
    public void testSSLWithoutTruststore() {
        this.clientConfigurer.enableSSL(true).withKeystore("keyStoreLoc");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"The truststore location parameter is empty for the ZooKeeper client connection."));
    }

    @Test
    public void testSSLWithEmptyTruststore() {
        this.clientConfigurer.enableSSL(true).withKeystore("keyStoreLoc").withTruststore("");
        Throwable t = Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"The truststore location parameter is empty for the ZooKeeper client connection."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSaslAuthType(String vendor) {
        String origVendor = System.getProperty("java.vendor");
        System.setProperty("java.vendor", vendor);
        Configuration origConf = Configuration.getConfiguration();
        try {
            this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal@some.host/SOME.REALM").withJaasLoginEntryName("TestEntry").create();
            ArgumentCaptor aclProviderCaptor = ArgumentCaptor.forClass(ZookeeperClient.SASLOwnerACLProvider.class);
            ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).aclProvider((ACLProvider)aclProviderCaptor.capture());
            ZookeeperClient.SASLOwnerACLProvider aclProvider = (ZookeeperClient.SASLOwnerACLProvider)aclProviderCaptor.getValue();
            MatcherAssert.assertThat((Object)aclProvider.getDefaultAcl().size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ACL)aclProvider.getDefaultAcl().get(0)).getId().getScheme(), (Matcher)CoreMatchers.is((Object)"sasl"));
            MatcherAssert.assertThat((Object)((ACL)aclProvider.getDefaultAcl().get(0)).getId().getId(), (Matcher)CoreMatchers.is((Object)"principal"));
            MatcherAssert.assertThat((Object)((ACL)aclProvider.getDefaultAcl().get(0)).getPerms(), (Matcher)CoreMatchers.is((Object)31));
            Arrays.stream(new String[]{"/", "/foo", "/foo/bar/baz", "/random/path"}).forEach(s -> {
                MatcherAssert.assertThat((Object)aclProvider.getAclForPath(s).size(), (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)((ACL)aclProvider.getAclForPath(s).get(0)).getId().getScheme(), (Matcher)CoreMatchers.is((Object)"sasl"));
                MatcherAssert.assertThat((Object)((ACL)aclProvider.getAclForPath(s).get(0)).getId().getId(), (Matcher)CoreMatchers.is((Object)"principal"));
                MatcherAssert.assertThat((Object)((ACL)aclProvider.getAclForPath(s).get(0)).getPerms(), (Matcher)CoreMatchers.is((Object)31));
            });
            MatcherAssert.assertThat((Object)System.getProperty("zookeeper.sasl.clientconfig"), (Matcher)CoreMatchers.is((Object)"TestEntry"));
            MatcherAssert.assertThat((Object)System.getProperty("zookeeper.authProvider.1"), (Matcher)CoreMatchers.is((Object)"org.apache.zookeeper.server.auth.SASLAuthenticationProvider"));
            Configuration config = Configuration.getConfiguration();
            MatcherAssert.assertThat((Object)config.getAppConfigurationEntry("TestEntry").length, (Matcher)CoreMatchers.is((Object)1));
            AppConfigurationEntry entry = config.getAppConfigurationEntry("TestEntry")[0];
            MatcherAssert.assertThat(entry.getOptions().get("keyTab"), (Matcher)CoreMatchers.is((Object)"keytabLoc"));
            MatcherAssert.assertThat(entry.getOptions().get("principal"), (Matcher)CoreMatchers.is((Object)"principal@some.host/SOME.REALM"));
            MatcherAssert.assertThat(entry.getOptions().get("useKeyTab"), (Matcher)CoreMatchers.is((Object)"true"));
            MatcherAssert.assertThat(entry.getOptions().get("storeKey"), (Matcher)CoreMatchers.is((Object)"true"));
            MatcherAssert.assertThat(entry.getOptions().get("useTicketCache"), (Matcher)CoreMatchers.is((Object)"false"));
            MatcherAssert.assertThat(entry.getOptions().get("refreshKrb5Config"), (Matcher)CoreMatchers.is((Object)"true"));
            if (System.getProperty("java.vendor").contains("IBM")) {
                MatcherAssert.assertThat((Object)entry.getLoginModuleName(), (Matcher)CoreMatchers.is((Object)"com.ibm.security.auth.module.Krb5LoginModule"));
            } else {
                MatcherAssert.assertThat((Object)entry.getLoginModuleName(), (Matcher)CoreMatchers.is((Object)"com.sun.security.auth.module.Krb5LoginModule"));
            }
        }
        finally {
            Configuration.setConfiguration(origConf);
            System.setProperty("java.vendor", origVendor);
        }
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultZKClientConfig();
    }

    private void verifyDummyConnectionString() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectString("dummy");
    }

    private void verifyDefaultNamespace() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).namespace(null);
    }

    private void verifyDefaultZKFactory() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zookeeperFactory((ZookeeperFactory)ArgumentMatchers.isA(ConfigurableZookeeperFactory.class));
    }

    private void verifyDefaultSessionTimeout() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(60000);
    }

    private void verifyDefaultConnectionTimeout() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(15000);
    }

    private void verifyDefaultRetryPolicy() {
        ArgumentCaptor retry = ArgumentCaptor.forClass(ExponentialBackoffRetry.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).retryPolicy((RetryPolicy)retry.capture());
        ExponentialBackoffRetry policy = (ExponentialBackoffRetry)retry.getValue();
        MatcherAssert.assertThat((Object)policy.getBaseSleepTimeMs(), (Matcher)CoreMatchers.is((Object)1000));
        MatcherAssert.assertThat((Object)policy.getN(), (Matcher)CoreMatchers.is((Object)3));
    }

    private void verifyDefaultAclProvider() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).aclProvider((ACLProvider)ArgumentMatchers.isA(DefaultACLProvider.class));
    }

    private void verifyDefaultZKClientConfig() {
        ArgumentCaptor clientConfCaptor = ArgumentCaptor.forClass(ZKClientConfig.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zkClientConfig((ZKClientConfig)clientConfCaptor.capture());
        ZKClientConfig conf = (ZKClientConfig)clientConfCaptor.getValue();
        MatcherAssert.assertThat((Object)conf.getProperty("zookeeper.client.secure"), this.isEmptyOrFalse());
        try (ClientX509Util sslOpts = new ClientX509Util();){
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslKeystoreLocationProperty()), this.isEmpty());
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslKeystorePasswdProperty()), this.isEmpty());
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslTruststoreLocationProperty()), this.isEmpty());
            MatcherAssert.assertThat((Object)conf.getProperty(sslOpts.getSslTruststorePasswdProperty()), this.isEmpty());
        }
    }

    private Matcher<String> isEmptyOrFalse() {
        return CoreMatchers.anyOf(this.isEmpty(), (Matcher)CoreMatchers.is((Object)"false"));
    }

    private Matcher<String> isEmpty() {
        return CoreMatchers.anyOf((Matcher)new IsNull(), (Matcher)CoreMatchers.is((Object)""));
    }
}

