/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InconsistentAmazonS3Client
extends AmazonS3Client {
    public static final String DEFAULT_DELAY_KEY_SUBSTRING = "DELAY_LISTING_ME";
    public static final long DEFAULT_DELAY_KEY_MSEC = 5000L;
    public static final float DEFAULT_DELAY_KEY_PROBABILITY = 1.0f;
    public static final String MATCH_ALL_KEYS = "*";
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private String delayKeySubstring;
    private float delayKeyProbability;
    private long delayKeyMsec;
    private Map<String, Delete> delayedDeletes = new HashMap<String, Delete>();
    private Map<String, Long> delayedPutKeys = new HashMap<String, Long>();

    public InconsistentAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration, Configuration conf) {
        super(credentials, clientConfiguration);
        this.setupConfig(conf);
    }

    protected void setupConfig(Configuration conf) {
        this.delayKeySubstring = conf.get("fs.s3a.failinject.inconsistency.key.substring", DEFAULT_DELAY_KEY_SUBSTRING);
        if (this.delayKeySubstring.equals(MATCH_ALL_KEYS)) {
            this.delayKeySubstring = "";
        }
        this.delayKeyProbability = conf.getFloat("fs.s3a.failinject.inconsistency.probability", 1.0f);
        this.delayKeyMsec = conf.getLong("fs.s3a.failinject.inconsistency.msec", 5000L);
        LOG.info("Enabled with {} msec delay, substring {}, probability {}", new Object[]{this.delayKeyMsec, this.delayKeySubstring, Float.valueOf(this.delayKeyProbability)});
    }

    public void clearInconsistency() {
        LOG.info("clearing all delayed puts / deletes");
        this.delayedDeletes.clear();
        this.delayedPutKeys.clear();
    }

    public static InconsistentAmazonS3Client castFrom(AmazonS3 c) throws Exception {
        InconsistentAmazonS3Client ic = null;
        if (c instanceof InconsistentAmazonS3Client) {
            ic = (InconsistentAmazonS3Client)c;
        }
        Preconditions.checkNotNull((Object)((Object)ic), (Object)"Not an instance of InconsistentAmazonS3Client");
        return ic;
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AmazonClientException, AmazonServiceException {
        for (DeleteObjectsRequest.KeyVersion keyVersion : deleteObjectsRequest.getKeys()) {
            this.registerDeleteObject(keyVersion.getKey(), deleteObjectsRequest.getBucketName());
        }
        return super.deleteObjects(deleteObjectsRequest);
    }

    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        String key = deleteObjectRequest.getKey();
        LOG.debug("key {}", (Object)key);
        this.registerDeleteObject(key, deleteObjectRequest.getBucketName());
        super.deleteObject(deleteObjectRequest);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("key {}", (Object)putObjectRequest.getKey());
        this.registerPutObject(putObjectRequest);
        return super.putObject(putObjectRequest);
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("prefix {}", (Object)listObjectsRequest.getPrefix());
        ObjectListing listing = super.listObjects(listObjectsRequest);
        listing = this.filterListObjects(listing);
        listing = this.restoreListObjects(listObjectsRequest, listing);
        return listing;
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) throws AmazonClientException, AmazonServiceException {
        LOG.debug("prefix {}", (Object)request.getPrefix());
        ListObjectsV2Result listing = super.listObjectsV2(request);
        listing = this.filterListObjectsV2(listing);
        listing = this.restoreListObjectsV2(request, listing);
        return listing;
    }

    private void addSummaryIfNotPresent(List<S3ObjectSummary> list, S3ObjectSummary item) {
        String key = item.getKey();
        for (S3ObjectSummary member : list) {
            if (!member.getKey().equals(key)) continue;
            return;
        }
        list.add(item);
    }

    private void addPrefixIfNotPresent(List<String> prefixes, String ancestor, String child) {
        Path prefixCandidate = new Path(child).getParent();
        Path ancestorPath = new Path(ancestor);
        Preconditions.checkArgument((boolean)child.startsWith(ancestor), (String)"%s does not start with %s", (Object[])new Object[]{child, ancestor});
        while (!prefixCandidate.isRoot()) {
            Path nextParent = prefixCandidate.getParent();
            if (nextParent.equals((Object)ancestorPath)) {
                String prefix = prefixCandidate.toString();
                if (!prefixes.contains(prefix)) {
                    prefixes.add(prefix);
                }
                return;
            }
            prefixCandidate = nextParent;
        }
    }

    private boolean isDescendant(String parent, String child, boolean recursive) {
        if (recursive) {
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            return child.startsWith(parent);
        }
        Path actualParentPath = new Path(child).getParent();
        Path expectedParentPath = new Path(parent);
        return actualParentPath.equals((Object)expectedParentPath);
    }

    private ObjectListing restoreListObjects(ListObjectsRequest request, ObjectListing rawListing) {
        List outputList = rawListing.getObjectSummaries();
        List outputPrefixes = rawListing.getCommonPrefixes();
        boolean recursiveObjectList = !"/".equals(request.getDelimiter());
        String prefix = request.getPrefix();
        this.restoreDeleted(outputList, outputPrefixes, recursiveObjectList, prefix);
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private ListObjectsV2Result restoreListObjectsV2(ListObjectsV2Request request, ListObjectsV2Result result) {
        List outputList = result.getObjectSummaries();
        List outputPrefixes = result.getCommonPrefixes();
        boolean recursiveObjectList = !"/".equals(request.getDelimiter());
        String prefix = request.getPrefix();
        this.restoreDeleted(outputList, outputPrefixes, recursiveObjectList, prefix);
        return new CustomListObjectsV2Result(result, outputList, outputPrefixes);
    }

    private void restoreDeleted(List<S3ObjectSummary> summaries, List<String> prefixes, boolean recursive, String prefix) {
        for (String key : new HashSet<String>(this.delayedDeletes.keySet())) {
            Delete delete = this.delayedDeletes.get(key);
            if (this.isKeyDelayed(delete.time(), key)) {
                if (this.isDescendant(prefix, key, recursive) && delete.summary() != null) {
                    this.addSummaryIfNotPresent(summaries, delete.summary());
                }
                if (recursive || !this.isDescendant(prefix, key, true)) continue;
                this.addPrefixIfNotPresent(prefixes, prefix, key);
                continue;
            }
            this.delayedDeletes.remove(key);
        }
    }

    private ObjectListing filterListObjects(ObjectListing rawListing) {
        List<S3ObjectSummary> outputList = this.filterSummaries(rawListing.getObjectSummaries());
        List<String> outputPrefixes = this.filterPrefixes(rawListing.getCommonPrefixes());
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private ListObjectsV2Result filterListObjectsV2(ListObjectsV2Result raw) {
        List<S3ObjectSummary> outputList = this.filterSummaries(raw.getObjectSummaries());
        List<String> outputPrefixes = this.filterPrefixes(raw.getCommonPrefixes());
        return new CustomListObjectsV2Result(raw, outputList, outputPrefixes);
    }

    private List<S3ObjectSummary> filterSummaries(List<S3ObjectSummary> summaries) {
        ArrayList<S3ObjectSummary> outputList = new ArrayList<S3ObjectSummary>();
        for (S3ObjectSummary s : summaries) {
            String key = s.getKey();
            if (this.isKeyDelayed(this.delayedPutKeys.get(key), key)) continue;
            outputList.add(s);
        }
        return outputList;
    }

    private List<String> filterPrefixes(List<String> prefixes) {
        ArrayList<String> outputPrefixes = new ArrayList<String>();
        for (String key : prefixes) {
            if (this.isKeyDelayed(this.delayedPutKeys.get(key), key)) continue;
            outputPrefixes.add(key);
        }
        return outputPrefixes;
    }

    private boolean isKeyDelayed(Long enqueueTime, String key) {
        long deadline;
        if (enqueueTime == null) {
            LOG.debug("no delay for key {}", (Object)key);
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (deadline = enqueueTime + this.delayKeyMsec)) {
            this.delayedDeletes.remove(key);
            LOG.debug("no longer delaying {}", (Object)key);
            return false;
        }
        LOG.info("delaying {}", (Object)key);
        return true;
    }

    private void registerDeleteObject(String key, String bucket) {
        if (this.shouldDelay(key)) {
            S3ObjectSummary summary = null;
            ObjectListing list = this.listObjects(bucket, key);
            for (S3ObjectSummary result : list.getObjectSummaries()) {
                if (!result.getKey().equals(key)) continue;
                summary = result;
                break;
            }
            this.delayedDeletes.put(key, new Delete(System.currentTimeMillis(), summary));
        }
    }

    private void registerPutObject(PutObjectRequest req) {
        String key = req.getKey();
        if (this.shouldDelay(key)) {
            this.enqueueDelayedPut(key);
        }
    }

    private boolean shouldDelay(String key) {
        boolean delay = key.contains(this.delayKeySubstring);
        delay = delay && this.trueWithProbability(this.delayKeyProbability);
        LOG.debug("{} -> {}", (Object)key, (Object)delay);
        return delay;
    }

    private boolean trueWithProbability(float p) {
        return Math.random() < (double)p;
    }

    private void enqueueDelayedPut(String key) {
        LOG.debug("delaying put of {}", (Object)key);
        this.delayedPutKeys.put(key, System.currentTimeMillis());
    }

    private static class CustomListObjectsV2Result
    extends ListObjectsV2Result {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomListObjectsV2Result(ListObjectsV2Result raw, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(raw.getBucketName());
            this.setCommonPrefixes(raw.getCommonPrefixes());
            this.setDelimiter(raw.getDelimiter());
            this.setEncodingType(raw.getEncodingType());
            this.setStartAfter(raw.getStartAfter());
            this.setMaxKeys(raw.getMaxKeys());
            this.setContinuationToken(raw.getContinuationToken());
            this.setPrefix(raw.getPrefix());
            this.setTruncated(raw.isTruncated());
        }

        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class CustomObjectListing
    extends ObjectListing {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomObjectListing(ObjectListing rawListing, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(rawListing.getBucketName());
            this.setCommonPrefixes(rawListing.getCommonPrefixes());
            this.setDelimiter(rawListing.getDelimiter());
            this.setEncodingType(rawListing.getEncodingType());
            this.setMarker(rawListing.getMarker());
            this.setMaxKeys(rawListing.getMaxKeys());
            this.setNextMarker(rawListing.getNextMarker());
            this.setPrefix(rawListing.getPrefix());
            this.setTruncated(rawListing.isTruncated());
        }

        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class Delete {
        private Long time;
        private S3ObjectSummary summary;

        Delete(Long time, S3ObjectSummary summary) {
            this.time = time;
            this.summary = summary;
        }

        public Long time() {
            return this.time;
        }

        public S3ObjectSummary summary() {
            return this.summary;
        }
    }
}

