/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.LimitedPrivate(value={"Tests"})
@InterfaceStability.Unstable
public class RoleModel {
    public static final String VERSION = "2012-10-17";
    public static final String BUCKET_RESOURCE_F = "arn:aws:s3:::%s/%s";
    private static final AtomicLong SID_COUNTER = new AtomicLong(0L);
    private final JsonSerialization<Policy> serialization = new JsonSerialization(Policy.class, false, true);

    public RoleModel() {
        ObjectMapper mapper = this.serialization.getMapper();
        mapper.enable(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }

    public String toJson(Policy policy) throws JsonProcessingException {
        return this.serialization.toJson((Object)policy);
    }

    public static String newSid() {
        SID_COUNTER.incrementAndGet();
        return SID_COUNTER.toString();
    }

    public static Effects effect(boolean allowed) {
        return allowed ? Effects.Allow : Effects.Deny;
    }

    public static String resource(String bucket, String key, boolean addWildcard) {
        return String.format(BUCKET_RESOURCE_F, bucket, key + (addWildcard ? "*" : ""));
    }

    public static String resource(Path path, boolean isDirectory, boolean addWildcard) {
        String key = RoleModel.pathToKey(path);
        if (isDirectory && !key.isEmpty()) {
            key = key + "/";
        }
        return RoleModel.resource(path.toUri().getHost(), key, addWildcard);
    }

    public static String[] directory(Path path) {
        String host = path.toUri().getHost();
        String key = RoleModel.pathToKey(path);
        if (!key.isEmpty()) {
            return new String[]{RoleModel.resource(host, key + "/", true), RoleModel.resource(host, key, false), RoleModel.resource(host, key + "/", false)};
        }
        return new String[]{RoleModel.resource(host, key, true)};
    }

    public static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    public static Statement statement(boolean allow, String scope, String ... actions) {
        return new Statement(RoleModel.effect(allow)).addActions(actions).addResources(scope);
    }

    public static Statement statement(boolean allow, Path path, boolean isDirectory, boolean wildcards, String ... actions) {
        return new Statement(RoleModel.effect(allow)).addActions(actions).addResources(RoleModel.resource(path, isDirectory, wildcards));
    }

    public static Policy policy(Statement ... statements) {
        return new Policy(statements);
    }

    public static class Policy
    extends RoleElt {
        @JsonProperty(value="Version")
        public String version = "2012-10-17";
        @JsonProperty(value="Statement")
        public List<Statement> statement;

        public Policy(List<Statement> statement) {
            this.statement = statement;
        }

        public Policy(Statement ... statements) {
            this.statement = Arrays.asList(statements);
        }

        @Override
        public void validate() {
            Preconditions.checkNotNull(this.statement, (Object)"Statement");
            Preconditions.checkState((boolean)RoleModel.VERSION.equals(this.version), (String)"Invalid Version: %s", (Object[])new Object[]{this.version});
            this.statement.stream().forEach(a -> a.validate());
        }
    }

    public static class Statement
    extends RoleElt {
        @JsonProperty(value="Sid")
        public String sid = RoleModel.newSid();
        @JsonProperty(value="Effect")
        public Effects effect;
        @JsonProperty(value="Action")
        public List<String> action = new ArrayList<String>(1);
        @JsonProperty(value="Resource")
        public List<String> resource = new ArrayList<String>(1);

        public Statement(Effects effect) {
            this.effect = effect;
        }

        @Override
        public void validate() {
            Preconditions.checkNotNull((Object)this.sid, (Object)"Sid");
            Preconditions.checkNotNull((Object)((Object)this.effect), (Object)"Effect");
            Preconditions.checkState((!this.action.isEmpty() ? 1 : 0) != 0, (Object)"Empty Action");
            Preconditions.checkState((!this.resource.isEmpty() ? 1 : 0) != 0, (Object)"Empty Resource");
        }

        public Statement setAllowed(boolean f) {
            this.effect = RoleModel.effect(f);
            return this;
        }

        public Statement addActions(String ... actions) {
            Collections.addAll(this.action, actions);
            return this;
        }

        public Statement addResources(String ... resources) {
            Collections.addAll(this.resource, resources);
            return this;
        }
    }

    public static abstract class RoleElt {
        protected RoleElt() {
        }

        public void validate() {
        }
    }

    public static enum Effects {
        Allow,
        Deny;

    }
}

