/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MagicCommitTracker
extends PutTracker {
    public static final Logger LOG = LoggerFactory.getLogger(MagicCommitTracker.class);
    private final String originalDestKey;
    private final String pendingPartKey;
    private final Path path;
    private final WriteOperationHelper writer;
    private final String bucket;
    private static final byte[] EMPTY = new byte[0];

    public MagicCommitTracker(Path path, String bucket, String originalDestKey, String destKey, String pendingsetKey, WriteOperationHelper writer) {
        super(destKey);
        this.bucket = bucket;
        this.path = path;
        this.originalDestKey = originalDestKey;
        this.pendingPartKey = pendingsetKey;
        this.writer = writer;
        LOG.info("File {} is written as magic file to path {}", (Object)path, (Object)destKey);
    }

    @Override
    public boolean initialize() throws IOException {
        return true;
    }

    @Override
    public boolean outputImmediatelyVisible() {
        return false;
    }

    @Override
    public boolean aboutToComplete(String uploadId, List<PartETag> parts, long bytesWritten) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)uploadId), (Object)("empty/null upload ID: " + uploadId));
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"No uploaded parts list");
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0, (Object)"No uploaded parts to save");
        SinglePendingCommit commitData = new SinglePendingCommit();
        commitData.touch(System.currentTimeMillis());
        commitData.setDestinationKey(this.getDestKey());
        commitData.setBucket(this.bucket);
        commitData.setUri(this.path.toUri().toString());
        commitData.setUploadId(uploadId);
        commitData.setText("");
        commitData.setLength(bytesWritten);
        commitData.bindCommitData(parts);
        byte[] bytes = commitData.toBytes();
        LOG.info("Uncommitted data pending to file {}; commit metadata for {} parts in {}. sixe: {} byte(s)", new Object[]{this.path.toUri(), parts.size(), this.pendingPartKey, bytesWritten});
        LOG.debug("Closed MPU to {}, saved commit information to {}; data=:\n{}", new Object[]{this.path, this.pendingPartKey, commitData});
        PutObjectRequest put = this.writer.createPutObjectRequest(this.pendingPartKey, new ByteArrayInputStream(bytes), bytes.length);
        this.writer.uploadObject(put);
        PutObjectRequest originalDestPut = this.writer.createPutObjectRequest(this.originalDestKey, new ByteArrayInputStream(EMPTY), 0L);
        this.writer.uploadObject(originalDestPut);
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitTracker{");
        sb.append(", destKey=").append(this.getDestKey());
        sb.append(", pendingPartKey='").append(this.pendingPartKey).append('\'');
        sb.append(", path=").append(this.path);
        sb.append(", writer=").append(this.writer);
        sb.append('}');
        return sb.toString();
    }
}

