/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ECChunk {
    private ByteBuffer chunkBuffer;

    public ECChunk(ByteBuffer buffer) {
        this.chunkBuffer = buffer;
    }

    public ECChunk(byte[] buffer) {
        this.chunkBuffer = ByteBuffer.wrap(buffer);
    }

    public ByteBuffer getBuffer() {
        return this.chunkBuffer;
    }

    public static ByteBuffer[] toBuffers(ECChunk[] chunks) {
        ByteBuffer[] buffers = new ByteBuffer[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            ECChunk chunk = chunks[i];
            buffers[i] = chunk == null ? null : chunk.getBuffer();
        }
        return buffers;
    }

    public byte[] toBytesArray() {
        byte[] bytesArr = new byte[this.chunkBuffer.remaining()];
        this.chunkBuffer.mark();
        this.chunkBuffer.get(bytesArr);
        this.chunkBuffer.reset();
        return bytesArr;
    }
}

