/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureCoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;

@InterfaceAudience.Private
public abstract class AbstractErasureDecoder
extends AbstractErasureCoder {
    public AbstractErasureDecoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public AbstractErasureDecoder(ECSchema schema) {
        super(schema);
    }

    @Override
    public ErasureCodingStep calculateCoding(ECBlockGroup blockGroup) {
        return this.prepareDecodingStep(blockGroup);
    }

    protected abstract ErasureCodingStep prepareDecodingStep(ECBlockGroup var1);

    protected ECBlock[] getInputBlocks(ECBlockGroup blockGroup) {
        ECBlock[] inputBlocks = new ECBlock[this.getNumDataUnits() + this.getNumParityUnits()];
        System.arraycopy(blockGroup.getDataBlocks(), 0, inputBlocks, 0, this.getNumDataUnits());
        System.arraycopy(blockGroup.getParityBlocks(), 0, inputBlocks, this.getNumDataUnits(), this.getNumParityUnits());
        return inputBlocks;
    }

    protected ECBlock[] getOutputBlocks(ECBlockGroup blockGroup) {
        int i;
        ECBlock[] outputBlocks = new ECBlock[this.getNumErasedBlocks(blockGroup)];
        int idx = 0;
        for (i = 0; i < this.getNumDataUnits(); ++i) {
            if (!blockGroup.getDataBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getDataBlocks()[i];
        }
        for (i = 0; i < this.getNumParityUnits(); ++i) {
            if (!blockGroup.getParityBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getParityBlocks()[i];
        }
        return outputBlocks;
    }

    protected int getNumErasedBlocks(ECBlockGroup blockGroup) {
        int num = AbstractErasureDecoder.getNumErasedBlocks(blockGroup.getParityBlocks());
        return num += AbstractErasureDecoder.getNumErasedBlocks(blockGroup.getDataBlocks());
    }

    protected static int getNumErasedBlocks(ECBlock[] inputBlocks) {
        int numErased = 0;
        for (int i = 0; i < inputBlocks.length; ++i) {
            if (!inputBlocks[i].isErased()) continue;
            ++numErased;
        }
        return numErased;
    }

    protected int[] getErasedIndexes(ECBlock[] inputBlocks) {
        int numErased = AbstractErasureDecoder.getNumErasedBlocks(inputBlocks);
        if (numErased == 0) {
            return new int[0];
        }
        int[] erasedIndexes = new int[numErased];
        int j = 0;
        for (int i = 0; i < inputBlocks.length && j < erasedIndexes.length; ++i) {
            if (!inputBlocks[i].isErased()) continue;
            erasedIndexes[j++] = i;
        }
        return erasedIndexes;
    }

    protected ECBlock[] getErasedBlocks(ECBlock[] inputBlocks) {
        int numErased = AbstractErasureDecoder.getNumErasedBlocks(inputBlocks);
        if (numErased == 0) {
            return new ECBlock[0];
        }
        ECBlock[] erasedBlocks = new ECBlock[numErased];
        int j = 0;
        for (int i = 0; i < inputBlocks.length && j < erasedBlocks.length; ++i) {
            if (!inputBlocks[i].isErased()) continue;
            erasedBlocks[j++] = inputBlocks[i];
        }
        return erasedBlocks;
    }
}

