/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureCodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class ErasureDecodingStep
extends AbstractErasureCodingStep {
    private int[] erasedIndexes;
    private RawErasureDecoder rawDecoder;

    public ErasureDecodingStep(ECBlock[] inputBlocks, int[] erasedIndexes, ECBlock[] outputBlocks, RawErasureDecoder rawDecoder) {
        super(inputBlocks, outputBlocks);
        this.erasedIndexes = erasedIndexes;
        this.rawDecoder = rawDecoder;
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) {
        this.rawDecoder.decode(inputChunks, this.erasedIndexes, outputChunks);
    }
}

