/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.HHXORErasureDecodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureDecoder
extends AbstractErasureDecoder {
    private RawErasureDecoder rsRawDecoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureDecoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public HHXORErasureDecoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        ECBlock[] outputBlocks = this.getOutputBlocks(blockGroup);
        RawErasureDecoder rawDecoder = this.checkCreateRSRawDecoder();
        RawErasureEncoder rawEncoder = this.checkCreateXorRawEncoder();
        return new HHXORErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), outputBlocks, rawDecoder, rawEncoder);
    }

    private RawErasureDecoder checkCreateRSRawDecoder() {
        if (this.rsRawDecoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.rsRawDecoder = CodecUtil.createRawDecoder(this.getConf(), "rs-default", coderOptions);
        }
        return this.rsRawDecoder;
    }

    private RawErasureEncoder checkCreateXorRawEncoder() {
        if (this.xorRawEncoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.xorRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "xor", coderOptions);
        }
        return this.xorRawEncoder;
    }

    @Override
    public void release() {
        if (this.rsRawDecoder != null) {
            this.rsRawDecoder.release();
        }
        if (this.xorRawEncoder != null) {
            this.xorRawEncoder.release();
        }
    }
}

