/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureEncoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.HHXORErasureEncodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureEncoder
extends AbstractErasureEncoder {
    private RawErasureEncoder rsRawEncoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureEncoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public HHXORErasureEncoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        RawErasureEncoder rsRawEncoderTmp = this.checkCreateRSRawEncoder();
        RawErasureEncoder xorRawEncoderTmp = this.checkCreateXorRawEncoder();
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new HHXORErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rsRawEncoderTmp, xorRawEncoderTmp);
    }

    private RawErasureEncoder checkCreateRSRawEncoder() {
        if (this.rsRawEncoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.rsRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "rs-default", coderOptions);
        }
        return this.rsRawEncoder;
    }

    private RawErasureEncoder checkCreateXorRawEncoder() {
        if (this.xorRawEncoder == null) {
            ErasureCoderOptions erasureCoderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.xorRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "xor", erasureCoderOptions);
        }
        return this.xorRawEncoder;
    }

    @Override
    public void release() {
        if (this.rsRawEncoder != null) {
            this.rsRawEncoder.release();
        }
        if (this.xorRawEncoder != null) {
            this.xorRawEncoder.release();
        }
    }
}

