/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureEncoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.ErasureEncodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class RSErasureEncoder
extends AbstractErasureEncoder {
    private RawErasureEncoder rawEncoder;

    public RSErasureEncoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public RSErasureEncoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        RawErasureEncoder rawEncoder = this.checkCreateRSRawEncoder();
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rawEncoder);
    }

    private RawErasureEncoder checkCreateRSRawEncoder() {
        if (this.rawEncoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.rawEncoder = CodecUtil.createRawEncoder(this.getConf(), "rs-default", coderOptions);
        }
        return this.rawEncoder;
    }

    @Override
    public void release() {
        if (this.rawEncoder != null) {
            this.rawEncoder.release();
        }
    }
}

