/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.DecayRpcScheduler;
import org.apache.hadoop.ipc.ExternalCall;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestRPC
extends TestRpcBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestRPC.class);
    int datasize = 102400;
    int numThreads = 50;
    private static final String ACL_CONFIG = "test.protocol.acl";

    @Before
    public void setup() {
        this.setupConf();
    }

    @Test
    public void testConfRpc() throws IOException {
        RPC.Server server = TestRPC.newServerBuilder(conf).setNumHandlers(1).setVerbose(false).build();
        int confQ = conf.getInt("ipc.server.handler.queue.size", 100);
        Assert.assertEquals((long)confQ, (long)server.getMaxQueueSize());
        int confReaders = conf.getInt("ipc.server.read.threadpool.size", 1);
        Assert.assertEquals((long)confReaders, (long)server.getNumReaders());
        server = TestRPC.newServerBuilder(conf).setNumHandlers(1).setnumReaders(3).setQueueSizePerHandler(200).setVerbose(false).build();
        Assert.assertEquals((long)3L, (long)server.getNumReaders());
        Assert.assertEquals((long)200L, (long)server.getMaxQueueSize());
        server = TestRPC.newServerBuilder(conf).setQueueSizePerHandler(10).setNumHandlers(2).setVerbose(false).build();
        Assert.assertEquals((long)20L, (long)server.getMaxQueueSize());
    }

    @Test
    public void testProxyAddress() throws Exception {
        RPC.Server server = null;
        TestRpcBase.TestRpcService proxy = null;
        try {
            server = TestRPC.setupTestServer(conf, -1);
            proxy = TestRPC.getClient(addr, conf);
            Assert.assertEquals((Object)addr, (Object)RPC.getServerAddress((Object)proxy));
        }
        catch (Throwable throwable) {
            TestRPC.stop((Server)server, proxy);
            throw throwable;
        }
        TestRPC.stop((Server)server, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowRpc() throws IOException, ServiceException {
        TestRpcBase.TestRpcService proxy = null;
        System.out.println("Testing Slow RPC");
        RPC.Server server = TestRPC.setupTestServer(conf, 2);
        try {
            proxy = TestRPC.getClient(addr, conf);
            SlowRPC slowrpc = new SlowRPC(proxy);
            Thread thread = new Thread((Runnable)slowrpc, "SlowRPC");
            thread.start();
            Assert.assertTrue((String)"Slow RPC should not have finished1.", (!slowrpc.isDone() ? 1 : 0) != 0);
            slowrpc.ping(false);
            Assert.assertTrue((String)"Slow RPC should not have finished2.", (!slowrpc.isDone() ? 1 : 0) != 0);
            slowrpc.ping(false);
            while (!slowrpc.isDone()) {
                System.out.println("Waiting for slow RPC to get done.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            System.out.println("Down slow rpc testing");
            TestRPC.stop((Server)server, proxy);
        }
    }

    @Test
    public void testCalls() throws Exception {
        this.testCallsInternal(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCallsInternal(Configuration myConf) throws Exception {
        TestRpcBase.TestRpcService proxy = null;
        RPC.Server server = TestRPC.setupTestServer(myConf, -1);
        try {
            int i;
            proxy = TestRPC.getClient(addr, myConf);
            proxy.ping(null, TestRPC.newEmptyRequest());
            TestProtos.EchoResponseProto echoResp = proxy.echo(null, TestRPC.newEchoRequest("foo"));
            Assert.assertEquals((Object)echoResp.getMessage(), (Object)"foo");
            echoResp = proxy.echo(null, TestRPC.newEchoRequest(""));
            Assert.assertEquals((Object)echoResp.getMessage(), (Object)"");
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics(server.rpcMetrics.name());
            MetricsAsserts.assertCounter("RpcProcessingTimeNumOps", 3L, rb);
            MetricsAsserts.assertCounterGt("SentBytes", 0L, rb);
            MetricsAsserts.assertCounterGt("ReceivedBytes", 0L, rb);
            Assert.assertEquals((Object)("" + server.getPort()), (Object)server.getRpcMetrics().getTag("port").value());
            Assert.assertEquals((Object)"TestProtobufRpcProto", (Object)server.getRpcMetrics().getTag("serverName").value());
            rb = MetricsAsserts.getMetrics(server.rpcDetailedMetrics.name());
            MetricsAsserts.assertCounter("EchoNumOps", 2L, rb);
            MetricsAsserts.assertCounter("PingNumOps", 1L, rb);
            Object[] strings = new String[]{"foo", "bar"};
            TestProtos.EchoRequestProto2 echoRequest2 = TestProtos.EchoRequestProto2.newBuilder().addAllMessage(Arrays.asList(strings)).build();
            TestProtos.EchoResponseProto2 echoResponse2 = proxy.echo2(null, echoRequest2);
            Assert.assertTrue((boolean)Arrays.equals(echoResponse2.getMessageList().toArray(), strings));
            echoRequest2 = TestProtos.EchoRequestProto2.newBuilder().addAllMessage(Collections.emptyList()).build();
            echoResponse2 = proxy.echo2(null, echoRequest2);
            Assert.assertTrue((boolean)Arrays.equals(echoResponse2.getMessageList().toArray(), new String[0]));
            TestProtos.AddRequestProto addRequest = TestProtos.AddRequestProto.newBuilder().setParam1(1).setParam2(2).build();
            TestProtos.AddResponseProto addResponse = proxy.add(null, addRequest);
            Assertions.assertThat((int)addResponse.getResult()).isEqualTo(3);
            Integer[] integers = new Integer[]{1, 2};
            TestProtos.AddRequestProto2 addRequest2 = TestProtos.AddRequestProto2.newBuilder().addAllParams(Arrays.asList(integers)).build();
            addResponse = proxy.add2(null, addRequest2);
            Assertions.assertThat((int)addResponse.getResult()).isEqualTo(3);
            boolean caught = false;
            try {
                proxy.error(null, TestRPC.newEmptyRequest());
            }
            catch (ServiceException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught " + (Object)((Object)e));
                }
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
            rb = MetricsAsserts.getMetrics(server.rpcDetailedMetrics.name());
            MetricsAsserts.assertCounter("RpcServerExceptionNumOps", 1L, rb);
            System.out.println("Starting multi-threaded RPC test...");
            server.setSocketSendBufSize(1024);
            Thread[] threadId = new Thread[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                Transactions trans = new Transactions(proxy, this.datasize);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            System.out.println("Waiting for all threads to finish RPCs...");
            for (i = 0; i < this.numThreads; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
        }
        finally {
            TestRPC.stop((Server)server, proxy);
        }
    }

    @Test
    public void testClientWithoutServer() throws Exception {
        block2: {
            int invalidPort = 20;
            InetSocketAddress invalidAddress = new InetSocketAddress("0.0.0.0", invalidPort);
            long invalidClientVersion = 1L;
            try {
                TestRpcBase.TestRpcService proxy = (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)invalidClientVersion, (InetSocketAddress)invalidAddress, (Configuration)conf);
                proxy.echo(null, TestRPC.newEchoRequest("hello"));
                Assert.fail((String)"We should not have reached here");
            }
            catch (ServiceException ioe) {
                if (ioe.getCause() instanceof ConnectException) break block2;
                Assert.fail((String)"We should not have reached here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRPCs(Configuration myConf, boolean expectFailure) throws Exception {
        block9: {
            TestRpcBase.TestRpcService proxy = null;
            RPC.Server server = TestRPC.setupTestServer(myConf, 5);
            server.refreshServiceAcl(myConf, (PolicyProvider)new TestPolicyProvider());
            TestProtos.EmptyRequestProto emptyRequestProto = TestProtos.EmptyRequestProto.newBuilder().build();
            try {
                proxy = TestRPC.getClient(addr, conf);
                proxy.ping(null, emptyRequestProto);
                if (expectFailure) {
                    Assert.fail((String)"Expect RPC.getProxy to fail with AuthorizationException!");
                }
            }
            catch (ServiceException e) {
                if (expectFailure) {
                    RemoteException re = (RemoteException)e.getCause();
                    Assert.assertTrue((boolean)(re.unwrapRemoteException() instanceof AuthorizationException));
                    Assert.assertEquals((String)"RPC error code should be UNAUTHORIZED", (Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.FATAL_UNAUTHORIZED, (Object)re.getErrorCode());
                    break block9;
                }
                throw e;
            }
            finally {
                MetricsRecordBuilder rb = MetricsAsserts.getMetrics(server.rpcMetrics.name());
                if (expectFailure) {
                    MetricsAsserts.assertCounter("RpcAuthorizationFailures", 1L, rb);
                } else {
                    MetricsAsserts.assertCounter("RpcAuthorizationSuccesses", 1L, rb);
                }
                MetricsAsserts.assertCounter("RpcAuthenticationFailures", 0L, rb);
                MetricsAsserts.assertCounter("RpcAuthenticationSuccesses", 0L, rb);
                TestRPC.stop((Server)server, proxy);
            }
        }
    }

    @Test
    public void testServerAddress() throws IOException {
        RPC.Server server = TestRPC.setupTestServer(conf, 5);
        try {
            InetSocketAddress bindAddr = NetUtils.getConnectAddress((Server)server);
            Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)bindAddr.getAddress());
        }
        finally {
            TestRPC.stop((Server)server, null);
        }
    }

    @Test
    public void testAuthorization() throws Exception {
        Configuration myConf = new Configuration();
        myConf.setBoolean("hadoop.security.authorization", true);
        myConf.set(ACL_CONFIG, "*");
        this.doRPCs(myConf, false);
        myConf.set(ACL_CONFIG, "invalid invalid");
        this.doRPCs(myConf, true);
        myConf.setInt("ipc.server.read.threadpool.size", 2);
        myConf.set(ACL_CONFIG, "*");
        this.doRPCs(myConf, false);
        myConf.set(ACL_CONFIG, "invalid invalid");
        this.doRPCs(myConf, true);
    }

    public void testNoPings() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("ipc.client.ping", false);
        new TestRPC().testCallsInternal(conf);
        conf.setInt("ipc.server.read.threadpool.size", 2);
        new TestRPC().testCallsInternal(conf);
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testStopNonRegisteredProxy() throws IOException {
        RPC.stopProxy(null);
    }

    @Test
    public void testStopMockObject() throws IOException {
        RPC.stopProxy((Object)MockitoUtil.mockProtocol(TestProtocol.class));
    }

    @Test
    public void testStopProxy() throws IOException {
        RPC.setProtocolEngine((Configuration)conf, StoppedProtocol.class, StoppedRpcEngine.class);
        StoppedProtocol proxy = (StoppedProtocol)RPC.getProxy(StoppedProtocol.class, (long)0L, null, (Configuration)conf);
        StoppedInvocationHandler invocationHandler = (StoppedInvocationHandler)Proxy.getInvocationHandler(proxy);
        Assert.assertEquals((long)0L, (long)invocationHandler.getCloseCalled());
        RPC.stopProxy((Object)proxy);
        Assert.assertEquals((long)1L, (long)invocationHandler.getCloseCalled());
    }

    @Test
    public void testWrappedStopProxy() throws IOException {
        StoppedProtocol wrappedProxy = (StoppedProtocol)RPC.getProxy(StoppedProtocol.class, (long)0L, null, (Configuration)conf);
        StoppedInvocationHandler invocationHandler = (StoppedInvocationHandler)Proxy.getInvocationHandler(wrappedProxy);
        StoppedProtocol proxy = (StoppedProtocol)RetryProxy.create(StoppedProtocol.class, (Object)wrappedProxy, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        Assert.assertEquals((long)0L, (long)invocationHandler.getCloseCalled());
        RPC.stopProxy((Object)proxy);
        Assert.assertEquals((long)1L, (long)invocationHandler.getCloseCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorMsgForInsecureClient() throws IOException {
        RemoteException re;
        TestRpcBase.TestRpcService proxy = null;
        Configuration serverConf = new Configuration(conf);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)serverConf);
        UserGroupInformation.setConfiguration((Configuration)serverConf);
        RPC.Server server = TestRPC.setupTestServer(serverConf, 5);
        boolean succeeded = false;
        try {
            UserGroupInformation.setConfiguration((Configuration)conf);
            proxy = TestRPC.getClient(addr, conf);
            proxy.echo(null, TestRPC.newEchoRequest(""));
        }
        catch (ServiceException e) {
            try {
                Assert.assertTrue((boolean)(e.getCause() instanceof RemoteException));
                re = (RemoteException)e.getCause();
                LOG.info("LOGGING MESSAGE: " + re.getLocalizedMessage());
                Assert.assertEquals((String)"RPC error code should be UNAUTHORIZED", (Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.FATAL_UNAUTHORIZED, (Object)re.getErrorCode());
                Assert.assertTrue((boolean)(re.unwrapRemoteException() instanceof AccessControlException));
                succeeded = true;
            }
            catch (Throwable throwable) {
                TestRPC.stop((Server)server, proxy);
                throw throwable;
            }
            TestRPC.stop((Server)server, proxy);
        }
        TestRPC.stop((Server)server, proxy);
        Assert.assertTrue((boolean)succeeded);
        conf.setInt("ipc.server.read.threadpool.size", 2);
        UserGroupInformation.setConfiguration((Configuration)serverConf);
        server = TestRPC.setupTestServer(serverConf, 5);
        succeeded = false;
        proxy = null;
        try {
            UserGroupInformation.setConfiguration((Configuration)conf);
            proxy = TestRPC.getClient(addr, conf);
            proxy.echo(null, TestRPC.newEchoRequest(""));
        }
        catch (ServiceException e) {
            re = (RemoteException)e.getCause();
            LOG.info("LOGGING MESSAGE: " + re.getLocalizedMessage());
            Assert.assertEquals((String)"RPC error code should be UNAUTHORIZED", (Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.FATAL_UNAUTHORIZED, (Object)re.getErrorCode());
            Assert.assertTrue((boolean)(re.unwrapRemoteException() instanceof AccessControlException));
            succeeded = true;
        }
        finally {
            TestRPC.stop((Server)server, proxy);
        }
        Assert.assertTrue((boolean)succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopsAllThreads() throws IOException, InterruptedException {
        int threadsBefore = TestRPC.countThreads("Server$Listener$Reader");
        Assert.assertEquals((String)"Expect no Reader threads running before test", (long)0L, (long)threadsBefore);
        RPC.Server server = TestRPC.setupTestServer(conf, 5);
        try {
            int threadsRunning = 0;
            long totalSleepTime = 0L;
            do {
                Thread.sleep(10L);
            } while ((threadsRunning = TestRPC.countThreads("Server$Listener$Reader")) == 0 && (totalSleepTime += 10L) < 5000L);
            threadsRunning = TestRPC.countThreads("Server$Listener$Reader");
            Assert.assertTrue((threadsRunning > 0 ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
        int threadsAfter = TestRPC.countThreads("Server$Listener$Reader");
        Assert.assertEquals((String)"Expect no Reader threads left running after test", (long)0L, (long)threadsAfter);
    }

    @Test
    public void testRPCBuilder() throws IOException {
        block8: {
            block7: {
                block6: {
                    try {
                        new RPC.Builder(null).setProtocol(TestProtocol.class).setInstance((Object)new TestImpl()).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
                        Assert.fail((String)"Didn't throw HadoopIllegalArgumentException");
                    }
                    catch (Exception e) {
                        if (e instanceof HadoopIllegalArgumentException) break block6;
                        Assert.fail((String)("Expecting HadoopIllegalArgumentException but caught " + e));
                    }
                }
                try {
                    new RPC.Builder(conf).setInstance((Object)new TestImpl()).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
                    Assert.fail((String)"Didn't throw HadoopIllegalArgumentException");
                }
                catch (Exception e) {
                    if (e instanceof HadoopIllegalArgumentException) break block7;
                    Assert.fail((String)("Expecting HadoopIllegalArgumentException but caught " + e));
                }
            }
            try {
                new RPC.Builder(conf).setProtocol(TestProtocol.class).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
                Assert.fail((String)"Didn't throw HadoopIllegalArgumentException");
            }
            catch (Exception e) {
                if (e instanceof HadoopIllegalArgumentException) break block8;
                Assert.fail((String)("Expecting HadoopIllegalArgumentException but caught " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testRPCInterruptedSimple() throws Exception {
        TestRpcBase.TestRpcService proxy = null;
        RPC.Builder builder = TestRPC.newServerBuilder(conf).setNumHandlers(5).setVerbose(true).setSecretManager(null);
        RPC.Server server = TestRPC.setupTestServer(builder);
        try {
            proxy = TestRPC.getClient(addr, conf);
            proxy.ping(null, TestRPC.newEmptyRequest());
            Thread.currentThread().interrupt();
            try {
                proxy.ping(null, TestRPC.newEmptyRequest());
                Assert.fail((String)"Interruption did not cause IPC to fail");
            }
            catch (ServiceException se) {
                if (se.toString().contains("InterruptedException") || se.getCause() instanceof InterruptedIOException) {
                    Thread.interrupted();
                    TestRPC.stop((Server)server, proxy);
                    return;
                }
                throw se;
            }
        }
        finally {
            TestRPC.stop((Server)server, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRPCInterrupted() throws Exception {
        RPC.Builder builder = TestRPC.newServerBuilder(conf).setNumHandlers(5).setVerbose(true).setSecretManager(null);
        RPC.Server server = TestRPC.setupTestServer(builder);
        int numConcurrentRPC = 200;
        final CyclicBarrier barrier = new CyclicBarrier(numConcurrentRPC);
        final CountDownLatch latch = new CountDownLatch(numConcurrentRPC);
        final AtomicBoolean leaderRunning = new AtomicBoolean(true);
        final AtomicReference error = new AtomicReference();
        Thread leaderThread = null;
        try {
            for (int i = 0; i < numConcurrentRPC; ++i) {
                final int num = i;
                final TestRpcBase.TestRpcService proxy = TestRPC.getClient(addr, conf);
                Thread rpcThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            barrier.await();
                            while (num == 0 || leaderRunning.get()) {
                                proxy.slowPing(null, TestRpcBase.newSlowPingRequest(false));
                            }
                            proxy.slowPing(null, TestRpcBase.newSlowPingRequest(false));
                        }
                        catch (Exception e) {
                            if (num == 0) {
                                leaderRunning.set(false);
                            } else {
                                error.set(e);
                            }
                            LOG.error("thread " + num, (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                rpcThread.start();
                if (leaderThread != null) continue;
                leaderThread = rpcThread;
            }
            Thread.sleep(1000L);
            while (leaderRunning.get()) {
                leaderThread.interrupt();
            }
            latch.await();
            Assert.assertTrue((String)("rpc got exception " + error.get()), (error.get() == null ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionPing() throws Exception {
        TestRpcBase.TestRpcService proxy = null;
        int pingInterval = 50;
        conf.setBoolean("ipc.client.ping", true);
        conf.setInt("ipc.ping.interval", pingInterval);
        RPC.Server server = TestRPC.setupTestServer(conf, 5);
        try {
            proxy = TestRPC.getClient(addr, conf);
            proxy.sleep(null, TestRPC.newSleepRequest(pingInterval * 4));
        }
        finally {
            TestRPC.stop((Server)server, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testExternalCall() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"user123", (String[])new String[0]);
        final IOException expectedIOE = new IOException("boom");
        RPC.Server server = TestRPC.setupTestServer(conf, 1);
        try {
            AtomicBoolean result = new AtomicBoolean();
            ExternalCall<String> remoteUserCall = this.newExtCall(ugi, new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return UserGroupInformation.getCurrentUser().getUserName();
                }
            });
            ExternalCall<String> exceptionCall = this.newExtCall(ugi, new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    throw expectedIOE;
                }
            });
            final CountDownLatch latch = new CountDownLatch(1);
            final CyclicBarrier barrier = new CyclicBarrier(2);
            ExternalCall<Void> barrierCall = this.newExtCall(ugi, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    latch.countDown();
                    barrier.await();
                    return null;
                }
            });
            server.queueCall(barrierCall);
            server.queueCall(exceptionCall);
            server.queueCall(remoteUserCall);
            latch.await();
            Assert.assertEquals((long)2L, (long)server.getCallQueueLen());
            barrier.await();
            barrierCall.get();
            String answer = (String)remoteUserCall.get();
            Assert.assertEquals((Object)ugi.getUserName(), (Object)answer);
            try {
                exceptionCall.get();
                Assert.fail((String)"didn't throw");
            }
            catch (ExecutionException ee) {
                Assert.assertTrue((boolean)(ee.getCause() instanceof IOException));
                Assert.assertEquals((Object)expectedIOE.getMessage(), (Object)ee.getCause().getMessage());
            }
        }
        finally {
            server.stop();
        }
    }

    private <T> ExternalCall<T> newExtCall(final UserGroupInformation ugi, PrivilegedExceptionAction<T> callable) {
        return new ExternalCall<T>(callable){

            public String getProtocol() {
                return "test";
            }

            public UserGroupInformation getRemoteUser() {
                return ugi;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcMetrics() throws Exception {
        TestRpcBase.TestRpcService proxy = null;
        boolean interval = true;
        conf.setBoolean("rpc.metrics.quantile.enable", true);
        conf.set("rpc.metrics.percentiles.intervals", "1");
        RPC.Server server = TestRPC.setupTestServer(conf, 5);
        String testUser = "testUser";
        UserGroupInformation anotherUser = UserGroupInformation.createRemoteUser((String)testUser);
        TestRpcBase.TestRpcService proxy2 = (TestRpcBase.TestRpcService)anotherUser.doAs((PrivilegedAction)new PrivilegedAction<TestRpcBase.TestRpcService>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public TestRpcBase.TestRpcService run() {
                try {
                    return (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)0L, (InetSocketAddress)this.val$server.getListenerAddress(), (Configuration)TestRpcBase.conf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        try {
            proxy = TestRPC.getClient(addr, conf);
            for (int i = 0; i < 1000; ++i) {
                proxy.ping(null, TestRPC.newEmptyRequest());
                proxy.echo(null, TestRPC.newEchoRequest("" + i));
                proxy2.echo(null, TestRPC.newEchoRequest("" + i));
            }
            MetricsRecordBuilder rpcMetrics = MetricsAsserts.getMetrics(server.getRpcMetrics().name());
            Assert.assertEquals((String)"Expected correct rpc queue count", (long)3000L, (long)MetricsAsserts.getLongCounter("RpcQueueTimeNumOps", rpcMetrics));
            Assert.assertEquals((String)"Expected correct rpc processing count", (long)3000L, (long)MetricsAsserts.getLongCounter("RpcProcessingTimeNumOps", rpcMetrics));
            Assert.assertEquals((String)"Expected correct rpc lock wait count", (long)3000L, (long)MetricsAsserts.getLongCounter("RpcLockWaitTimeNumOps", rpcMetrics));
            Assert.assertEquals((String)"Expected zero rpc lock wait time", (double)0.0, (double)MetricsAsserts.getDoubleGauge("RpcLockWaitTimeAvgTime", rpcMetrics), (double)0.001);
            MetricsAsserts.assertQuantileGauges("RpcQueueTime1s", rpcMetrics);
            MetricsAsserts.assertQuantileGauges("RpcProcessingTime1s", rpcMetrics);
            String actualUserVsCon = MetricsAsserts.getStringMetric("NumOpenConnectionsPerUser", rpcMetrics);
            String proxyUser = UserGroupInformation.getCurrentUser().getShortUserName();
            Assert.assertTrue((boolean)actualUserVsCon.contains("\"" + proxyUser + "\":1"));
            Assert.assertTrue((boolean)actualUserVsCon.contains("\"" + testUser + "\":1"));
            proxy.lockAndSleep(null, TestRPC.newSleepRequest(5));
            rpcMetrics = MetricsAsserts.getMetrics(server.getRpcMetrics().name());
            MetricsAsserts.assertGauge("RpcLockWaitTimeAvgTime", (double)RpcMetrics.TIMEUNIT.convert(10L, TimeUnit.SECONDS), rpcMetrics);
        }
        finally {
            if (proxy2 != null) {
                RPC.stopProxy((Object)proxy2);
            }
            TestRPC.stop((Server)server, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testClientBackOff() throws Exception {
        IOException lastException;
        boolean succeeded;
        block8: {
            succeeded = false;
            int numClients = 2;
            ArrayList<Future<Void>> res = new ArrayList<Future<Void>>();
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            conf.setInt("ipc.client.connect.max.retries", 0);
            conf.setBoolean("ipc.0.backoff.enable", true);
            RPC.Builder builder = TestRPC.newServerBuilder(conf).setQueueSizePerHandler(1).setNumHandlers(1).setVerbose(true);
            RPC.Server server = TestRPC.setupTestServer(builder);
            CallQueueManager spy = (CallQueueManager)Mockito.spy((Object)((CallQueueManager)Whitebox.getInternalState(server, "callQueue")));
            Whitebox.setInternalState(server, "callQueue", spy);
            lastException = null;
            final TestRpcBase.TestRpcService proxy = TestRPC.getClient(addr, conf);
            try {
                for (int i = 0; i < 2; ++i) {
                    res.add(executorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws ServiceException, InterruptedException {
                            proxy.sleep(null, TestRpcBase.newSleepRequest(100000));
                            return null;
                        }
                    }));
                    ((CallQueueManager)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((long)500L).times(i + 1))).addInternal((Schedulable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
                }
                try {
                    proxy.sleep(null, TestRPC.newSleepRequest(100));
                }
                catch (ServiceException e) {
                    RemoteException re = (RemoteException)e.getCause();
                    IOException unwrapExeption = re.unwrapRemoteException();
                    if (unwrapExeption instanceof RetriableException) {
                        succeeded = true;
                        break block8;
                    }
                    lastException = unwrapExeption;
                }
            }
            finally {
                executorService.shutdown();
                TestRPC.stop((Server)server, proxy);
            }
        }
        if (lastException != null) {
            LOG.error("Last received non-RetriableException:", (Throwable)lastException);
        }
        Assert.assertTrue((String)"RetriableException not received", (boolean)succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testClientBackOffByResponseTime() throws Exception {
        IOException lastException;
        boolean succeeded;
        block8: {
            succeeded = false;
            boolean numClients = true;
            GenericTestUtils.setLogLevel(DecayRpcScheduler.LOG, Level.DEBUG);
            GenericTestUtils.setLogLevel(RPC.LOG, Level.DEBUG);
            ArrayList<Future<Void>> res = new ArrayList<Future<Void>>();
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            conf.setInt("ipc.client.connect.max.retries", 0);
            String ns = "ipc.0";
            Server server = this.setupDecayRpcSchedulerandTestServer("ipc.0.");
            CallQueueManager spy = (CallQueueManager)Mockito.spy((Object)((CallQueueManager)Whitebox.getInternalState(server, "callQueue")));
            Whitebox.setInternalState(server, "callQueue", spy);
            lastException = null;
            final TestRpcBase.TestRpcService proxy = TestRPC.getClient(addr, conf);
            try {
                for (int i = 0; i < 1; ++i) {
                    res.add(executorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws ServiceException, InterruptedException {
                            proxy.sleep(null, TestRpcBase.newSleepRequest(3000));
                            return null;
                        }
                    }));
                    ((CallQueueManager)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((long)500L).times(i + 1))).addInternal((Schedulable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
                }
                try {
                    Thread.sleep(5500L);
                    proxy.sleep(null, TestRPC.newSleepRequest(100));
                }
                catch (ServiceException e) {
                    RemoteException re = (RemoteException)e.getCause();
                    IOException unwrapExeption = re.unwrapRemoteException();
                    if (unwrapExeption instanceof RetriableException) {
                        succeeded = true;
                        break block8;
                    }
                    lastException = unwrapExeption;
                }
            }
            finally {
                executorService.shutdown();
                TestRPC.stop(server, proxy);
            }
        }
        if (lastException != null) {
            LOG.error("Last received non-RetriableException:", (Throwable)lastException);
        }
        Assert.assertTrue((String)"RetriableException not received", (boolean)succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDecayRpcSchedulerMetrics() throws Exception {
        String ns = "ipc.0";
        Server server = this.setupDecayRpcSchedulerandTestServer("ipc.0.");
        MetricsRecordBuilder rb1 = MetricsAsserts.getMetrics("DecayRpcSchedulerMetrics2.ipc.0");
        long beginDecayedCallVolume = MetricsAsserts.getLongCounter("DecayedCallVolume", rb1);
        long beginRawCallVolume = MetricsAsserts.getLongCounter("CallVolume", rb1);
        int beginUniqueCaller = MetricsAsserts.getIntCounter("UniqueCallers", rb1);
        TestRpcBase.TestRpcService proxy = TestRPC.getClient(addr, conf);
        try {
            for (int i = 0; i < 2; ++i) {
                proxy.sleep(null, TestRPC.newSleepRequest(100));
            }
            GenericTestUtils.waitFor(() -> {
                MetricsRecordBuilder rb2 = MetricsAsserts.getMetrics("DecayRpcSchedulerMetrics2.ipc.0");
                long decayedCallVolume1 = MetricsAsserts.getLongCounter("DecayedCallVolume", rb2);
                long rawCallVolume1 = MetricsAsserts.getLongCounter("CallVolume", rb2);
                int uniqueCaller1 = MetricsAsserts.getIntCounter("UniqueCallers", rb2);
                long callVolumePriority0 = MetricsAsserts.getLongGauge("Priority.0.CompletedCallVolume", rb2);
                long callVolumePriority1 = MetricsAsserts.getLongGauge("Priority.1.CompletedCallVolume", rb2);
                double avgRespTimePriority0 = MetricsAsserts.getDoubleGauge("Priority.0.AvgResponseTime", rb2);
                double avgRespTimePriority1 = MetricsAsserts.getDoubleGauge("Priority.1.AvgResponseTime", rb2);
                LOG.info("DecayedCallVolume: {}", (Object)decayedCallVolume1);
                LOG.info("CallVolume: {}", (Object)rawCallVolume1);
                LOG.info("UniqueCaller: {}", (Object)uniqueCaller1);
                LOG.info("Priority.0.CompletedCallVolume: {}", (Object)callVolumePriority0);
                LOG.info("Priority.1.CompletedCallVolume: {}", (Object)callVolumePriority1);
                LOG.info("Priority.0.AvgResponseTime: {}", (Object)avgRespTimePriority0);
                LOG.info("Priority.1.AvgResponseTime: {}", (Object)avgRespTimePriority1);
                return decayedCallVolume1 > beginDecayedCallVolume && rawCallVolume1 > beginRawCallVolume && uniqueCaller1 > beginUniqueCaller;
            }, 30L, 60000L);
        }
        finally {
            TestRPC.stop(server, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testProtocolUserPriority() throws Exception {
        String ns = "ipc.0";
        conf.set("test.ipc.client.principal", "clientForProtocol");
        Server server = null;
        try {
            server = this.setupDecayRpcSchedulerandTestServer("ipc.0.");
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"user");
            Assert.assertEquals((long)0L, (long)server.getPriorityLevel(ugi));
            Assert.assertEquals((long)0L, (long)server.getPriorityLevel(TestRPC.newSchedulable(ugi)));
            ugi = UserGroupInformation.createRemoteUser((String)"clientForProtocol");
            Assert.assertEquals((long)-1L, (long)server.getPriorityLevel(ugi));
            Assert.assertEquals((long)0L, (long)server.getPriorityLevel(TestRPC.newSchedulable(ugi)));
        }
        finally {
            TestRPC.stop(server, null);
        }
    }

    private static Schedulable newSchedulable(final UserGroupInformation ugi) {
        return new Schedulable(){

            public UserGroupInformation getUserGroupInformation() {
                return ugi;
            }

            public int getPriorityLevel() {
                return 0;
            }
        };
    }

    private Server setupDecayRpcSchedulerandTestServer(String ns) throws Exception {
        int queueSizePerHandler = 3;
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setBoolean(ns + "backoff.enable", true);
        conf.setStrings(ns + "callqueue.impl", new String[]{"org.apache.hadoop.ipc.FairCallQueue"});
        conf.setStrings(ns + "scheduler.impl", new String[]{"org.apache.hadoop.ipc.DecayRpcScheduler"});
        conf.setInt(ns + "scheduler.priority.levels", 2);
        conf.setBoolean(ns + "decay-scheduler.backoff.responsetime.enable", true);
        conf.set(ns + "decay-scheduler.backoff.responsetime.thresholds", "2s, 4s");
        RPC.Builder builder = TestRPC.newServerBuilder(conf).setQueueSizePerHandler(3).setNumHandlers(1).setVerbose(true);
        return TestRPC.setupTestServer(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testClientRpcTimeout() throws Exception {
        TestRpcBase.TestRpcService proxy = null;
        RPC.Builder builder = TestRPC.newServerBuilder(conf).setQueueSizePerHandler(1).setNumHandlers(1).setVerbose(true);
        RPC.Server server = TestRPC.setupTestServer(builder);
        try {
            Configuration c;
            try {
                c = new Configuration(conf);
                c.setInt("ipc.client.rpc-timeout.ms", 1000);
                proxy = TestRPC.getClient(addr, c);
                proxy.sleep(null, TestRPC.newSleepRequest(3000));
                Assert.fail((String)"RPC should time out.");
            }
            catch (ServiceException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
                LOG.info("got expected timeout.", (Throwable)e);
            }
            try {
                c = new Configuration(conf);
                c.setBoolean("ipc.client.ping", false);
                c.setInt("ipc.client.rpc-timeout.ms", 1000);
                proxy = TestRPC.getClient(addr, c);
                proxy.sleep(null, TestRPC.newSleepRequest(3000));
                Assert.fail((String)"RPC should time out.");
            }
            catch (ServiceException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
                LOG.info("got expected timeout.", (Throwable)e);
            }
            try {
                c = new Configuration(conf);
                c.setInt("ipc.client.rpc-timeout.ms", -1);
                proxy = TestRPC.getClient(addr, c);
                proxy.sleep(null, TestRPC.newSleepRequest(2000));
            }
            catch (ServiceException e) {
                LOG.info("got unexpected exception.", (Throwable)e);
                Assert.fail((String)"RPC should not time out.");
            }
            try {
                c = new Configuration(conf);
                c.setBoolean("ipc.client.ping", true);
                c.setInt("ipc.ping.interval", 800);
                c.setInt("ipc.client.rpc-timeout.ms", 1000);
                proxy = TestRPC.getClient(addr, c);
                try {
                    proxy.sleep(null, TestRPC.newSleepRequest(1300));
                }
                catch (ServiceException e) {
                    LOG.info("got unexpected exception.", (Throwable)e);
                    Assert.fail((String)"RPC should not time out.");
                }
                proxy.sleep(null, TestRPC.newSleepRequest(2000));
                Assert.fail((String)"RPC should time out.");
            }
            catch (ServiceException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
                LOG.info("got expected timeout.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            TestRPC.stop((Server)server, proxy);
            throw throwable;
        }
        TestRPC.stop((Server)server, proxy);
    }

    @Test
    public void testServerNameFromClass() {
        Assert.assertEquals((Object)"TestRPC", (Object)RPC.Server.serverNameFromClass(this.getClass()));
        Assert.assertEquals((Object)"TestClass", (Object)RPC.Server.serverNameFromClass(TestClass.class));
        Object testing = new TestClass().classFactory();
        Assert.assertEquals((Object)"Embedded", (Object)RPC.Server.serverNameFromClass(testing.getClass()));
        testing = new TestClass().classFactoryAbstract();
        Assert.assertEquals((Object)"TestClass", (Object)RPC.Server.serverNameFromClass(testing.getClass()));
        testing = new TestClass().classFactoryObject();
        Assert.assertEquals((Object)"TestClass", (Object)RPC.Server.serverNameFromClass(testing.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReaderExceptions() throws Exception {
        RPC.Server server = null;
        TestRpcBase.TestRpcService proxy = null;
        TestReaderException expectedIOE = new TestReaderException("testing123");
        RpcServerException rseError = new RpcServerException("keepalive", expectedIOE){

            public RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto getRpcStatusProto() {
                return RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR;
            }
        };
        RpcServerException rseFatal = new RpcServerException("disconnect", expectedIOE){

            public RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto getRpcStatusProto() {
                return RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL;
            }
        };
        try {
            RPC.Builder builder = TestRPC.newServerBuilder(conf).setQueueSizePerHandler(1).setNumHandlers(1).setVerbose(true);
            server = TestRPC.setupTestServer(builder);
            Whitebox.setInternalState(server, "rpcRequestClass", FakeRequestClass.class);
            MutableCounterLong authMetric = (MutableCounterLong)Whitebox.getInternalState(server.getRpcMetrics(), "rpcAuthorizationSuccesses");
            proxy = TestRPC.getClient(addr, conf);
            boolean isDisconnected = true;
            Server.Connection lastConn = null;
            long expectedAuths = 0L;
            for (int i = 0; i < 128; ++i) {
                String reqName = "request[" + i + "]";
                int r = ThreadLocalRandom.current().nextInt();
                boolean doDisconnect = r % 4 == 0;
                LOG.info("TestDisconnect request[" + i + "]  shouldConnect=" + isDisconnected + " willDisconnect=" + doDisconnect);
                if (isDisconnected) {
                    ++expectedAuths;
                }
                try {
                    FakeRequestClass.exception = doDisconnect ? rseFatal : rseError;
                    proxy.ping(null, TestRPC.newEmptyRequest());
                    Assert.fail((String)(reqName + " didn't fail"));
                }
                catch (ServiceException e) {
                    RemoteException re = (RemoteException)e.getCause();
                    Assert.assertEquals((String)reqName, (Object)expectedIOE, (Object)re.unwrapRemoteException());
                }
                Assert.assertEquals((String)reqName, (long)expectedAuths, (long)authMetric.value());
                if (!doDisconnect) {
                    Server.Connection[] conns = server.getConnections();
                    Assert.assertEquals((String)reqName, (long)1L, (long)conns.length);
                    if (isDisconnected) {
                        Assert.assertNotSame((String)reqName, lastConn, (Object)conns[0]);
                    } else {
                        Assert.assertSame((String)reqName, lastConn, (Object)conns[0]);
                    }
                    lastConn = conns[0];
                } else if (lastConn != null) {
                    Assert.assertTrue((String)reqName, (boolean)lastConn.shouldClose());
                }
                isDisconnected = doDisconnect;
            }
        }
        catch (Throwable throwable) {
            TestRPC.stop(server, proxy);
            throw throwable;
        }
        TestRPC.stop((Server)server, proxy);
    }

    @Test
    public void testSetProtocolEngine() {
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, StoppedProtocol.class, StoppedRpcEngine.class);
        RpcEngine rpcEngine = RPC.getProtocolEngine(StoppedProtocol.class, (Configuration)conf);
        Assert.assertTrue((boolean)(rpcEngine instanceof StoppedRpcEngine));
        RPC.setProtocolEngine((Configuration)conf, StoppedProtocol.class, ProtobufRpcEngine.class);
        rpcEngine = RPC.getProtocolEngine(StoppedProtocol.class, (Configuration)conf);
        Assert.assertTrue((boolean)(rpcEngine instanceof StoppedRpcEngine));
    }

    public static void main(String[] args) throws Exception {
        new TestRPC().testCallsInternal(conf);
    }

    public static class TestReaderException
    extends IOException {
        public TestReaderException(String msg) {
            super(msg);
        }

        public boolean equals(Object t) {
            return t.getClass() == TestReaderException.class && this.getMessage().equals(((TestReaderException)t).getMessage());
        }
    }

    public static class FakeRequestClass
    extends RpcWritable {
        static volatile IOException exception;

        void writeTo(ResponseBuffer out) throws IOException {
            throw new UnsupportedOperationException();
        }

        <T> T readFrom(ByteBuffer bb) throws IOException {
            throw exception;
        }
    }

    static class TestClass {
        TestClass() {
        }

        private Object classFactory() {
            return new Embedded();
        }

        private Object classFactoryAbstract() {
            return new AbstractEmbedded(){};
        }

        private Object classFactoryObject() {
            return new Object(){};
        }

        abstract class AbstractEmbedded {
            AbstractEmbedded() {
            }
        }

        class Embedded {
            Embedded() {
            }
        }
    }

    private static class TestPolicyProvider
    extends PolicyProvider {
        private TestPolicyProvider() {
        }

        public Service[] getServices() {
            return new Service[]{new Service(TestRPC.ACL_CONFIG, TestRpcBase.TestRpcService.class)};
        }
    }

    private static class StoppedInvocationHandler
    implements InvocationHandler,
    Closeable {
        private int closeCalled = 0;

        private StoppedInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }

        @Override
        public void close() throws IOException {
            ++this.closeCalled;
        }

        public int getCloseCalled() {
            return this.closeCalled;
        }
    }

    private static class StoppedRpcEngine
    implements RpcEngine {
        private StoppedRpcEngine() {
        }

        public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
            return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null, null);
        }

        public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
            Object proxy = Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new StoppedInvocationHandler());
            return new ProtocolProxy(protocol, proxy, false);
        }

        public RPC.Server getServer(Class<?> protocol, Object instance, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig, AlignmentContext alignmentContext) throws IOException {
            return null;
        }

        public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
            throw new UnsupportedOperationException("This proxy is not supported");
        }
    }

    private static interface StoppedProtocol {
        public static final long versionID = 0L;

        public void stop();
    }

    static class SlowRPC
    implements Runnable {
        private TestRpcBase.TestRpcService proxy;
        private volatile boolean done;

        SlowRPC(TestRpcBase.TestRpcService proxy) {
            this.proxy = proxy;
            this.done = false;
        }

        boolean isDone() {
            return this.done;
        }

        @Override
        public void run() {
            try {
                this.ping(true);
                this.done = true;
            }
            catch (ServiceException e) {
                Assert.assertTrue((String)("SlowRPC ping exception " + (Object)((Object)e)), (boolean)false);
            }
        }

        void ping(boolean shouldSlow) throws ServiceException {
            this.proxy.slowPing(null, TestRpcBase.newSlowPingRequest(shouldSlow));
        }
    }

    static class Transactions
    implements Runnable {
        int datasize;
        TestRpcBase.TestRpcService proxy;

        Transactions(TestRpcBase.TestRpcService proxy, int datasize) {
            this.proxy = proxy;
            this.datasize = datasize;
        }

        @Override
        public void run() {
            Object[] indata = new Integer[this.datasize];
            Arrays.fill(indata, (Object)123);
            TestProtos.ExchangeRequestProto exchangeRequest = TestProtos.ExchangeRequestProto.newBuilder().addAllValues(Arrays.asList(indata)).build();
            Integer[] outdata = null;
            TestProtos.AddRequestProto addRequest = TestProtos.AddRequestProto.newBuilder().setParam1(1).setParam2(2).build();
            int val = 0;
            try {
                TestProtos.ExchangeResponseProto exchangeResponse = this.proxy.exchange(null, exchangeRequest);
                outdata = new Integer[exchangeResponse.getValuesCount()];
                outdata = exchangeResponse.getValuesList().toArray(outdata);
                TestProtos.AddResponseProto addResponse = this.proxy.add(null, addRequest);
                val = addResponse.getResult();
            }
            catch (ServiceException e) {
                Assert.assertTrue((String)("Exception from RPC exchange() " + (Object)((Object)e)), (boolean)false);
            }
            Assert.assertEquals((long)indata.length, (long)outdata.length);
            Assert.assertEquals((long)3L, (long)val);
            for (int i = 0; i < outdata.length; ++i) {
                Assert.assertEquals((long)outdata[i].intValue(), (long)i);
            }
        }
    }

    public static class TestImpl
    implements TestProtocol {
        int fastPingCounter = 0;

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 1L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int hashcode) {
            return new ProtocolSignature(1L, null);
        }

        @Override
        public void ping() {
        }

        @Override
        public void sleep(long delay) throws InterruptedException {
            Thread.sleep(delay);
        }

        @Override
        public String echo(String value) throws IOException {
            return value;
        }

        @Override
        public String[] echo(String[] values) throws IOException {
            return values;
        }

        @Override
        public Writable echo(Writable writable) {
            return writable;
        }

        @Override
        public int add(int v1, int v2) {
            return v1 + v2;
        }

        @Override
        public int add(int[] values) {
            int sum = 0;
            for (int i = 0; i < values.length; ++i) {
                sum += values[i];
            }
            return sum;
        }

        @Override
        public int error() throws IOException {
            throw new IOException("bobo");
        }
    }

    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public void ping() throws IOException;

        public void sleep(long var1) throws IOException, InterruptedException;

        public String echo(String var1) throws IOException;

        public String[] echo(String[] var1) throws IOException;

        public Writable echo(Writable var1) throws IOException;

        public int add(int var1, int var2) throws IOException;

        public int add(int[] var1) throws IOException;

        public int error() throws IOException;
    }
}

