/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import org.apache.hadoop.log.LogThrottlingHelper;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogThrottlingHelper {
    private static final int LOG_PERIOD = 100;
    private LogThrottlingHelper helper;
    private FakeTimer timer;

    @Before
    public void setup() {
        this.timer = new FakeTimer();
        this.helper = new LogThrottlingHelper(100L, null, (Timer)this.timer);
    }

    @Test
    public void testBasicLogging() {
        Assert.assertTrue((boolean)this.helper.record(new double[0]).shouldLog());
        for (int i = 0; i < 5; ++i) {
            this.timer.advance(10L);
            Assert.assertFalse((boolean)this.helper.record(new double[0]).shouldLog());
        }
        this.timer.advance(100L);
        Assert.assertTrue((boolean)this.helper.record(new double[0]).shouldLog());
    }

    @Test
    public void testLoggingWithValue() {
        Assert.assertTrue((boolean)this.helper.record(new double[]{1.0}).shouldLog());
        for (int i = 0; i < 4; ++i) {
            this.timer.advance(20L);
            Assert.assertFalse((boolean)this.helper.record(new double[]{i % 2 == 0 ? 0.0 : 1.0}).shouldLog());
        }
        this.timer.advance(100L);
        LogThrottlingHelper.LogAction action = this.helper.record(new double[]{0.5});
        Assert.assertTrue((boolean)action.shouldLog());
        Assert.assertEquals((long)5L, (long)action.getCount());
        Assert.assertEquals((double)0.5, (double)action.getStats(0).getMean(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)action.getStats(0).getMax(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)action.getStats(0).getMin(), (double)0.01);
    }

    @Test
    public void testLoggingWithMultipleValues() {
        Assert.assertTrue((boolean)this.helper.record(new double[]{1.0}).shouldLog());
        for (int i = 0; i < 4; ++i) {
            this.timer.advance(20L);
            int base = i % 2 == 0 ? 0 : 1;
            Assert.assertFalse((boolean)this.helper.record(new double[]{base, base * 2}).shouldLog());
        }
        this.timer.advance(100L);
        LogThrottlingHelper.LogAction action = this.helper.record(new double[]{0.5, 1.0});
        Assert.assertTrue((boolean)action.shouldLog());
        Assert.assertEquals((long)5L, (long)action.getCount());
        for (int i = 1; i <= 2; ++i) {
            Assert.assertEquals((double)(0.5 * (double)i), (double)action.getStats(i - 1).getMean(), (double)0.01);
            Assert.assertEquals((double)(1.0 * (double)i), (double)action.getStats(i - 1).getMax(), (double)0.01);
            Assert.assertEquals((double)0.0, (double)action.getStats(i - 1).getMin(), (double)0.01);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoggingWithInconsistentValues() {
        Assert.assertTrue((boolean)this.helper.record(new double[]{1.0, 2.0}).shouldLog());
        this.helper.record(new double[]{1.0, 2.0});
        this.helper.record(new double[]{1.0, 2.0, 3.0});
    }

    @Test
    public void testNamedLoggersWithoutSpecifiedPrimary() {
        Assert.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("foo", 50L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 50L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("foo", 100L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 100L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("foo", 150L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 150L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("foo", 200L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
    }

    @Test
    public void testPrimaryAndDependentLoggers() {
        this.helper = new LogThrottlingHelper(100L, "foo", (Timer)this.timer);
        Assert.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("foo", 50L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 50L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("foo", 100L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 100L, new double[0]).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("foo", 200L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
    }

    @Test
    public void testMultipleLoggersWithValues() {
        this.helper = new LogThrottlingHelper(100L, "foo", (Timer)this.timer);
        Assert.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("bar", 0L, new double[]{2.0}).shouldLog());
        Assert.assertTrue((boolean)this.helper.record("baz", 0L, new double[]{3.0, 3.0}).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("bar", 100L, new double[]{2.0}).shouldLog());
        Assert.assertFalse((boolean)this.helper.record("baz", 100L, new double[]{3.0, 3.0}).shouldLog());
        LogThrottlingHelper.LogAction foo = this.helper.record("foo", 100L, new double[0]);
        LogThrottlingHelper.LogAction bar = this.helper.record("bar", 100L, new double[]{2.0});
        LogThrottlingHelper.LogAction baz = this.helper.record("baz", 100L, new double[]{3.0, 3.0});
        Assert.assertTrue((boolean)foo.shouldLog());
        Assert.assertTrue((boolean)bar.shouldLog());
        Assert.assertTrue((boolean)baz.shouldLog());
        Assert.assertEquals((long)1L, (long)foo.getCount());
        Assert.assertEquals((long)2L, (long)bar.getCount());
        Assert.assertEquals((long)2L, (long)baz.getCount());
        Assert.assertEquals((double)2.0, (double)bar.getStats(0).getMean(), (double)0.01);
        Assert.assertEquals((double)3.0, (double)baz.getStats(0).getMean(), (double)0.01);
        Assert.assertEquals((double)3.0, (double)baz.getStats(1).getMean(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)this.helper.getCurrentStats("bar", 0).getMax(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)this.helper.getCurrentStats("baz", 0).getMax(), (double)0.0);
    }
}

