/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.sink.PrometheusMetricsSink;
import org.junit.Assert;
import org.junit.Test;

public class TestPrometheusMetricsSink {
    @Test
    public void testPublish() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        metrics.register("Prometheus", "Prometheus", (MetricsSink)sink);
        TestMetrics testMetrics = (TestMetrics)metrics.register("TestMetrics", "Testing metrics", (Object)new TestMetrics());
        metrics.start();
        testMetrics.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        sink.writeMetrics((Writer)writer);
        writer.flush();
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        Assert.assertTrue((String)"The expected metric line is missing from prometheus metrics output", (boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\""));
        metrics.stop();
        metrics.shutdown();
    }

    @Test
    public void testNamingCamelCase() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        Assert.assertEquals((Object)"rpc_time_some_metrics", (Object)sink.prometheusName("RpcTime", "SomeMetrics"));
        Assert.assertEquals((Object)"om_rpc_time_om_info_keys", (Object)sink.prometheusName("OMRpcTime", "OMInfoKeys"));
        Assert.assertEquals((Object)"rpc_time_small", (Object)sink.prometheusName("RpcTime", "small"));
    }

    @Test
    public void testNamingPipeline() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "SCMPipelineMetrics";
        String metricName = "NumBlocksAllocated-RATIS-THREE-47659e3d-40c9-43b3-9792-4982fc279aba";
        Assert.assertEquals((Object)"scm_pipeline_metrics_num_blocks_allocated_ratis_three_47659e3d_40c9_43b3_9792_4982fc279aba", (Object)sink.prometheusName(recordName, metricName));
    }

    @Test
    public void testNamingPeriods() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl";
        String metricName = "DfsUsed";
        Assert.assertEquals((Object)"org_apache_hadoop_hdfs_server_datanode_fsdataset_impl_fs_dataset_impl_dfs_used", (Object)sink.prometheusName(recordName, metricName));
    }

    @Test
    public void testNamingWhitespaces() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "JvmMetrics";
        String metricName = "GcCountG1 Old Generation";
        Assert.assertEquals((Object)"jvm_metrics_gc_count_g1_old_generation", (Object)sink.prometheusName(recordName, metricName));
    }

    @Metrics(about="Test Metrics", context="dfs")
    private static class TestMetrics {
        @Metric
        private MutableCounterLong numBucketCreateFails;

        private TestMetrics() {
        }
    }
}

