/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GenerateDistCacheData
extends GridmixJob {
    static final String GRIDMIX_DISTCACHE_FILE_COUNT = "gridmix.distcache.file.count";
    static final String GRIDMIX_DISTCACHE_BYTE_COUNT = "gridmix.distcache.byte.count";
    static final String GRIDMIX_DISTCACHE_FILE_LIST = "gridmix.distcache.file.list";
    static final String JOB_NAME = "GRIDMIX_GENERATE_DISTCACHE_DATA";
    static final short GRIDMIX_DISTCACHE_FILE_PERM = 420;
    private static final Charset charsetUTF8 = Charset.forName("UTF-8");

    public GenerateDistCacheData(Configuration conf) throws IOException {
        super(conf, 0L, JOB_NAME);
    }

    @Override
    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws IOException, ClassNotFoundException, InterruptedException {
                GenerateDistCacheData.this.job.setMapperClass(GenDCDataMapper.class);
                GenerateDistCacheData.this.job.setNumReduceTasks(0);
                GenerateDistCacheData.this.job.setMapOutputKeyClass(NullWritable.class);
                GenerateDistCacheData.this.job.setMapOutputValueClass(BytesWritable.class);
                GenerateDistCacheData.this.job.setInputFormatClass(GenDCDataFormat.class);
                GenerateDistCacheData.this.job.setOutputFormatClass(NullOutputFormat.class);
                GenerateDistCacheData.this.job.setJarByClass(GenerateDistCacheData.class);
                try {
                    FileInputFormat.addInputPath((Job)GenerateDistCacheData.this.job, (Path)new Path("ignored"));
                }
                catch (IOException e) {
                    GridmixJob.LOG.error((Object)"Error while adding input path ", (Throwable)e);
                }
                GenerateDistCacheData.this.job.submit();
                return GenerateDistCacheData.this.job;
            }
        });
        return this.job;
    }

    @Override
    protected boolean canEmulateCompression() {
        return false;
    }

    static class GenDCDataFormat
    extends InputFormat<LongWritable, BytesWritable> {
        GenDCDataFormat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<InputSplit> getSplits(JobContext jobCtxt) throws IOException {
            JobConf jobConf = new JobConf(jobCtxt.getConfiguration());
            JobClient client = new JobClient(jobConf);
            ClusterStatus stat = client.getClusterStatus(true);
            int numTrackers = stat.getTaskTrackers();
            int fileCount = jobConf.getInt(GenerateDistCacheData.GRIDMIX_DISTCACHE_FILE_COUNT, -1);
            long totalSize = jobConf.getLong(GenerateDistCacheData.GRIDMIX_DISTCACHE_BYTE_COUNT, -1L);
            String distCacheFileList = jobConf.get(GenerateDistCacheData.GRIDMIX_DISTCACHE_FILE_LIST);
            if (fileCount < 0 || totalSize < 0L || distCacheFileList == null) {
                throw new RuntimeException("Invalid metadata: #files (" + fileCount + "), total_size (" + totalSize + "), filelisturi (" + distCacheFileList + ")");
            }
            Path sequenceFile = new Path(distCacheFileList);
            FileSystem fs = sequenceFile.getFileSystem((Configuration)jobConf);
            FileStatus srcst = fs.getFileStatus(sequenceFile);
            int numMapSlotsPerTracker = jobConf.getInt("mapreduce.tasktracker.map.tasks.maximum", 2);
            int numSplits = numTrackers * numMapSlotsPerTracker;
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
            LongWritable key = new LongWritable();
            BytesWritable value = new BytesWritable();
            long targetSize = Math.max(totalSize / (long)numSplits, 0x8000000L);
            long splitStartPosition = 0L;
            long splitEndPosition = 0L;
            long acc = 0L;
            long bytesRemaining = srcst.getLen();
            try (SequenceFile.Reader reader = null;){
                reader = new SequenceFile.Reader(fs, sequenceFile, (Configuration)jobConf);
                while (reader.next((Writable)key, (Writable)value)) {
                    if (acc + key.get() > targetSize && acc != 0L) {
                        long splitSize = splitEndPosition - splitStartPosition;
                        splits.add((InputSplit)new FileSplit(sequenceFile, splitStartPosition, splitSize, (String[])null));
                        bytesRemaining -= splitSize;
                        splitStartPosition = splitEndPosition;
                        acc = 0L;
                    }
                    acc += key.get();
                    splitEndPosition = reader.getPosition();
                }
            }
            if (bytesRemaining != 0L) {
                splits.add((InputSplit)new FileSplit(sequenceFile, splitStartPosition, bytesRemaining, (String[])null));
            }
            return splits;
        }

        public RecordReader<LongWritable, BytesWritable> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
            return new SequenceFileRecordReader();
        }
    }

    public static class GenDCDataMapper
    extends Mapper<LongWritable, BytesWritable, NullWritable, BytesWritable> {
        private BytesWritable val;
        private final Random r = new Random();
        private FileSystem fs;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.val = new BytesWritable(new byte[context.getConfiguration().getInt("gendata.val.bytes", 0x100000)]);
            this.fs = FileSystem.get((Configuration)context.getConfiguration());
        }

        public void map(LongWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            String fileName = new String(value.getBytes(), 0, value.getLength(), charsetUTF8);
            Path path = new Path(fileName);
            FSDataOutputStream dos = FileSystem.create((FileSystem)this.fs, (Path)path, (FsPermission)new FsPermission(420));
            int size = 0;
            for (long bytes = key.get(); bytes > 0L; bytes -= (long)size) {
                this.r.nextBytes(this.val.getBytes());
                size = (int)Math.min((long)this.val.getLength(), bytes);
                dos.write(this.val.getBytes(), 0, size);
            }
            dos.close();
        }
    }
}

