/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;

@InterfaceAudience.Private
public class ClientDatanodeProtocolServerSideTranslatorPB
implements ClientDatanodeProtocolPB {
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto REFRESH_NAMENODE_RESP = ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto DELETE_BLOCKPOOL_RESP = ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto.newBuilder().build();
    private final ClientDatanodeProtocol impl;

    public ClientDatanodeProtocolServerSideTranslatorPB(ClientDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto getReplicaVisibleLength(RpcController unused, ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto request) throws ServiceException {
        long len;
        try {
            len = this.impl.getReplicaVisibleLength(PBHelper.convert(request.getBlock()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(len).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto refreshNamenodes(RpcController unused, ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto request) throws ServiceException {
        try {
            this.impl.refreshNamenodes();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return REFRESH_NAMENODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto deleteBlockPool(RpcController unused, ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto request) throws ServiceException {
        try {
            this.impl.deleteBlockPool(request.getBlockPool(), request.getForce());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return DELETE_BLOCKPOOL_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto getBlockLocalPathInfo(RpcController unused, ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto request) throws ServiceException {
        BlockLocalPathInfo resp;
        try {
            resp = this.impl.getBlockLocalPathInfo(PBHelper.convert(request.getBlock()), PBHelper.convert(request.getToken()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto.newBuilder().setBlock(PBHelper.convert(resp.getBlock())).setLocalPath(resp.getBlockPath()).setLocalMetaPath(resp.getMetaPath()).build();
    }
}

