/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;

class BackupJournalManager
implements JournalManager {
    private final NamenodeRegistration bnReg;
    private final JournalInfo journalInfo;

    BackupJournalManager(NamenodeRegistration bnReg, NamenodeRegistration nnReg) {
        this.journalInfo = new JournalInfo(nnReg.getLayoutVersion(), nnReg.getClusterID(), nnReg.getNamespaceID());
        this.bnReg = bnReg;
    }

    @Override
    public EditLogOutputStream startLogSegment(long txId) throws IOException {
        EditLogBackupOutputStream stm = new EditLogBackupOutputStream(this.bnReg, this.journalInfo);
        stm.startLogSegment(txId);
        return stm;
    }

    @Override
    public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
    }

    @Override
    public void setOutputBufferCapacity(int size) {
    }

    @Override
    public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
    }

    @Override
    public long getNumberOfTransactions(long fromTxnId, boolean inProgressOk) throws IOException, JournalManager.CorruptionException {
        return 0L;
    }

    @Override
    public EditLogInputStream getInputStream(long fromTxnId, boolean inProgressOk) throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public void recoverUnfinalizedSegments() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public boolean matchesRegistration(NamenodeRegistration bnReg) {
        return bnReg.getAddress().equals(this.bnReg.getAddress());
    }

    public String toString() {
        return "BackupJournalManager";
    }
}

