/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.DepthCounter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;

class IndentedImageVisitor
extends TextWriterImageVisitor {
    private final DepthCounter dc = new DepthCounter();
    private static final String[] indents = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            "};

    public IndentedImageVisitor(String filename) throws IOException {
        super(filename);
    }

    public IndentedImageVisitor(String filename, boolean printToScreen) throws IOException {
        super(filename, printToScreen);
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void finish() throws IOException {
        super.finish();
    }

    @Override
    void finishAbnormally() throws IOException {
        System.out.println("*** Image processing finished abnormally.  Ending ***");
        super.finishAbnormally();
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        this.dc.decLevel();
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        this.printIndents();
        this.write((Object)((Object)element) + " = " + value + "\n");
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        this.printIndents();
        this.write((Object)((Object)element) + "\n");
        this.dc.incLevel();
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        this.printIndents();
        this.write((Object)((Object)element) + " [" + (Object)((Object)key) + " = " + value + "]\n");
        this.dc.incLevel();
    }

    private void printIndents() throws IOException {
        try {
            this.write(indents[this.dc.getLevel()]);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = 0; i < this.dc.getLevel(); ++i) {
                this.write(" ");
            }
        }
    }
}

