/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

class FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final UserGroupInformation ugi;
    public final String user;
    private final Set<String> groups = new HashSet<String>();
    public final boolean isSuper;

    FSPermissionChecker(String fsOwner, String supergroup) throws AccessControlException {
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new AccessControlException((Throwable)e);
        }
        this.groups.addAll(Arrays.asList(this.ugi.getGroupNames()));
        this.user = this.ugi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public static void checkSuperuserPrivilege(UserGroupInformation owner, String supergroup) throws AccessControlException {
        FSPermissionChecker checker = new FSPermissionChecker(owner.getShortUserName(), supergroup);
        if (!checker.isSuper) {
            throw new AccessControlException("Access denied for user " + checker.user + ". Superuser privilege is required");
        }
    }

    void checkPermission(String path, INodeDirectory root, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        int ancestorIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess));
        }
        INode[] inodes = root.getExistingPathINodes(path, true);
        for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
        }
        this.checkTraverse(inodes, ancestorIndex);
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodes.length > 1 && inodes[inodes.length - 1] != null) {
            this.checkStickyBit(inodes[inodes.length - 2], inodes[inodes.length - 1]);
        }
        if (ancestorAccess != null && inodes.length > 1) {
            this.check(inodes, ancestorIndex, ancestorAccess);
        }
        if (parentAccess != null && inodes.length > 1) {
            this.check(inodes, inodes.length - 2, parentAccess);
        }
        if (access != null) {
            this.check(inodes[inodes.length - 1], access);
        }
        if (subAccess != null) {
            this.checkSubAccess(inodes[inodes.length - 1], subAccess);
        }
        if (doCheckOwner) {
            this.checkOwner(inodes[inodes.length - 1]);
        }
    }

    private void checkOwner(INode inode) throws AccessControlException {
        if (inode != null && this.user.equals(inode.getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied");
    }

    private void checkTraverse(INode[] inodes, int last) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(INode inode, FsAction access) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push((INodeDirectory)inode);
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            this.check(d, access);
            for (INode child : d.getChildrenList()) {
                if (!child.isDirectory()) continue;
                directories.push((INodeDirectory)child);
            }
        }
    }

    private void check(INode[] inodes, int i, FsAction access) throws AccessControlException {
        this.check(i >= 0 ? inodes[i] : null, access);
    }

    private void check(INode inode, FsAction access) throws AccessControlException {
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission();
        if (this.user.equals(inode.getUserName()) ? mode.getUserAction().implies(access) : (this.groups.contains(inode.getGroupName()) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException("Permission denied: user=" + this.user + ", access=" + access + ", inode=" + inode);
    }

    private void checkStickyBit(INode parent, INode inode) throws AccessControlException {
        if (!parent.getFsPermission().getStickyBit()) {
            return;
        }
        if (parent.getUserName().equals(this.user)) {
            return;
        }
        if (inode.getUserName().equals(this.user)) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + this.user + ", inode=" + inode);
    }
}

