/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FSLimitException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;

    protected FSLimitException() {
    }

    protected FSLimitException(String msg) {
        super(msg);
    }

    protected FSLimitException(long quota, long count) {
        super(quota, count);
    }

    public static final class MaxDirectoryItemsExceededException
    extends FSLimitException {
        protected static final long serialVersionUID = 1L;

        protected MaxDirectoryItemsExceededException() {
        }

        protected MaxDirectoryItemsExceededException(String msg) {
            super(msg);
        }

        public MaxDirectoryItemsExceededException(long quota, long count) {
            super(quota, count);
        }

        @Override
        public String getMessage() {
            return "The directory item limit of " + this.pathName + " is exceeded: limit=" + this.quota + " items=" + this.count;
        }
    }

    public static final class PathComponentTooLongException
    extends FSLimitException {
        protected static final long serialVersionUID = 1L;

        protected PathComponentTooLongException() {
        }

        protected PathComponentTooLongException(String msg) {
            super(msg);
        }

        public PathComponentTooLongException(long quota, long count) {
            super(quota, count);
        }

        @Override
        public String getMessage() {
            Path violator = new Path(this.pathName);
            return "The maximum path component name limit of " + violator.getName() + " in directory " + violator.getParent() + " is exceeded: limit=" + this.quota + " length=" + this.count;
        }
    }
}

