/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.net.Inet4Address;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAuditLogAtDebug {
    static final Log LOG = LogFactory.getLog(TestAuditLogAtDebug.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    private static final String DUMMY_COMMAND_1 = "dummycommand1";
    private static final String DUMMY_COMMAND_2 = "dummycommand2";

    private FSNamesystem.DefaultAuditLogger makeSpyLogger(Level level, Optional<List<String>> debugCommands) {
        FSNamesystem.DefaultAuditLogger logger = new FSNamesystem.DefaultAuditLogger();
        HdfsConfiguration conf = new HdfsConfiguration();
        if (debugCommands.isPresent()) {
            conf.set("dfs.namenode.audit.log.debug.cmdlist", Joiner.on((String)",").join((Iterable)debugCommands.get()));
        }
        logger.initialize((Configuration)conf);
        GenericTestUtils.setLogLevel((Log)FSNamesystem.auditLog, (Level)level);
        return (FSNamesystem.DefaultAuditLogger)Mockito.spy((Object)logger);
    }

    private void logDummyCommandToAuditLog(HdfsAuditLogger logger, String command) {
        logger.logAuditEvent(true, "", Inet4Address.getLoopbackAddress(), command, "", "", null, null, null, null);
    }

    @Test
    public void testDebugCommandNotLoggedAtInfo() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, (Optional<List<String>>)Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).logAuditMessage(Matchers.anyString());
    }

    @Test
    public void testDebugCommandLoggedAtDebug() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.DEBUG, (Optional<List<String>>)Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).logAuditMessage(Matchers.anyString());
    }

    @Test
    public void testInfoCommandLoggedAtInfo() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, (Optional<List<String>>)Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).logAuditMessage(Matchers.anyString());
    }

    @Test
    public void testMultipleDebugCommandsNotLoggedAtInfo() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, (Optional<List<String>>)Optional.of(Arrays.asList(DUMMY_COMMAND_1, DUMMY_COMMAND_2)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).logAuditMessage(Matchers.anyString());
    }

    @Test
    public void testMultipleDebugCommandsLoggedAtDebug() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.DEBUG, (Optional<List<String>>)Optional.of(Arrays.asList(DUMMY_COMMAND_1, DUMMY_COMMAND_2)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).logAuditMessage(Matchers.anyString());
    }

    @Test
    public void testEmptyDebugCommands() {
        FSNamesystem.DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, (Optional<List<String>>)Optional.absent());
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((FSNamesystem.DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).logAuditMessage(Matchers.anyString());
    }
}

