/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;

public class DataNodeTestUtils {
    private static final String DIR_FAILURE_SUFFIX = ".origin";
    public static final String TEST_CLUSTER_ID = "testClusterID";
    public static final String TEST_POOL_ID = "BP-TEST";

    public static DatanodeRegistration getDNRegistrationForBP(DataNode dn, String bpid) throws IOException {
        return dn.getDNRegistrationForBP(bpid);
    }

    public static void setHeartbeatsDisabledForTests(DataNode dn, boolean heartbeatsDisabledForTests) {
        dn.setHeartbeatsDisabledForTests(heartbeatsDisabledForTests);
    }

    public static void setCacheReportsDisabledForTests(MiniDFSCluster cluster, boolean disabled) {
        for (DataNode dn : cluster.getDataNodes()) {
            dn.setCacheReportsDisabledForTest(disabled);
        }
    }

    public static void triggerDeletionReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerDeletionReportForTests();
        }
    }

    public static void triggerHeartbeat(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerHeartbeatForTests();
        }
    }

    public static void triggerBlockReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerBlockReportForTests();
        }
    }

    public static InterDatanodeProtocol createInterDatanodeProtocolProxy(DataNode dn, DatanodeID datanodeid, Configuration conf, boolean connectToDnViaHostname) throws IOException {
        if (connectToDnViaHostname != dn.getDnConf().connectToDnViaHostname) {
            throw new AssertionError((Object)"Unexpected DN hostname configuration");
        }
        return DataNode.createInterDataNodeProtocolProxy((DatanodeID)datanodeid, (Configuration)conf, (int)dn.getDnConf().socketTimeout, (boolean)dn.getDnConf().connectToDnViaHostname);
    }

    public static FsDatasetSpi<?> getFSDataset(DataNode dn) {
        return dn.getFSDataset();
    }

    public static long getPendingAsyncDeletions(DataNode dn) {
        return FsDatasetTestUtil.getPendingAsyncDeletions(dn.getFSDataset());
    }

    public static ReplicaInfo fetchReplicaInfo(DataNode dn, String bpid, long blkId) {
        return FsDatasetTestUtil.fetchReplicaInfo(dn.getFSDataset(), bpid, blkId);
    }

    public static void injectDataDirFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedTo = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (renamedTo.exists()) {
                throw new IOException(String.format("Can not inject failure to dir: %s because %s exists.", dir, renamedTo));
            }
            if (!dir.renameTo(renamedTo)) {
                throw new IOException(String.format("Failed to rename %s to %s.", dir, renamedTo));
            }
            if (dir.createNewFile()) continue;
            throw new IOException(String.format("Failed to create file %s to inject disk failure.", dir));
        }
    }

    public static void restoreDataDirFromFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedDir = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (!renamedDir.exists()) continue;
            if (dir.exists()) {
                if (!dir.isFile()) {
                    throw new IOException("Injected failure data dir is supposed to be file: " + dir);
                }
                if (!dir.delete()) {
                    throw new IOException("Failed to delete injected failure data dir: " + dir);
                }
            }
            if (renamedDir.renameTo(dir)) continue;
            throw new IOException(String.format("Failed to recover injected failure data dir %s to %s.", renamedDir, dir));
        }
    }

    public static void runDirectoryScanner(DataNode dn) throws IOException {
        DirectoryScanner directoryScanner = dn.getDirectoryScanner();
        if (directoryScanner != null) {
            dn.getDirectoryScanner().reconcile();
        }
    }
}

