/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeVolumeFailureReporting {
    private static final Log LOG = LogFactory.getLog(TestDataNodeVolumeFailureReporting.class);
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private String dataDir;
    private long volumeCapacity;
    final int WAIT_FOR_HEARTBEATS = 3000;
    final int WAIT_FOR_DEATH = 15000;

    public TestDataNodeVolumeFailureReporting() {
        GenericTestUtils.setLogLevel((Log)LOG, (Level)Level.ALL);
        this.WAIT_FOR_HEARTBEATS = 3000;
        this.WAIT_FOR_DEATH = 15000;
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        this.initCluster(1, 2, 1);
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSuccessiveVolumeFailures() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        Thread.sleep(3000L);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn2Vol1 = new File(this.dataDir, "data3");
        File dn3Vol1 = new File(this.dataDir, "data5");
        File dn3Vol2 = new File(this.dataDir, "data6");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
        DataNodeTestUtils.injectDataDirFailure(dn3Vol1);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)3);
        Assert.assertTrue((String)"DN3 should still be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(2), 1L, true, dn3Vol1.getAbsolutePath());
        DataNodeTestUtils.triggerHeartbeat(dns.get(2));
        this.checkFailuresAtNameNode(dm, dns.get(2), true, dn3Vol1.getAbsolutePath());
        dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 3L, origCapacity - 3L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 3);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, dn3Vol1.getAbsolutePath());
        DataNodeTestUtils.injectDataDirFailure(dn3Vol2);
        Path file3 = new Path("/test3");
        DFSTestUtil.createFile(this.fs, file3, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file3, (short)2);
        DFSTestUtil.waitForDatanodeDeath(dns.get(2));
        this.checkFailuresAtDataNode(dns.get(2), 2L, true, dn3Vol1.getAbsolutePath(), dn3Vol2.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 2, 1, 2L, origCapacity - 4L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol1, dn2Vol1, dn3Vol1, dn3Vol2);
        this.cluster.restartDataNodes();
        this.cluster.waitActive();
        Path file4 = new Path("/test4");
        DFSTestUtil.createFile(this.fs, file4, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file4, (short)3);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 0L, origCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 0);
        dns = this.cluster.getDataNodes();
        this.checkFailuresAtNameNode(dm, dns.get(0), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(1), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
    }

    @Test
    public void testVolFailureStatsPreservedOnNNRestart() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn2Vol1 = new File(this.dataDir, "data3");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
    }

    @Test
    public void testMultipleVolFailuresOnNode() throws Exception {
        this.tearDown();
        this.initCluster(3, 4, 2);
        Thread.sleep(3000L);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn1Vol2 = new File(this.dataDir, "data2");
        File dn2Vol1 = new File(this.dataDir, "data5");
        File dn2Vol2 = new File(this.dataDir, "data6");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn1Vol2, dn2Vol1, dn2Vol2);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath(), dn1Vol2.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath(), dn2Vol2.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 4L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 4);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath(), dn1Vol2.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath(), dn2Vol2.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
    }

    @Test
    public void testDataNodeReconfigureWithVolumeFailures() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn1Vol2 = new File(this.dataDir, "data2");
        File dn2Vol1 = new File(this.dataDir, "data3");
        File dn2Vol2 = new File(this.dataDir, "data4");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1);
        DataNodeTestUtils.injectDataDirFailure(dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, false, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, false, dn2Vol1.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(false, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), false, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), false, dn2Vol1.getAbsolutePath());
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, false, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, false, dn2Vol1.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(false, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), false, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), false, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol1, dn2Vol1);
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        TestDataNodeVolumeFailureReporting.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, new String[0]);
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 0L, origCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 0);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(1), true, new String[0]);
    }

    private void checkAggregateFailuresAtNameNode(boolean expectCapacityKnown, int expectedVolumeFailuresTotal) {
        FSNamesystem ns = this.cluster.getNamesystem();
        Assert.assertEquals((long)expectedVolumeFailuresTotal, (long)ns.getVolumeFailuresTotal());
        long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedVolumeFailuresTotal);
        Assert.assertEquals((long)expectedCapacityLost, (long)ns.getEstimatedCapacityLostTotal());
    }

    private void checkFailuresAtDataNode(DataNode dn, long expectedVolumeFailuresCounter, boolean expectCapacityKnown, String ... expectedFailedVolumes) throws Exception {
        MetricsAsserts.assertCounter((String)"VolumeFailures", (long)expectedVolumeFailuresCounter, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)dn.getMetrics().name()));
        FsDatasetSpi fsd = dn.getFSDataset();
        Assert.assertEquals((long)expectedFailedVolumes.length, (long)fsd.getNumFailedVolumes());
        Assert.assertArrayEquals((Object[])expectedFailedVolumes, (Object[])fsd.getFailedStorageLocations());
        if (expectedFailedVolumes.length > 0) {
            Assert.assertTrue((fsd.getLastVolumeFailureDate() > 0L ? 1 : 0) != 0);
            long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedFailedVolumes.length);
            Assert.assertEquals((long)expectedCapacityLost, (long)fsd.getEstimatedCapacityLostTotal());
        } else {
            Assert.assertEquals((long)0L, (long)fsd.getLastVolumeFailureDate());
            Assert.assertEquals((long)0L, (long)fsd.getEstimatedCapacityLostTotal());
        }
    }

    private void checkFailuresAtNameNode(DatanodeManager dm, DataNode dn, boolean expectCapacityKnown, String ... expectedFailedVolumes) throws Exception {
        DatanodeDescriptor dd = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
        Assert.assertEquals((long)expectedFailedVolumes.length, (long)dd.getVolumeFailures());
        VolumeFailureSummary volumeFailureSummary = dd.getVolumeFailureSummary();
        if (expectedFailedVolumes.length > 0) {
            Assert.assertArrayEquals((Object[])expectedFailedVolumes, (Object[])volumeFailureSummary.getFailedStorageLocations());
            Assert.assertTrue((volumeFailureSummary.getLastVolumeFailureDate() > 0L ? 1 : 0) != 0);
            long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedFailedVolumes.length);
            Assert.assertEquals((long)expectedCapacityLost, (long)volumeFailureSummary.getEstimatedCapacityLostTotal());
        } else {
            Assert.assertNull((Object)volumeFailureSummary);
        }
    }

    private long getExpectedCapacityLost(boolean expectCapacityKnown, int expectedVolumeFailuresTotal) {
        return expectCapacityKnown ? (long)expectedVolumeFailuresTotal * this.volumeCapacity : 0L;
    }

    private void initCluster(int numDataNodes, int storagesPerDatanode, int failedVolumesTolerated) throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.df.interval", 1000);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", failedVolumesTolerated);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDataNodes).storagesPerDatanode(storagesPerDatanode).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.dataDir = this.cluster.getDataDirectory();
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(this.cluster.getNamesystem().getBlockManager().getDatanodeManager(), 0);
        this.volumeCapacity = dnCapacity / (long)this.cluster.getStoragesPerDatanode();
    }

    private static void reconfigureDataNode(DataNode dn, File ... newVols) throws Exception {
        StringBuilder dnNewDataDirs = new StringBuilder();
        for (File newVol : newVols) {
            if (dnNewDataDirs.length() > 0) {
                dnNewDataDirs.append(',');
            }
            dnNewDataDirs.append(newVol.getAbsolutePath());
        }
        try {
            Assert.assertThat((Object)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", dnNewDataDirs.toString()), (Matcher)Is.is((Object)dn.getConf().get("dfs.datanode.data.dir")));
        }
        catch (ReconfigurationException e) {
            LOG.warn((Object)"Could not reconfigure DataNode.", (Throwable)e);
        }
    }
}

