/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestSetTimes {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int numDatanodes = 1;
    static final SimpleDateFormat dateForm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    Random myrand = new Random();
    Path hostsFile;
    Path excludeFile;

    private FSDataOutputStream writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        return stm;
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private void printDatanodeReport(DatanodeInfo[] info) {
        System.out.println("-------------------------------------------------");
        for (int i = 0; i < info.length; ++i) {
            System.out.println(info[i].getDatanodeReport());
            System.out.println();
        }
    }

    @Test
    public void testTimes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        int nnport = cluster.getNameNodePort();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)1L, (long)info.length);
        DistributedFileSystem fileSys = cluster.getFileSystem();
        int replicas = 1;
        Assert.assertTrue((boolean)(fileSys instanceof DistributedFileSystem));
        try {
            System.out.println("Creating testdir1 and testdir1/test1.dat.");
            Path dir1 = new Path("testdir1");
            Path file1 = new Path(dir1, "test1.dat");
            FSDataOutputStream stm = this.writeFile((FileSystem)fileSys, file1, replicas);
            FileStatus stat = fileSys.getFileStatus(file1);
            long atimeBeforeClose = stat.getAccessTime();
            String adate = dateForm.format(new Date(atimeBeforeClose));
            System.out.println("atime on " + file1 + " before close is " + adate + " (" + atimeBeforeClose + ")");
            Assert.assertTrue((atimeBeforeClose != 0L ? 1 : 0) != 0);
            stm.close();
            stat = fileSys.getFileStatus(file1);
            long atime1 = stat.getAccessTime();
            long mtime1 = stat.getModificationTime();
            adate = dateForm.format(new Date(atime1));
            String mdate = dateForm.format(new Date(mtime1));
            System.out.println("atime on " + file1 + " is " + adate + " (" + atime1 + ")");
            System.out.println("mtime on " + file1 + " is " + mdate + " (" + mtime1 + ")");
            Assert.assertTrue((atime1 != 0L ? 1 : 0) != 0);
            fileSys.setTimes(file1, -2L, -2L);
            stat = fileSys.getFileStatus(file1);
            Assert.assertEquals((long)mtime1, (long)stat.getModificationTime());
            Assert.assertEquals((long)atime1, (long)stat.getAccessTime());
            stat = fileSys.getFileStatus(dir1);
            long mdir1 = stat.getAccessTime();
            Assert.assertTrue((mdir1 == 0L ? 1 : 0) != 0);
            long atime2 = atime1 - 86400000L;
            fileSys.setTimes(file1, -1L, atime2);
            stat = fileSys.getFileStatus(file1);
            long atime3 = stat.getAccessTime();
            String adate3 = dateForm.format(new Date(atime3));
            System.out.println("new atime on " + file1 + " is " + adate3 + " (" + atime3 + ")");
            Assert.assertTrue((atime2 == atime3 ? 1 : 0) != 0);
            Assert.assertTrue((mtime1 == stat.getModificationTime() ? 1 : 0) != 0);
            long mtime2 = mtime1 - 3600000L;
            fileSys.setTimes(file1, mtime2, -1L);
            stat = fileSys.getFileStatus(file1);
            long mtime3 = stat.getModificationTime();
            String mdate3 = dateForm.format(new Date(mtime3));
            System.out.println("new mtime on " + file1 + " is " + mdate3 + " (" + mtime3 + ")");
            Assert.assertTrue((atime2 == stat.getAccessTime() ? 1 : 0) != 0);
            Assert.assertTrue((mtime2 == mtime3 ? 1 : 0) != 0);
            long mtime4 = Time.now() - 3600000L;
            long atime4 = Time.now();
            fileSys.setTimes(dir1, mtime4, atime4);
            stat = fileSys.getFileStatus(dir1);
            Assert.assertTrue((String)"Not matching the modification times", (mtime4 == stat.getModificationTime() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Not matching the access times", (atime4 == stat.getAccessTime() ? 1 : 0) != 0);
            Path nonExistingDir = new Path(dir1, "/nonExistingDir/");
            try {
                fileSys.setTimes(nonExistingDir, mtime4, atime4);
                Assert.fail((String)"Expecting FileNotFoundException");
            }
            catch (FileNotFoundException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("File/Directory " + nonExistingDir.toString() + " does not exist."));
            }
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            System.out.println("Verifying times after cluster restart");
            stat = fileSys.getFileStatus(file1);
            Assert.assertTrue((atime2 == stat.getAccessTime() ? 1 : 0) != 0);
            Assert.assertTrue((mtime3 == stat.getModificationTime() ? 1 : 0) != 0);
            this.cleanupFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, dir1);
        }
        catch (IOException e) {
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testTimesAtClose() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        int replicas = 1;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.datanode.handler.count", 50);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)1L, (long)info.length);
        DistributedFileSystem fileSys = cluster.getFileSystem();
        Assert.assertTrue((boolean)(fileSys instanceof DistributedFileSystem));
        try {
            Path file1 = new Path("/simple.dat");
            FSDataOutputStream stm = this.writeFile((FileSystem)fileSys, file1, replicas);
            System.out.println("Created and wrote file simple.dat");
            FileStatus statBeforeClose = fileSys.getFileStatus(file1);
            long mtimeBeforeClose = statBeforeClose.getModificationTime();
            String mdateBeforeClose = dateForm.format(new Date(mtimeBeforeClose));
            System.out.println("mtime on " + file1 + " before close is " + mdateBeforeClose + " (" + mtimeBeforeClose + ")");
            Assert.assertTrue((mtimeBeforeClose != 0L ? 1 : 0) != 0);
            stm.close();
            System.out.println("Closed file.");
            FileStatus statAfterClose = fileSys.getFileStatus(file1);
            long mtimeAfterClose = statAfterClose.getModificationTime();
            String mdateAfterClose = dateForm.format(new Date(mtimeAfterClose));
            System.out.println("mtime on " + file1 + " after close is " + mdateAfterClose + " (" + mtimeAfterClose + ")");
            Assert.assertTrue((mtimeAfterClose != 0L ? 1 : 0) != 0);
            Assert.assertTrue((mtimeBeforeClose != mtimeAfterClose ? 1 : 0) != 0);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        catch (IOException e) {
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetBlockLocationsOnlyUsesReadLock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.accesstime.precision", 100000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        ReentrantReadWriteLock spyLock = NameNodeAdapter.spyOnFsLock(cluster.getNamesystem());
        try {
            Path p = new Path("/empty-file");
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), p, 0L, (short)1, 0L);
            ((ReentrantReadWriteLock)MockitoUtil.doThrowWhenCallStackMatches((Throwable)((Object)new AssertionError((Object)"Should not need write lock")), (String)".*getBlockLocations.*").when((Object)spyLock)).writeLock();
            cluster.getFileSystem().getFileBlockLocations(p, 0L, 100L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtimeUpdate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.accesstime.precision", 0);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            fs = cluster.getFileSystem();
            Path p = new Path("/testAtimeUpdate");
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), p, 0L, (short)1, 0L);
            fs.setTimes(p, -1L, 123456L);
            Assert.assertEquals((long)123456L, (long)fs.getFileStatus(p).getAccessTime());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestSetTimes().testTimes();
    }
}

