/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.qjournal.QJMTestUtil;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.QuorumException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.client.QuorumOutputStream;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestQuorumJournalManagerUnit {
    private static final NamespaceInfo FAKE_NSINFO;
    private final Configuration conf = new Configuration();
    private List<AsyncLogger> spyLoggers;
    private QuorumJournalManager qjm;

    @Before
    public void setup() throws Exception {
        this.spyLoggers = ImmutableList.of((Object)this.mockLogger(), (Object)this.mockLogger(), (Object)this.mockLogger());
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        this.qjm = new QuorumJournalManager(this.conf, new URI("qjournal://host/jid"), FAKE_NSINFO){

            protected List<AsyncLogger> createLoggers(AsyncLogger.Factory factory) {
                return TestQuorumJournalManagerUnit.this.spyLoggers;
            }
        };
        for (AsyncLogger logger : this.spyLoggers) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(QJournalProtocolProtos.GetJournalStateResponseProto.newBuilder().setLastPromisedEpoch(0L).setHttpPort(-1).build()).when((Object)logger)).getJournalState();
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(QJournalProtocolProtos.NewEpochResponseProto.newBuilder().build()).when((Object)logger)).newEpoch(Mockito.anyLong());
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)logger)).format((NamespaceInfo)Mockito.any(), ArgumentMatchers.anyBoolean());
        }
        this.qjm.recoverUnfinalizedSegments();
    }

    private AsyncLogger mockLogger() {
        return (AsyncLogger)Mockito.mock(AsyncLogger.class);
    }

    static <V> Stubber futureReturns(V value) {
        ListenableFuture ret = Futures.immediateFuture(value);
        return Mockito.doReturn((Object)ret);
    }

    static Stubber futureThrows(Throwable t) {
        ListenableFuture ret = Futures.immediateFailedFuture((Throwable)t);
        return Mockito.doReturn((Object)ret);
    }

    @Test
    public void testAllLoggersStartOk() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
    }

    @Test
    public void testQuorumOfLoggersStartOk() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
    }

    @Test
    public void testQuorumOfLoggersFail() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        try {
            this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.fail((String)"Did not throw when quorum failed");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"logger failed", (Throwable)qe);
        }
    }

    @Test
    public void testQuorumOutputStreamReport() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        QuorumOutputStream os = (QuorumOutputStream)this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        String report = os.generateReport();
        Assert.assertFalse((String)"Report should be plain text", (boolean)report.contains("<"));
    }

    @Test
    public void testWriteEdits() throws Exception {
        EditLogOutputStream stm = this.createLogSegment();
        QJMTestUtil.writeOp(stm, 1L);
        QJMTestUtil.writeOp(stm, 2L);
        stm.setReadyToFlush();
        QJMTestUtil.writeOp(stm, 3L);
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)2), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)2), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)2), (byte[])Mockito.any());
        stm.flush();
        stm.setReadyToFlush();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)3L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)3L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)3L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        stm.flush();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetOutputBufferCapacityTooLarge() throws Exception {
        this.qjm.setOutputBufferCapacity(0x8000001);
    }

    @Test
    public void testFSEditLogAutoSyncToQuorumStream() throws Exception {
        int i;
        this.qjm.setOutputBufferCapacity(512);
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        this.createLogSegment();
        for (int logIdx = 0; logIdx < 3; ++logIdx) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(logIdx))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any());
        }
        PermissionStatus permStat = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.getDefault());
        INodeFile fakeInode = FSImageTestUtil.createEmptyInodeFile(1L, "foo", permStat, 1L, 1L, (short)1, 1L);
        String mockQjmEdits = "qjournal://mock/";
        this.conf.set("dfs.namenode.edits.dir", mockQjmEdits);
        this.conf.set("dfs.namenode.shared.edits.dir", mockQjmEdits);
        FSEditLog editLog = FSImageTestUtil.createEditLogWithJournalManager(this.conf, mockStorage, URI.create(mockQjmEdits), (JournalManager)this.qjm);
        editLog.initJournalsForWrite();
        editLog.startLogSegment(1L, false, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        for (i = 0; i < 12; ++i) {
            editLog.logMkDir("/fake/path", (INode)fakeInode);
        }
        for (i = 0; i < 3; ++i) {
            ((AsyncLogger)Mockito.verify((Object)this.spyLoggers.get(i), (VerificationMode)Mockito.times((int)1))).sendEdits(ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((long)1L), ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any());
        }
    }

    @Test
    public void testWriteEditsOneSlow() throws Exception {
        EditLogOutputStream stm = this.createLogSegment();
        QJMTestUtil.writeOp(stm, 1L);
        stm.setReadyToFlush();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        SettableFuture slowLog = SettableFuture.create();
        ((AsyncLogger)Mockito.doReturn((Object)slowLog).when((Object)this.spyLoggers.get(2))).sendEdits(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((int)1), (byte[])Mockito.any());
        stm.flush();
        ((AsyncLogger)Mockito.verify((Object)this.spyLoggers.get(0))).setCommittedTxId(1L);
    }

    @Test
    public void testReadRpcInputStreams() throws Exception {
        for (int jn = 0; jn < 3; ++jn) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(this.getJournaledEditsReponse(1, 3)).when((Object)this.spyLoggers.get(jn))).getJournaledEdits(1L, 5000);
        }
        ArrayList streams = Lists.newArrayList();
        this.qjm.selectInputStreams((Collection)streams, 1L, true, true);
        Assert.assertEquals((long)1L, (long)streams.size());
        QJMTestUtil.verifyEdits(streams, 1, 3);
    }

    @Test
    public void testReadRpcMismatchedInputStreams() throws Exception {
        for (int jn = 0; jn < 3; ++jn) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(this.getJournaledEditsReponse(1, jn + 1)).when((Object)this.spyLoggers.get(jn))).getJournaledEdits(1L, 5000);
        }
        ArrayList streams = Lists.newArrayList();
        this.qjm.selectInputStreams((Collection)streams, 1L, true, true);
        Assert.assertEquals((long)1L, (long)streams.size());
        QJMTestUtil.verifyEdits(streams, 1, 2);
    }

    @Test
    public void testReadRpcInputStreamsOneSlow() throws Exception {
        for (int jn = 0; jn < 2; ++jn) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(this.getJournaledEditsReponse(1, jn + 1)).when((Object)this.spyLoggers.get(jn))).getJournaledEdits(1L, 5000);
        }
        ((AsyncLogger)Mockito.doReturn((Object)SettableFuture.create()).when((Object)this.spyLoggers.get(2))).getJournaledEdits(1L, 5000);
        ArrayList streams = Lists.newArrayList();
        this.qjm.selectInputStreams((Collection)streams, 1L, true, true);
        Assert.assertEquals((long)1L, (long)streams.size());
        QJMTestUtil.verifyEdits(streams, 1, 1);
    }

    @Test
    public void testReadRpcInputStreamsOneException() throws Exception {
        for (int jn = 0; jn < 2; ++jn) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(this.getJournaledEditsReponse(1, jn + 1)).when((Object)this.spyLoggers.get(jn))).getJournaledEdits(1L, 5000);
        }
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException()).when((Object)this.spyLoggers.get(2))).getJournaledEdits(1L, 5000);
        ArrayList streams = Lists.newArrayList();
        this.qjm.selectInputStreams((Collection)streams, 1L, true, true);
        Assert.assertEquals((long)1L, (long)streams.size());
        QJMTestUtil.verifyEdits(streams, 1, 1);
    }

    @Test
    public void testReadRpcInputStreamsNoNewEdits() throws Exception {
        for (int jn = 0; jn < 3; ++jn) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(QJournalProtocolProtos.GetJournaledEditsResponseProto.newBuilder().setTxnCount(0).setEditLog(ByteString.EMPTY).build()).when((Object)this.spyLoggers.get(jn))).getJournaledEdits(1L, 5000);
        }
        ArrayList streams = Lists.newArrayList();
        this.qjm.selectInputStreams((Collection)streams, 1L, true, true);
        Assert.assertEquals((long)0L, (long)streams.size());
    }

    private QJournalProtocolProtos.GetJournaledEditsResponseProto getJournaledEditsReponse(int startTxn, int numTxns) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        EditLogFileOutputStream.writeHeader((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION, (DataOutputStream)new DataOutputStream(byteStream));
        byteStream.write(QJMTestUtil.createTxnData(startTxn, numTxns));
        return QJournalProtocolProtos.GetJournaledEditsResponseProto.newBuilder().setTxnCount(numTxns).setEditLog(ByteString.copyFrom((byte[])byteStream.toByteArray())).build();
    }

    private EditLogOutputStream createLogSegment() throws IOException {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong(), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        return stm;
    }

    static {
        GenericTestUtils.setLogLevel((Logger)QuorumJournalManager.LOG, (Level)Level.TRACE);
        FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
    }
}

