/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.TestINodeFile;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@RunWith(value=Parameterized.class)
public class TestFSEditLogLoader {
    private static boolean useAsyncEditLog;
    private static final File TEST_DIR;
    private static final int NUM_DATA_NODES = 0;
    private static final String FAKE_EDIT_STREAM_NAME = "FAKE_STREAM";
    private final ErasureCodingPolicy testECPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private static final Map<Byte, FSEditLogOpCodes> byteToEnum;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestFSEditLogLoader(Boolean async) {
        useAsyncEditLog = async;
    }

    private static Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.edits.asynclogging", useAsyncEditLog);
        return conf;
    }

    @Test
    public void testDisplayRecentEditLogOpCodes() throws IOException {
        Configuration conf = TestFSEditLogLoader.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        for (int i = 0; i < 20; ++i) {
            fileSys.mkdirs(new Path("/tmp/tmp" + i));
        }
        Storage.StorageDirectory sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        cluster.shutdown();
        File editFile = FSImageTestUtil.findLatestEditsLog(sd).getFile();
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        long fileLen = editFile.length();
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.seek(fileLen - 40L);
        for (int i = 0; i < 20; ++i) {
            rwf.write(FSEditLogOpCodes.OP_DELETE.getOpCode());
        }
        rwf.close();
        StringBuilder bld = new StringBuilder();
        bld.append("^Error replaying edit log at offset \\d+.  ");
        bld.append("Expected transaction ID was \\d+\n");
        bld.append("Recent opcode offsets: (\\d+\\s*){4}$");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).format(false).build();
            Assert.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"error message contains opcodes message", (boolean)e.getMessage().matches(bld.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicationAdjusted() throws Exception {
        Configuration conf = TestFSEditLogLoader.getConf();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, p, 10L, (short)1, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, p, (short)1);
            cluster.shutdown();
            cluster = null;
            conf.setInt("dfs.namenode.replication.min", 2);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.waitReplication((FileSystem)fs, p, (short)2);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptByteInFile(File file, long offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.seek(offset);
            int origByte = raf.read();
            raf.seek(offset);
            raf.writeByte(origByte - 1);
        }
        finally {
            IOUtils.closeStream((Closeable)raf);
        }
    }

    private void truncateFile(File logFile, long newLength) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(logFile, "rw");
        raf.setLength(newLength);
        raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNonTrailerLength(File f) throws IOException {
        int chunkSizeToRead = 262144;
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] buf = new byte[262144];
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            for (long pos = size - size % 262144L; pos >= 0L; pos -= 262144L) {
                fc.position(pos);
                int readLen = (int)Math.min(size - pos, 262144L);
                IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)readLen);
                for (int i = readLen - 1; i >= 0; --i) {
                    if (buf[i] == FSEditLogOpCodes.OP_INVALID.getOpCode()) continue;
                    long l = pos + (long)i + 1L;
                    return l;
                }
            }
            long l = 0L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamLimiter() throws IOException {
        File LIMITER_TEST_FILE = new File(TEST_DIR, "limiter.test");
        try (FileOutputStream fos = new FileOutputStream(LIMITER_TEST_FILE);){
            fos.write(18);
            fos.write(18);
            fos.write(18);
        }
        FileInputStream fin = new FileInputStream(LIMITER_TEST_FILE);
        BufferedInputStream bin = new BufferedInputStream(fin);
        try (FSEditLogLoader.PositionTrackingInputStream tracker = new FSEditLogLoader.PositionTrackingInputStream((InputStream)bin);){
            tracker.setLimit(2L);
            tracker.mark(100);
            tracker.read();
            tracker.read();
            try {
                tracker.read();
                Assert.fail((String)"expected to get IOException after reading past the limit");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tracker.reset();
            tracker.mark(100);
            byte[] arr = new byte[3];
            try {
                tracker.read(arr);
                Assert.fail((String)"expected to get IOException after reading past the limit");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tracker.reset();
            arr = new byte[2];
            tracker.read(arr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File prepareUnfinalizedTestEditLog(File testDir, int numTx, SortedMap<Long, Long> offsetToTxId) throws IOException {
        File inProgressFile = new File(testDir, NNStorage.getInProgressEditsFileName((long)1L));
        FSEditLog fsel = null;
        FSEditLog spyLog = null;
        try {
            fsel = FSImageTestUtil.createStandaloneEditLog(testDir);
            spyLog = (FSEditLog)Mockito.spy((Object)fsel);
            ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).endCurrentLogSegment(true);
            spyLog.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.assertTrue((String)("should exist: " + inProgressFile), (boolean)inProgressFile.exists());
            for (int i = 0; i < numTx; ++i) {
                long trueOffset = TestFSEditLogLoader.getNonTrailerLength(inProgressFile);
                long thisTxId = spyLog.getLastWrittenTxId() + 1L;
                offsetToTxId.put(trueOffset, thisTxId);
                System.err.println("txid " + thisTxId + " at offset " + trueOffset);
                spyLog.logDelete("path" + i, (long)i, false);
                spyLog.logSync();
            }
        }
        finally {
            if (spyLog != null) {
                spyLog.close();
            } else if (fsel != null) {
                fsel.close();
            }
        }
        return inProgressFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateEditLogWithCorruptHeader() throws IOException {
        File testDir = new File(TEST_DIR, "testValidateEditLogWithCorruptHeader");
        TreeMap offsetToTxId = Maps.newTreeMap();
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 2, offsetToTxId);
        try (RandomAccessFile rwf = new RandomAccessFile(logFile, "rw");){
            rwf.seek(0L);
            rwf.writeLong(42L);
        }
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((boolean)validation.hasCorruptHeader());
    }

    @Test
    public void testValidateEditLogWithCorruptBody() throws IOException {
        long expectedEndTxId;
        long txId;
        long txOffset;
        File testDir = new File(TEST_DIR, "testValidateEditLogWithCorruptBody");
        TreeMap offsetToTxId = Maps.newTreeMap();
        int NUM_TXNS = 20;
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 20, offsetToTxId);
        File logFileBak = new File(testDir, logFile.getName() + ".bak");
        Files.copy((File)logFile, (File)logFileBak);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        Assert.assertEquals((long)21L, (long)validation.getEndTxId());
        for (Map.Entry entry : offsetToTxId.entrySet()) {
            txOffset = (Long)entry.getKey();
            txId = (Long)entry.getValue();
            Files.copy((File)logFileBak, (File)logFile);
            this.corruptByteInFile(logFile, txOffset);
            validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
            expectedEndTxId = txId == 21L ? 20L : 21L;
            Assert.assertEquals((String)("Failed when corrupting txn opcode at " + txOffset), (long)expectedEndTxId, (long)validation.getEndTxId());
            Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        }
        for (Map.Entry entry : offsetToTxId.entrySet()) {
            txOffset = (Long)entry.getKey();
            txId = (Long)entry.getValue();
            Files.copy((File)logFileBak, (File)logFile);
            this.truncateFile(logFile, txOffset);
            validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
            expectedEndTxId = txId == 0L ? -12345L : txId - 1L;
            Assert.assertEquals((String)("Failed when corrupting txid " + txId + " txn opcode at " + txOffset), (long)expectedEndTxId, (long)validation.getEndTxId());
            Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidateEmptyEditLog() throws IOException {
        File testDir = new File(TEST_DIR, "testValidateEmptyEditLog");
        TreeMap offsetToTxId = Maps.newTreeMap();
        File logFile = TestFSEditLogLoader.prepareUnfinalizedTestEditLog(testDir, 0, offsetToTxId);
        this.truncateFile(logFile, 8L);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.scanEditLog((File)logFile, (long)Long.MAX_VALUE, (boolean)true);
        Assert.assertTrue((!validation.hasCorruptHeader() ? 1 : 0) != 0);
        Assert.assertEquals((long)-12345L, (long)validation.getEndTxId());
    }

    private static FSEditLogOpCodes fromByte(byte opCode) {
        return byteToEnum.get(opCode);
    }

    @Test
    public void testFSEditLogOpCodes() throws IOException {
        for (FSEditLogOpCodes c : FSEditLogOpCodes.values()) {
            byte code = c.getOpCode();
            Assert.assertEquals((String)("c=" + c + ", code=" + code), (Object)c, (Object)FSEditLogOpCodes.fromByte((byte)code));
        }
        for (int b = 0; b < 256; ++b) {
            byte code = (byte)b;
            Assert.assertEquals((String)("b=" + b + ", code=" + code), (Object)TestFSEditLogLoader.fromByte(code), (Object)FSEditLogOpCodes.fromByte((byte)code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddNewStripedBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            fs.enableErasureCodingPolicy(this.testECPolicy.getName());
            String testDir = "/ec";
            String testFile = "testfile_001";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser1";
            String clientMachine = "testMachine1";
            long blkId = 1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            short blockNum = (short)this.testECPolicy.getNumDataUnits();
            short parityNum = (short)this.testECPolicy.getNumParityUnits();
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            fs.getClient().getNamenode().setErasureCodingPolicy(testDir, this.testECPolicy.getName());
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            fns.leaveSafeMode(false);
            BlockInfoStriped stripedBlk = new BlockInfoStriped(new Block(blkId, blkNumBytes, timestamp), this.testECPolicy);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)stripedBlk);
            fns.getEditLog().logAddBlock(testFilePath, file);
            TestINodeFile.toCompleteFile(file);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            INodeFile inodeLoaded = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            Assert.assertTrue((boolean)inodeLoaded.isStriped());
            BlockInfo[] blks = inodeLoaded.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertEquals((long)blkId, (long)blks[0].getBlockId());
            Assert.assertEquals((long)blkNumBytes, (long)blks[0].getNumBytes());
            Assert.assertEquals((long)timestamp, (long)blks[0].getGenerationStamp());
            Assert.assertEquals((long)blockNum, (long)((BlockInfoStriped)blks[0]).getDataBlockNum());
            Assert.assertEquals((long)parityNum, (long)((BlockInfoStriped)blks[0]).getParityBlockNum());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateStripedBlocks() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            fs.enableErasureCodingPolicy(this.testECPolicy.getName());
            String testDir = "/ec";
            String testFile = "testfile_002";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser2";
            String clientMachine = "testMachine2";
            long blkId = 1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            short blockNum = (short)this.testECPolicy.getNumDataUnits();
            short parityNum = (short)this.testECPolicy.getNumParityUnits();
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            fs.getClient().getNamenode().setErasureCodingPolicy(testDir, this.testECPolicy.getName());
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoStriped stripedBlk = new BlockInfoStriped(new Block(blkId, blkNumBytes, timestamp), this.testECPolicy);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)stripedBlk);
            fns.getEditLog().logAddBlock(testFilePath, file);
            TestINodeFile.toCompleteFile(file);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            fns.leaveSafeMode(false);
            long newBlkNumBytes = 8192L;
            long newTimestamp = 1426226518L;
            file.toUnderConstruction(clientName, clientMachine);
            file.getLastBlock().setNumBytes(newBlkNumBytes);
            file.getLastBlock().setGenerationStamp(newTimestamp);
            fns.getEditLog().logUpdateBlocks(testFilePath, file, true);
            TestINodeFile.toCompleteFile(file);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            INodeFile inodeLoaded = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            Assert.assertTrue((boolean)inodeLoaded.isStriped());
            BlockInfo[] blks = inodeLoaded.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertTrue((boolean)blks[0].isStriped());
            Assert.assertEquals((long)blkId, (long)blks[0].getBlockId());
            Assert.assertEquals((long)newBlkNumBytes, (long)blks[0].getNumBytes());
            Assert.assertEquals((long)newTimestamp, (long)blks[0].getGenerationStamp());
            Assert.assertEquals((long)blockNum, (long)((BlockInfoStriped)blks[0]).getDataBlockNum());
            Assert.assertEquals((long)parityNum, (long)((BlockInfoStriped)blks[0]).getParityBlockNum());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNonEcBlockUsingStripedIDForAddBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            String testDir = "/test_block_manager";
            String testFile = "testfile_addblock";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser_addblock";
            String clientMachine = "testMachine_addblock";
            long blkId = -1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoContiguous cBlk = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 3);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)cBlk);
            fns.getEditLog().logAddBlock(testFilePath, file);
            TestINodeFile.toCompleteFile(file);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertTrue((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNonEcBlockUsingStripedIDForUpdateBlocks() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            String testDir = "/test_block_manager";
            String testFile = "testfile_002";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser2";
            String clientMachine = "testMachine1";
            long blkId = 100L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoContiguous cBlk = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 3);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)cBlk);
            TestINodeFile.toCompleteFile(file);
            long newBlkNumBytes = 8192L;
            long newTimestamp = 1426226518L;
            file.toUnderConstruction(clientName, clientMachine);
            file.getLastBlock().setBlockId(-100L);
            file.getLastBlock().setNumBytes(newBlkNumBytes);
            file.getLastBlock().setGenerationStamp(newTimestamp);
            fns.getEditLog().logUpdateBlocks(testFilePath, file, true);
            TestINodeFile.toCompleteFile(file);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertTrue((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErasureCodingPolicyOperations() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int blockSize = 16384;
        conf.setLong("dfs.blocksize", 16384L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ECSchema schema = new ECSchema("rs", 5, 3);
            int cellSize = 2048;
            ErasureCodingPolicy newPolicy = new ErasureCodingPolicy(schema, cellSize, 0);
            ErasureCodingPolicy[] policyArray = new ErasureCodingPolicy[]{newPolicy};
            AddErasureCodingPolicyResponse[] responses = fs.addErasureCodingPolicies(policyArray);
            Assert.assertEquals((long)1L, (long)responses.length);
            Assert.assertTrue((boolean)responses[0].isSucceed());
            newPolicy = responses[0].getPolicy();
            cluster.restartNameNodes();
            cluster.waitActive();
            ErasureCodingPolicy ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(newPolicy.getId());
            Assert.assertEquals((Object)ErasureCodingPolicyState.DISABLED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
            fs.enableErasureCodingPolicy(newPolicy.getName());
            cluster.restartNameNodes();
            cluster.waitActive();
            ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(newPolicy.getId());
            Assert.assertEquals((Object)ErasureCodingPolicyState.ENABLED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
            Path dirPath = new Path("/striped");
            Path filePath = new Path(dirPath, "file");
            int fileLength = 16384 * newPolicy.getNumDataUnits();
            fs.mkdirs(dirPath);
            fs.setErasureCodingPolicy(dirPath, newPolicy.getName());
            byte[] bytes = StripedFileTestUtil.generateBytes(fileLength);
            DFSTestUtil.writeFile((FileSystem)fs, filePath, bytes);
            fs.disableErasureCodingPolicy(newPolicy.getName());
            cluster.restartNameNodes();
            cluster.waitActive();
            ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(newPolicy.getId());
            Assert.assertEquals((Object)ErasureCodingPolicyState.DISABLED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
            DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
            fs.removeErasureCodingPolicy(newPolicy.getName());
            cluster.restartNameNodes();
            cluster.waitActive();
            ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(newPolicy.getId());
            Assert.assertEquals((Object)ErasureCodingPolicyState.REMOVED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
            DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void setLoadFSEditLogThrottling() throws Exception {
        FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        namesystem.dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        FakeTimer timer = new FakeTimer();
        FSEditLogLoader loader = new FSEditLogLoader(namesystem, 0L, (Timer)timer);
        GenericTestUtils.LogCapturer capture = GenericTestUtils.LogCapturer.captureLogs((Logger)FSImage.LOG);
        loader.loadFSEdits(this.getFakeEditLogInputStream(1L, 10L), 1L);
        Assert.assertTrue((boolean)capture.getOutput().contains("Start loading edits file FAKE_STREAM"));
        Assert.assertTrue((boolean)capture.getOutput().contains("Loaded 1 edits file(s)"));
        Assert.assertFalse((boolean)capture.getOutput().contains("suppressed"));
        timer.advance(2500L);
        capture.clearOutput();
        loader.loadFSEdits(this.getFakeEditLogInputStream(11L, 20L), 11L);
        Assert.assertFalse((boolean)capture.getOutput().contains("Start loading edits file"));
        Assert.assertFalse((boolean)capture.getOutput().contains("edits file(s)"));
        timer.advance(5000L);
        capture.clearOutput();
        loader.loadFSEdits(this.getFakeEditLogInputStream(21L, 30L), 21L);
        Assert.assertTrue((boolean)capture.getOutput().contains("Start loading edits file FAKE_STREAM"));
        Assert.assertTrue((boolean)capture.getOutput().contains("suppressed logging 1 times"));
        Assert.assertTrue((boolean)capture.getOutput().contains("Loaded 2 edits file(s)"));
        Assert.assertTrue((boolean)capture.getOutput().contains("total size 2.0"));
    }

    private EditLogInputStream getFakeEditLogInputStream(long startTx, long endTx) throws IOException {
        EditLogInputStream fakeStream = (EditLogInputStream)Mockito.mock(EditLogInputStream.class);
        Mockito.when((Object)fakeStream.getName()).thenReturn((Object)FAKE_EDIT_STREAM_NAME);
        Mockito.when((Object)fakeStream.getFirstTxId()).thenReturn((Object)startTx);
        Mockito.when((Object)fakeStream.getLastTxId()).thenReturn((Object)endTx);
        Mockito.when((Object)fakeStream.length()).thenReturn((Object)1L);
        return fakeStream;
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSImage.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)FSEditLogLoader.LOG, (Level)Level.TRACE);
        TEST_DIR = PathUtils.getTestDir(TestFSEditLogLoader.class);
        byteToEnum = new HashMap<Byte, FSEditLogOpCodes>();
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            byteToEnum.put(opCode.getOpCode(), opCode);
        }
    }
}

