/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestNameNodeHttpServerXFrame {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public static URL getServerURL(HttpServer2 server) throws MalformedURLException {
        Assert.assertNotNull((String)"No server", (Object)server);
        return new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
    }

    @Test
    public void testNameNodeXFrameOptionsEnabled() throws Exception {
        HttpURLConnection conn = this.createServerwithXFrame(true, null);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"X-FRAME-OPTIONS is absent in the header", (xfoHeader != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testNameNodeXFrameOptionsDisabled() throws Exception {
        HttpURLConnection conn = this.createServerwithXFrame(false, null);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"unexpected X-FRAME-OPTION in header", (xfoHeader == null ? 1 : 0) != 0);
    }

    @Test
    public void testNameNodeXFrameOptionsIllegalOption() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.createServerwithXFrame(true, "hadoop");
    }

    private HttpURLConnection createServerwithXFrame(boolean enabled, String value) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.setBoolean("dfs.xframe.enabled", enabled);
        if (value != null) {
            conf.set("dfs.xframe.value", value);
        }
        InetSocketAddress addr = InetSocketAddress.createUnresolved("localhost", 0);
        NameNodeHttpServer server = null;
        server = new NameNodeHttpServer((Configuration)conf, null, addr);
        server.start();
        URL url = TestNameNodeHttpServerXFrame.getServerURL(server.getHttpServer());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        return conn;
    }

    @Test
    public void testSecondaryNameNodeXFrame() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        SecondaryNameNode sn = new SecondaryNameNode((Configuration)conf);
        sn.startInfoServer();
        InetSocketAddress httpAddress = SecondaryNameNode.getHttpAddress((Configuration)conf);
        URL url = URI.create("http://" + httpAddress.getHostName() + ":" + httpAddress.getPort()).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"X-FRAME-OPTIONS is absent in the header", (xfoHeader != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }
}

