/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.KMSDelegationToken;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.hadoop.crypto.key.kms.ValueQueue;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.util.Time;
import org.apache.http.client.utils.URIBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestKMS {
    private static final Logger LOG = LoggerFactory.getLogger(TestKMS.class);
    private SSLFactory sslFactory;
    private List<KeyProvider> providersCreated = new LinkedList<KeyProvider>();
    @Rule
    public final Timeout testTimeout = new Timeout(180000);
    private static MiniKdc kdc;
    private static File keytab;

    @Before
    public void setUp() throws Exception {
        this.setUpMiniKdc();
        Configuration conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    public static File getTestDir() throws Exception {
        File file = new File("dummy");
        file = file.getAbsoluteFile();
        file = file.getParentFile();
        file = new File(file, "target");
        if (!(file = new File(file, UUID.randomUUID().toString())).mkdirs()) {
            throw new RuntimeException("Could not create test directory: " + file);
        }
        return file;
    }

    protected KeyProvider createProvider(URI uri, Configuration conf) throws IOException {
        LoadBalancingKMSClientProvider ret = new LoadBalancingKMSClientProvider(uri, new KMSClientProvider[]{new KMSClientProvider(uri, conf)}, conf);
        this.providersCreated.add((KeyProvider)ret);
        return ret;
    }

    protected LoadBalancingKMSClientProvider createHAProvider(URI lbUri, URI[] uris, Configuration conf) throws IOException {
        KMSClientProvider[] providers = new KMSClientProvider[uris.length];
        for (int i = 0; i < providers.length; ++i) {
            providers[i] = new KMSClientProvider(uris[i], conf);
        }
        LoadBalancingKMSClientProvider ret = new LoadBalancingKMSClientProvider(lbUri, providers, conf);
        this.providersCreated.add((KeyProvider)ret);
        return ret;
    }

    private KMSClientProvider createKMSClientProvider(URI uri, Configuration conf) throws IOException {
        KMSClientProvider ret = new KMSClientProvider(uri, conf);
        this.providersCreated.add((KeyProvider)ret);
        return ret;
    }

    protected <T> T runServer(String keystore, String password, File confDir, KMSCallable<T> callable) throws Exception {
        return this.runServer(-1, keystore, password, confDir, callable);
    }

    protected <T> T runServer(int port, String keystore, String password, File confDir, KMSCallable<T> callable) throws Exception {
        return this.runServer(new int[]{port}, keystore, password, confDir, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runServer(int[] ports, String keystore, String password, File confDir, KMSCallable<T> callable) throws Exception {
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder().setKmsConfDir(confDir).setLog4jConfFile("log4j.properties");
        if (keystore != null) {
            miniKMSBuilder.setSslConf(new File(keystore), password);
        }
        ArrayList<MiniKMS> kmsList = new ArrayList<MiniKMS>();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i] > 0) {
                miniKMSBuilder.setPort(ports[i]);
            }
            MiniKMS miniKMS = miniKMSBuilder.build();
            kmsList.add(miniKMS);
            miniKMS.start();
            LOG.info("Test KMS running at: " + miniKMS.getKMSUrl());
            callable.addKMSUrl(miniKMS.getKMSUrl());
        }
        try {
            Object v = callable.call();
            return (T)v;
        }
        finally {
            for (MiniKMS miniKMS : kmsList) {
                miniKMS.stop();
            }
        }
    }

    protected Configuration createBaseKMSConf(File keyStoreDir) throws Exception {
        return this.createBaseKMSConf(keyStoreDir, null);
    }

    protected Configuration createBaseKMSConf(File keyStoreDir, Configuration conf) throws Exception {
        Configuration newConf = conf == null ? new Configuration(false) : new Configuration(conf);
        newConf.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(keyStoreDir.getAbsolutePath(), "kms.keystore").toUri());
        newConf.set("hadoop.kms.authentication.type", "simple");
        return newConf;
    }

    public static void writeConf(File confDir, Configuration conf) throws Exception {
        FileWriter writer = new FileWriter(new File(confDir, "kms-site.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "kms-acls.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "core-site.xml"));
        new Configuration(false).writeXml((Writer)writer);
        ((Writer)writer).close();
    }

    public static URI createKMSUri(URL kmsUrl) throws Exception {
        String str = kmsUrl.toString();
        str = str.replaceFirst("://", "@");
        return new URI("kms://" + str);
    }

    public static URI[] createKMSHAUri(URL[] kmsUrls) throws Exception {
        URI[] uris = new URI[kmsUrls.length];
        for (int i = 0; i < kmsUrls.length; ++i) {
            uris[i] = TestKMS.createKMSUri(kmsUrls[i]);
        }
        return uris;
    }

    private static void setUpMiniKdc(Properties kdcConf) throws Exception {
        File kdcDir = TestKMS.getTestDir();
        kdc = new MiniKdc(kdcConf, kdcDir);
        kdc.start();
        keytab = new File(kdcDir, "keytab");
        ArrayList<String> principals = new ArrayList<String>();
        principals.add("HTTP/localhost");
        principals.add("client");
        principals.add("hdfs");
        principals.add("otheradmin");
        principals.add("client/host");
        principals.add("client1");
        principals.add("foo");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            principals.add(type.toString());
        }
        principals.add("CREATE_MATERIAL");
        principals.add("ROLLOVER_MATERIAL");
        kdc.createPrincipal(keytab, principals.toArray(new String[principals.size()]));
    }

    private void setUpMiniKdc() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        TestKMS.setUpMiniKdc(kdcConf);
    }

    @After
    public void tearDown() throws Exception {
        if (kdc != null) {
            kdc.stop();
            kdc = null;
        }
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)false);
        UserGroupInformation.reset();
        if (!this.providersCreated.isEmpty()) {
            MultipleIOException.Builder b = new MultipleIOException.Builder();
            for (KeyProvider kp : this.providersCreated) {
                try {
                    kp.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close key provider.", (Throwable)e);
                    b.add((Throwable)e);
                }
            }
            this.providersCreated.clear();
            if (!b.isEmpty()) {
                throw b.build();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doAs(String user, PrivilegedExceptionAction<T> action) throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)user, (String)keytab.getAbsolutePath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        try {
            Object object = ugi.doAs(action);
            return (T)object;
        }
        finally {
            ugi.logoutUserFromKeytab();
        }
    }

    private static String readOutput(URLConnection conn) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = conn.getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    private static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        Assert.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    private URLConnection openJMXConnection(URL baseUrl, boolean kerberos) throws Exception {
        URIBuilder b = new URIBuilder(baseUrl + "/jmx");
        if (!kerberos) {
            b.addParameter("user.name", "dr.who");
        }
        URL url = b.build().toURL();
        LOG.info("JMX URL " + url);
        URLConnection conn = url.openConnection();
        if (this.sslFactory != null) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            try {
                httpsConn.setSSLSocketFactory(this.sslFactory.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            httpsConn.setHostnameVerifier(this.sslFactory.getHostnameVerifier());
        }
        return conn;
    }

    private void testJMXQuery(URL baseUrl, boolean kerberos) throws Exception {
        LOG.info("Testing JMX");
        TestKMS.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", TestKMS.readOutput(this.openJMXConnection(baseUrl, kerberos)));
    }

    public void testStartStop(boolean ssl, final boolean kerberos) throws Exception {
        String password;
        String keystore;
        Configuration conf = new Configuration();
        if (kerberos) {
            conf.set("hadoop.security.authentication", "kerberos");
        }
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        if (ssl) {
            String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestKMS.class);
            KeyStoreTestUtil.setupSSLConfig((String)testDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
            keystore = testDir.getAbsolutePath() + "/serverKS.jks";
            password = "serverP";
        } else {
            keystore = null;
            password = null;
        }
        conf.set("hadoop.kms.authentication.token.validity", "1");
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
            conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
            conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
            conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        }
        TestKMS.writeConf(testDir, conf);
        if (ssl) {
            this.sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
        }
        this.runServer(keystore, password, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                final URL url = this.getKMSUrl();
                Assert.assertEquals((Object)(keystore != null ? 1 : 0), (Object)url.getProtocol().equals("https"));
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                if (kerberos) {
                    for (String user : new String[]{"client", "client/host"}) {
                        TestKMS.this.doAs(user, new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                TestKMS.this.testJMXQuery(url, kerberos);
                                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                                Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                                Thread.sleep(4000L);
                                Token[] tokens = ((KeyProviderDelegationTokenExtension.DelegationTokenExtension)kp).addDelegationTokens("myuser", new Credentials());
                                Assert.assertEquals((long)1L, (long)tokens.length);
                                Assert.assertEquals((Object)"kms-dt", (Object)tokens[0].getKind().toString());
                                return null;
                            }
                        });
                    }
                } else {
                    TestKMS.this.testJMXQuery(url, kerberos);
                    KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                    Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                    Thread.sleep(4000L);
                    Token[] tokens = ((KeyProviderDelegationTokenExtension.DelegationTokenExtension)kp).addDelegationTokens("myuser", new Credentials());
                    Assert.assertEquals((long)1L, (long)tokens.length);
                    Assert.assertEquals((Object)"kms-dt", (Object)tokens[0].getKind().toString());
                }
                return null;
            }
        });
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
            this.sslFactory = null;
        }
    }

    @Test
    public void testStartStopHttpPseudo() throws Exception {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger((String)"com.sun.jersey.server.wadl.generators.AbstractWadlGeneratorGrammarGenerator"));
        try {
            this.testStartStop(false, false);
        }
        finally {
            logs.stopCapturing();
        }
        Assert.assertFalse((boolean)logs.getOutput().contains("Couldn't find grammar element for class"));
    }

    @Test
    public void testStartStopHttpsPseudo() throws Exception {
        this.testStartStop(true, false);
    }

    @Test
    public void testStartStopHttpKerberos() throws Exception {
        this.testStartStop(false, true);
    }

    @Test
    public void testStartStopHttpsKerberos() throws Exception {
        this.testStartStop(true, true);
    }

    @Test(timeout=30000L)
    public void testSpecialKeyNames() throws Exception {
        String specialKey = "key %^[\n{]}|\"<>\\";
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir, conf);
        conf.set("key.acl.key %^[\n{]}|\"<>\\.ALL", "*");
        TestKMS.writeConf(confDir, conf);
        this.runServer(null, null, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = new Configuration();
                URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                Assert.assertEquals((long)0L, (long)kp.getKeysMetadata(new String[0]).length);
                KeyProvider.Options options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                options.setDescription("l1");
                LOG.info("Creating key with name '{}'", (Object)"key %^[\n{]}|\"<>\\");
                KeyProvider.KeyVersion kv0 = kp.createKey("key %^[\n{]}|\"<>\\", options);
                Assert.assertNotNull((Object)kv0);
                Assert.assertEquals((Object)"key %^[\n{]}|\"<>\\", (Object)kv0.getName());
                Assert.assertNotNull((Object)kv0.getVersionName());
                Assert.assertNotNull((Object)kv0.getMaterial());
                return null;
            }
        });
    }

    @Test
    public void testKMSProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir, conf);
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.MANAGEMENT", "*");
        conf.set("key.acl.k2.READ", "*");
        conf.set("key.acl.k3.ALL", "*");
        conf.set("key.acl.k4.ALL", "*");
        conf.set("key.acl.k5.ALL", "*");
        conf.set("key.acl.k6.ALL", "*");
        TestKMS.writeConf(confDir, conf);
        this.runServer(null, null, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                Date started = new Date();
                Configuration conf = new Configuration();
                URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                Assert.assertEquals((long)0L, (long)kp.getKeysMetadata(new String[0]).length);
                KeyProvider.Options options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                options.setDescription("l1");
                KeyProvider.KeyVersion kv0 = kp.createKey("k1", options);
                Assert.assertNotNull((Object)kv0);
                Assert.assertNotNull((Object)kv0.getVersionName());
                Assert.assertNotNull((Object)kv0.getMaterial());
                KeyProvider.KeyVersion kv1 = kp.getKeyVersion(kv0.getVersionName());
                Assert.assertEquals((Object)kv0.getVersionName(), (Object)kv1.getVersionName());
                Assert.assertNotNull((Object)kv1.getMaterial());
                KeyProvider.KeyVersion cv1 = kp.getCurrentKey("k1");
                Assert.assertEquals((Object)kv0.getVersionName(), (Object)cv1.getVersionName());
                Assert.assertNotNull((Object)cv1.getMaterial());
                KeyProvider.Metadata m1 = kp.getMetadata("k1");
                Assert.assertEquals((Object)"AES/CTR/NoPadding", (Object)m1.getCipher());
                Assert.assertEquals((Object)"AES", (Object)m1.getAlgorithm());
                Assert.assertEquals((long)128L, (long)m1.getBitLength());
                Assert.assertEquals((long)1L, (long)m1.getVersions());
                Assert.assertNotNull((Object)m1.getCreated());
                Assert.assertTrue((boolean)started.before(m1.getCreated()));
                List lkv1 = kp.getKeyVersions("k1");
                Assert.assertEquals((long)1L, (long)lkv1.size());
                Assert.assertEquals((Object)kv0.getVersionName(), (Object)((KeyProvider.KeyVersion)lkv1.get(0)).getVersionName());
                Assert.assertNotNull((Object)kv1.getMaterial());
                KeyProvider.KeyVersion kv2 = kp.rollNewVersion("k1");
                Assert.assertNotSame((Object)kv0.getVersionName(), (Object)kv2.getVersionName());
                Assert.assertNotNull((Object)kv2.getMaterial());
                kv2 = kp.getKeyVersion(kv2.getVersionName());
                boolean eq = true;
                for (int i = 0; i < kv1.getMaterial().length; ++i) {
                    eq = eq && kv1.getMaterial()[i] == kv2.getMaterial()[i];
                }
                Assert.assertFalse((boolean)eq);
                KeyProvider.KeyVersion cv2 = kp.getCurrentKey("k1");
                Assert.assertEquals((Object)kv2.getVersionName(), (Object)cv2.getVersionName());
                Assert.assertNotNull((Object)cv2.getMaterial());
                eq = true;
                for (int i = 0; i < kv1.getMaterial().length; ++i) {
                    eq = eq && cv2.getMaterial()[i] == kv2.getMaterial()[i];
                }
                Assert.assertTrue((boolean)eq);
                List lkv2 = kp.getKeyVersions("k1");
                Assert.assertEquals((long)2L, (long)lkv2.size());
                Assert.assertEquals((Object)kv1.getVersionName(), (Object)((KeyProvider.KeyVersion)lkv2.get(0)).getVersionName());
                Assert.assertNotNull((Object)((KeyProvider.KeyVersion)lkv2.get(0)).getMaterial());
                Assert.assertEquals((Object)kv2.getVersionName(), (Object)((KeyProvider.KeyVersion)lkv2.get(1)).getVersionName());
                Assert.assertNotNull((Object)((KeyProvider.KeyVersion)lkv2.get(1)).getMaterial());
                KeyProvider.Metadata m2 = kp.getMetadata("k1");
                Assert.assertEquals((Object)"AES/CTR/NoPadding", (Object)m2.getCipher());
                Assert.assertEquals((Object)"AES", (Object)m2.getAlgorithm());
                Assert.assertEquals((long)128L, (long)m2.getBitLength());
                Assert.assertEquals((long)2L, (long)m2.getVersions());
                Assert.assertNotNull((Object)m2.getCreated());
                Assert.assertTrue((boolean)started.before(m2.getCreated()));
                List ks1 = kp.getKeys();
                Assert.assertEquals((long)1L, (long)ks1.size());
                Assert.assertEquals((Object)"k1", ks1.get(0));
                KeyProvider.Metadata[] kms1 = kp.getKeysMetadata(new String[]{"k1"});
                Assert.assertEquals((long)1L, (long)kms1.length);
                Assert.assertEquals((Object)"AES/CTR/NoPadding", (Object)kms1[0].getCipher());
                Assert.assertEquals((Object)"AES", (Object)kms1[0].getAlgorithm());
                Assert.assertEquals((long)128L, (long)kms1[0].getBitLength());
                Assert.assertEquals((long)2L, (long)kms1[0].getVersions());
                Assert.assertNotNull((Object)kms1[0].getCreated());
                Assert.assertTrue((boolean)started.before(kms1[0].getCreated()));
                KeyProvider.KeyVersion kv = kp.getCurrentKey("k1");
                KeyProviderCryptoExtension kpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(kv.getName());
                Assert.assertEquals((Object)"EEK", (Object)ek1.getEncryptedKeyVersion().getVersionName());
                Assert.assertNotNull((Object)ek1.getEncryptedKeyVersion().getMaterial());
                Assert.assertEquals((long)kv.getMaterial().length, (long)ek1.getEncryptedKeyVersion().getMaterial().length);
                KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
                Assert.assertEquals((Object)"EK", (Object)k1.getVersionName());
                KeyProvider.KeyVersion k1a = kpExt.decryptEncryptedKey(ek1);
                Assert.assertArrayEquals((byte[])k1.getMaterial(), (byte[])k1a.getMaterial());
                Assert.assertEquals((long)kv.getMaterial().length, (long)k1.getMaterial().length);
                KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.generateEncryptedKey(kv.getName());
                KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
                boolean isEq = true;
                for (int i = 0; isEq && i < ek2.getEncryptedKeyVersion().getMaterial().length; ++i) {
                    isEq = k2.getMaterial()[i] == k1.getMaterial()[i];
                }
                Assert.assertFalse((boolean)isEq);
                kpExt.rollNewVersion(ek1.getEncryptionKeyName());
                KeyProviderCryptoExtension.EncryptedKeyVersion ek1r = kpExt.reencryptEncryptedKey(ek1);
                Assert.assertEquals((Object)"EEK", (Object)ek1r.getEncryptedKeyVersion().getVersionName());
                Assert.assertFalse((boolean)Arrays.equals(ek1.getEncryptedKeyVersion().getMaterial(), ek1r.getEncryptedKeyVersion().getMaterial()));
                Assert.assertEquals((long)kv.getMaterial().length, (long)ek1r.getEncryptedKeyVersion().getMaterial().length);
                Assert.assertEquals((Object)ek1.getEncryptionKeyName(), (Object)ek1r.getEncryptionKeyName());
                Assert.assertArrayEquals((byte[])ek1.getEncryptedKeyIv(), (byte[])ek1r.getEncryptedKeyIv());
                Assert.assertNotEquals((Object)ek1.getEncryptionKeyVersionName(), (Object)ek1r.getEncryptionKeyVersionName());
                KeyProvider.KeyVersion k1r = kpExt.decryptEncryptedKey(ek1r);
                Assert.assertEquals((Object)"EK", (Object)k1r.getVersionName());
                Assert.assertArrayEquals((byte[])k1.getMaterial(), (byte[])k1r.getMaterial());
                Assert.assertEquals((long)kv.getMaterial().length, (long)k1r.getMaterial().length);
                KeyProviderCryptoExtension.EncryptedKeyVersion ek3 = kpExt.generateEncryptedKey(kv.getName());
                KeyProvider.KeyVersion latest = kpExt.rollNewVersion(kv.getName());
                ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(3);
                ekvs.add(ek1);
                ekvs.add(ek2);
                ekvs.add(ek3);
                ekvs.add(ek1);
                ekvs.add(ek2);
                ekvs.add(ek3);
                kpExt.reencryptEncryptedKeys(ekvs);
                for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                    Assert.assertEquals((Object)latest.getVersionName(), (Object)ekv.getEncryptionKeyVersionName());
                }
                kp.deleteKey("k1");
                try {
                    kpExt.decryptEncryptedKey(ek1);
                    Assert.fail((String)"Should not be allowed !!");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("'k1@1' not found"));
                }
                Assert.assertNull((Object)kp.getKeyVersion("k1"));
                Assert.assertNull((Object)kp.getKeyVersions("k1"));
                Assert.assertNull((Object)kp.getMetadata("k1"));
                Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                Assert.assertEquals((long)0L, (long)kp.getKeysMetadata(new String[0]).length);
                options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                KeyProvider.KeyVersion kVer2 = kp.createKey("k2", options);
                KeyProvider.Metadata meta = kp.getMetadata("k2");
                Assert.assertNull((Object)meta.getDescription());
                Assert.assertEquals((Object)"k2", meta.getAttributes().get("key.acl.name"));
                try {
                    kpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                    kpExt.generateEncryptedKey(kVer2.getName());
                    Assert.fail((String)"User should not be allowed to encrypt !!");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                options.setDescription("d");
                kp.createKey("k3", options);
                meta = kp.getMetadata("k3");
                Assert.assertEquals((Object)"d", (Object)meta.getDescription());
                Assert.assertEquals((Object)"k3", meta.getAttributes().get("key.acl.name"));
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("a", "A");
                options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                attributes.put("key.acl.name", "k4");
                options.setAttributes(attributes);
                kp.createKey("k4", options);
                meta = kp.getMetadata("k4");
                Assert.assertNull((Object)meta.getDescription());
                Assert.assertEquals(attributes, (Object)meta.getAttributes());
                options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                options.setDescription("d");
                attributes.put("key.acl.name", "k5");
                options.setAttributes(attributes);
                kp.createKey("k5", options);
                meta = kp.getMetadata("k5");
                Assert.assertEquals((Object)"d", (Object)meta.getDescription());
                Assert.assertEquals(attributes, (Object)meta.getAttributes());
                KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                kpce.createKey("k6", options);
                KeyProviderCryptoExtension.EncryptedKeyVersion ekv1 = kpce.generateEncryptedKey("k6");
                kpce.rollNewVersion("k6");
                kpce.invalidateCache("k6");
                KeyProviderCryptoExtension.EncryptedKeyVersion ekv2 = kpce.generateEncryptedKey("k6");
                Assert.assertNotEquals((String)"rollover did not generate a new key even after queue is drained", (Object)ekv1.getEncryptionKeyVersionName(), (Object)ekv2.getEncryptionKeyVersionName());
                return null;
            }
        });
    }

    @Test
    public void testKMSProviderCaching() throws Exception {
        Configuration conf = new Configuration();
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir, conf);
        conf.set("key.acl.k1.ALL", "*");
        TestKMS.writeConf(confDir, conf);
        this.runServer(null, null, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                String keyName = "k1";
                String mockVersionName = "mock";
                Configuration conf = new Configuration();
                URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                KMSClientProvider kmscp = TestKMS.this.createKMSClientProvider(uri, conf);
                ValueQueue vq = (ValueQueue)Whitebox.getInternalState((Object)kmscp, (String)"encKeyVersionQueue");
                LoadingCache kq = (LoadingCache)Whitebox.getInternalState((Object)vq, (String)"keyQueues");
                KeyProviderCryptoExtension.EncryptedKeyVersion mockEKV = (KeyProviderCryptoExtension.EncryptedKeyVersion)Mockito.mock(KeyProviderCryptoExtension.EncryptedKeyVersion.class);
                Mockito.when((Object)mockEKV.getEncryptionKeyName()).thenReturn((Object)"k1");
                Mockito.when((Object)mockEKV.getEncryptionKeyVersionName()).thenReturn((Object)"mock");
                KeyProvider.Options options = new KeyProvider.Options(conf);
                options.setCipher("AES/CTR/NoPadding");
                options.setBitLength(128);
                options.setDescription("l1");
                KeyProvider.KeyVersion kv0 = kmscp.createKey("k1", options);
                Assert.assertNotNull((Object)kv0.getVersionName());
                Assert.assertEquals((String)"Default key version name is incorrect.", (Object)"k1@0", (Object)kmscp.generateEncryptedKey("k1").getEncryptionKeyVersionName());
                kmscp.invalidateCache("k1");
                ((LinkedBlockingQueue)kq.get((Object)"k1")).put(mockEKV);
                Assert.assertEquals((String)"Key version incorrect after invalidating cache + putting mock key.", (Object)"mock", (Object)kmscp.generateEncryptedKey("k1").getEncryptionKeyVersionName());
                for (int i = 0; i < 100; ++i) {
                    ((LinkedBlockingQueue)kq.get((Object)"k1")).put(mockEKV);
                    kmscp.invalidateCache("k1");
                    Assert.assertEquals((String)"Cache invalidation guarantee failed.", (Object)"k1@0", (Object)kmscp.generateEncryptedKey("k1").getEncryptionKeyVersionName());
                }
                return null;
            }
        });
    }

    @Test
    public void testKeyACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.GENERATE_EEK.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK");
        conf.set("key.acl.test_key.MANAGEMENT", "CREATE");
        conf.set("key.acl.some_key.MANAGEMENT", "ROLLOVER");
        conf.set("whitelist.key.acl.MANAGEMENT", "DECRYPT_EEK");
        conf.set("whitelist.key.acl.ALL", "DECRYPT_EEK");
        conf.set("key.acl.all_access.ALL", "GENERATE_EEK");
        conf.set("key.acl.all_access.DECRYPT_EEK", "ROLLOVER");
        conf.set("default.key.acl.MANAGEMENT", "ROLLOVER");
        conf.set("default.key.acl.GENERATE_EEK", "SOMEBODY");
        conf.set("default.key.acl.ALL", "ROLLOVER");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("CREATE", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.Options options = new KeyProvider.Options(conf);
                            Map attributes = options.getAttributes();
                            HashMap<String, String> newAttribs = new HashMap<String, String>(attributes);
                            newAttribs.put("key.acl.name", "test_key");
                            options.setAttributes(newAttribs);
                            KeyProvider.KeyVersion kv = kp.createKey("k0", options);
                            Assert.assertNull((Object)kv.getMaterial());
                            KeyProvider.KeyVersion rollVersion = kp.rollNewVersion("k0");
                            Assert.assertNull((Object)rollVersion.getMaterial());
                            KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            try {
                                kpce.generateEncryptedKey("k0");
                                Assert.fail((String)"User [CREATE] should not be allowed to generate_eek on k0");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            newAttribs = new HashMap(attributes);
                            newAttribs.put("key.acl.name", "all_access");
                            options.setAttributes(newAttribs);
                            try {
                                kp.createKey("kx", options);
                                Assert.fail((String)"User [CREATE] should not be allowed to create kx");
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("DECRYPT_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.Options options = new KeyProvider.Options(conf);
                            Map attributes = options.getAttributes();
                            HashMap<String, String> newAttribs = new HashMap<String, String>(attributes);
                            newAttribs.put("key.acl.name", "some_key");
                            options.setAttributes(newAttribs);
                            KeyProvider.KeyVersion kv = kp.createKey("kk0", options);
                            Assert.assertNull((Object)kv.getMaterial());
                            KeyProvider.KeyVersion rollVersion = kp.rollNewVersion("kk0");
                            Assert.assertNull((Object)rollVersion.getMaterial());
                            KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            try {
                                kpce.generateEncryptedKey("kk0");
                                Assert.fail((String)"User [DECRYPT_EEK] should not be allowed to generate_eek on kk0");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            newAttribs = new HashMap(attributes);
                            newAttribs.put("key.acl.name", "all_access");
                            options.setAttributes(newAttribs);
                            kp.createKey("kkx", options);
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("ROLLOVER", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.Options options = new KeyProvider.Options(conf);
                            Map attributes = options.getAttributes();
                            HashMap<String, String> newAttribs = new HashMap<String, String>(attributes);
                            newAttribs.put("key.acl.name", "test_key2");
                            options.setAttributes(newAttribs);
                            KeyProvider.KeyVersion kv = kp.createKey("k1", options);
                            Assert.assertNull((Object)kv.getMaterial());
                            KeyProvider.KeyVersion rollVersion = kp.rollNewVersion("k1");
                            Assert.assertNull((Object)rollVersion.getMaterial());
                            try {
                                kp.rollNewVersion("k0");
                                Assert.fail((String)"User [ROLLOVER] should not be allowed to rollover k0");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            try {
                                kpce.generateEncryptedKey("k1");
                                Assert.fail((String)"User [ROLLOVER] should not be allowed to generate_eek on k1");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            newAttribs = new HashMap(attributes);
                            newAttribs.put("key.acl.name", "all_access");
                            options.setAttributes(newAttribs);
                            try {
                                kp.createKey("kx", options);
                                Assert.fail((String)"User [ROLLOVER] should not be allowed to create kx");
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GET", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.Options options = new KeyProvider.Options(conf);
                            Map attributes = options.getAttributes();
                            HashMap<String, String> newAttribs = new HashMap<String, String>(attributes);
                            newAttribs.put("key.acl.name", "test_key");
                            options.setAttributes(newAttribs);
                            try {
                                kp.createKey("k2", options);
                                Assert.fail((String)"User [GET] should not be allowed to create key..");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            newAttribs = new HashMap(attributes);
                            newAttribs.put("key.acl.name", "all_access");
                            options.setAttributes(newAttribs);
                            try {
                                kp.createKey("kx", options);
                                Assert.fail((String)"User [GET] should not be allowed to create kx");
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                final KeyProviderCryptoExtension.EncryptedKeyVersion ekv = (KeyProviderCryptoExtension.EncryptedKeyVersion)TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

                    @Override
                    public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.Options options = new KeyProvider.Options(conf);
                            Map attributes = options.getAttributes();
                            HashMap<String, String> newAttribs = new HashMap<String, String>(attributes);
                            newAttribs.put("key.acl.name", "all_access");
                            options.setAttributes(newAttribs);
                            kp.createKey("kx", options);
                            KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            try {
                                return kpce.generateEncryptedKey("kx");
                            }
                            catch (Exception e) {
                                Assert.fail((String)"User [GENERATE_EEK] should be allowed to generate_eek on kx");
                            }
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("ROLLOVER", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            kpce.decryptEncryptedKey(ekv);
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        conf.set("default.key.acl.MANAGEMENT", "");
        conf.set("default.key.acl.GENERATE_EEK", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        KeyProviderCryptoExtension kpce = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                        KeyProviderCryptoExtension.EncryptedKeyVersion ekv = kpce.generateEncryptedKey("k1");
                        kpce.reencryptEncryptedKey(ekv);
                        ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(2);
                        ekvs.add(ekv);
                        ekvs.add(ekv);
                        kpce.reencryptEncryptedKeys(ekvs);
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSRestartKerberosAuth() throws Exception {
        this.doKMSRestart(true);
    }

    @Test
    public void testKMSRestartSimpleAuth() throws Exception {
        this.doKMSRestart(false);
    }

    public void doKMSRestart(boolean useKrb) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        if (useKrb) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.ALL", "*");
        conf.set("key.acl.k3.ALL", "*");
        TestKMS.writeConf(testDir, conf);
        KMSCallable<KeyProvider> c = new KMSCallable<KeyProvider>(){

            @Override
            public KeyProvider call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                KeyProvider kp = (KeyProvider)TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<KeyProvider>(){

                    @Override
                    public KeyProvider run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("k1", new byte[16], new KeyProvider.Options(conf));
                        return kp;
                    }
                });
                return kp;
            }
        };
        final KeyProvider retKp = this.runServer(null, null, testDir, c);
        this.runServer(c.getKMSUrl().getPort(), null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        retKp.createKey("k2", new byte[16], new KeyProvider.Options(conf));
                        retKp.createKey("k3", new byte[16], new KeyProvider.Options(conf));
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSAuthFailureRetry() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.kms.authentication.token.validity", "1");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.ALL", "*");
        conf.set("key.acl.k3.ALL", "*");
        conf.set("key.acl.k4.ALL", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("k0", new byte[16], new KeyProvider.Options(conf));
                        kp.createKey("k1", new byte[16], new KeyProvider.Options(conf));
                        Thread.sleep(3500L);
                        kp.createKey("k2", new byte[16], new KeyProvider.Options(conf));
                        return null;
                    }
                });
                return null;
            }
        });
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                conf.setInt("hadoop.security.kms.client.authentication.retry-count", 0);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("k3", new byte[16], new KeyProvider.Options(conf));
                        Thread.sleep(3500L);
                        try {
                            kp.createKey("k4", new byte[16], new KeyProvider.Options(conf));
                            Assert.fail((String)"This should not succeed..");
                        }
                        catch (IOException e) {
                            Assert.assertTrue((String)("HTTP exception must be a 401 : " + e.getMessage()), (boolean)e.getMessage().contains("401"));
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        final File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            kp.createKey("k", new KeyProvider.Options(conf));
                            Assert.fail();
                        }
                        catch (AuthorizationException authorizationException) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.createKey("k", new byte[16], new KeyProvider.Options(conf));
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.rollNewVersion("k");
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.rollNewVersion("k", new byte[16]);
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getKeys();
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getKeysMetadata(new String[]{"k"});
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getKeyVersion("k@0");
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getCurrentKey("k");
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getMetadata("k");
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        try {
                            kp.getKeyVersions("k");
                            Assert.fail();
                        }
                        catch (AuthorizationException ex) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("CREATE", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.KeyVersion kv = kp.createKey("k0", new KeyProvider.Options(conf));
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("DELETE", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            kp.deleteKey("k0");
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.KeyVersion kv = kp.createKey("k1", new byte[16], new KeyProvider.Options(conf));
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("ROLLOVER", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.KeyVersion kv = kp.rollNewVersion("k1");
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProvider.KeyVersion kv = kp.rollNewVersion("k1", new byte[16]);
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                final KeyProvider.KeyVersion currKv = (KeyProvider.KeyVersion)TestKMS.this.doAs("GET", new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                    @Override
                    public KeyProvider.KeyVersion run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            kp.getKeyVersion("k1@0");
                            KeyProvider.KeyVersion kv = kp.getCurrentKey("k1");
                            return kv;
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.toString());
                            return null;
                        }
                    }
                });
                final KeyProviderCryptoExtension.EncryptedKeyVersion encKv = (KeyProviderCryptoExtension.EncryptedKeyVersion)TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

                    @Override
                    public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpCE.generateEncryptedKey(currKv.getName());
                            return ek1;
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.toString());
                            return null;
                        }
                    }
                });
                TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                        kpCE.reencryptEncryptedKey(encKv);
                        ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(2);
                        ekvs.add(encKv);
                        ekvs.add(encKv);
                        kpCE.reencryptEncryptedKeys(ekvs);
                        return null;
                    }
                });
                TestKMS.this.doAs("DECRYPT_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            kpCE.decryptEncryptedKey(encKv);
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GET_KEYS", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            kp.getKeys();
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GET_METADATA", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            kp.getMetadata("k1");
                            kp.getKeysMetadata(new String[]{"k1"});
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                KMSWebApp.getACLs().stopReloader();
                GenericTestUtils.setLogLevel((Logger)KMSConfiguration.LOG, (Level)Level.TRACE);
                conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "foo");
                conf.set(KMSACLs.Type.GENERATE_EEK.getAclConfigKey(), "foo");
                TestKMS.writeConf(testDir, conf);
                KMSWebApp.getACLs().forceNextReloadForTesting();
                KMSWebApp.getACLs().run();
                TestKMS.this.doAs("CREATE", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("k2", new KeyProvider.Options(conf));
                            Assert.fail();
                        }
                        catch (AuthorizationException kp) {
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            kpCE.generateEncryptedKey("k1");
                        }
                        catch (IOException ex) {
                            if (ex.getCause().getCause() instanceof AuthorizationException) {
                                LOG.info("Caught expected exception.", (Throwable)ex);
                            }
                            throw ex;
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            kpCE.reencryptEncryptedKey(encKv);
                            Assert.fail((String)"Should not have been able to reencryptEncryptedKey");
                        }
                        catch (AuthorizationException ex) {
                            LOG.info("reencryptEncryptedKey caught expected exception.", (Throwable)ex);
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("GENERATE_EEK", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        try {
                            KeyProviderCryptoExtension kpCE = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
                            ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(2);
                            ekvs.add(encKv);
                            ekvs.add(encKv);
                            kpCE.reencryptEncryptedKeys(ekvs);
                            Assert.fail((String)"Should not have been able to reencryptEncryptedKeys");
                        }
                        catch (AuthorizationException ex) {
                            LOG.info("reencryptEncryptedKeys caught expected exception.", (Throwable)ex);
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSBlackList() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), " ");
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.GENERATE_EEK.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getBlacklistConfigKey(), "hdfs,otheradmin");
        conf.set("key.acl.ck0.ALL", "*");
        conf.set("key.acl.ck1.ALL", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("ck0", new KeyProvider.Options(conf));
                            KeyProviderCryptoExtension.EncryptedKeyVersion eek = ((KeyProviderCryptoExtension.CryptoExtension)kp).generateEncryptedKey("ck0");
                            ((KeyProviderCryptoExtension.CryptoExtension)kp).decryptEncryptedKey(eek);
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("hdfs", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("ck1", new KeyProvider.Options(conf));
                            KeyProviderCryptoExtension.EncryptedKeyVersion eek = ((KeyProviderCryptoExtension.CryptoExtension)kp).generateEncryptedKey("ck1");
                            ((KeyProviderCryptoExtension.CryptoExtension)kp).decryptEncryptedKey(eek);
                            Assert.fail((String)"admin user must not be allowed to decrypt !!");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("otheradmin", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("ck2", new KeyProvider.Options(conf));
                            KeyProviderCryptoExtension.EncryptedKeyVersion eek = ((KeyProviderCryptoExtension.CryptoExtension)kp).generateEncryptedKey("ck2");
                            ((KeyProviderCryptoExtension.CryptoExtension)kp).decryptEncryptedKey(eek);
                            Assert.fail((String)"admin user must not be allowed to decrypt !!");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testServicePrincipalACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), " ");
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "client");
        conf.set("default.key.acl.MANAGEMENT", "client,client/host");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("ck0", new KeyProvider.Options(conf));
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                TestKMS.this.doAs("client/host", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                            KeyProvider.KeyVersion kv = kp.createKey("ck1", new KeyProvider.Options(conf));
                            Assert.assertNull((Object)kv.getMaterial());
                        }
                        catch (Exception ex) {
                            Assert.fail((String)ex.getMessage());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSTimeout() throws Exception {
        KeyProvider kp;
        int port;
        ServerSocket sock;
        File confDir = TestKMS.getTestDir();
        Configuration conf = this.createBaseKMSConf(confDir);
        conf.setInt("hadoop.security.kms.client.timeout", 1);
        TestKMS.writeConf(confDir, conf);
        try {
            sock = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
            port = sock.getLocalPort();
        }
        catch (Exception e) {
            return;
        }
        URL url = new URL("http://localhost:" + port + "/kms");
        URI uri = TestKMS.createKMSUri(url);
        boolean caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            kp.getKeys();
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp).generateEncryptedKey("a");
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp).decryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)new KMSClientProvider.KMSEncryptedKeyVersion("a", "a", new byte[]{1, 2}, "EEK", new byte[]{1, 2}));
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        Assert.assertTrue((boolean)caughtTimeout);
        sock.close();
    }

    @Test
    public void testDelegationTokenAccess() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        String keyA = "key_a";
        String keyD = "key_d";
        conf.set("key.acl.key_a.ALL", "*");
        conf.set("key.acl.key_d.ALL", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                KeyProvider kp;
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                final Credentials credentials = new Credentials();
                UserGroupInformation nonKerberosUgi = UserGroupInformation.getCurrentUser();
                try {
                    kp = TestKMS.this.createProvider(uri, conf);
                    kp.createKey("key_a", new KeyProvider.Options(conf));
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        KeyProviderDelegationTokenExtension kpdte = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
                        kpdte.addDelegationTokens("foo", credentials);
                        return null;
                    }
                });
                nonKerberosUgi.addCredentials(credentials);
                try {
                    kp = TestKMS.this.createProvider(uri, conf);
                    kp.createKey("key_a", new KeyProvider.Options(conf));
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
                nonKerberosUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("key_d", new KeyProvider.Options(conf));
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testGetDelegationTokenByProxyUser() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.auth_to_local.mechanism", "mit");
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.proxyuser.client.users", "foo/localhost");
        conf.set("hadoop.kms.proxyuser.client.hosts", "localhost");
        conf.set("key.acl.kcc.ALL", "foo/localhost");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                UserGroupInformation proxyUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"client/host", (String)keytab.getAbsolutePath());
                UserGroupInformation foo = UserGroupInformation.createProxyUser((String)"foo/localhost", (UserGroupInformation)proxyUgi);
                final Credentials credentials = new Credentials();
                foo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        KeyProviderDelegationTokenExtension keyProviderDelegationTokenExtension = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
                        keyProviderDelegationTokenExtension.addDelegationTokens("client", credentials);
                        Assert.assertNotNull((Object)kp.createKey("kcc", new KeyProvider.Options(conf)));
                        return null;
                    }
                });
                UserGroupInformation nonKerberosUgi = UserGroupInformation.getCurrentUser();
                nonKerberosUgi.addCredentials(credentials);
                nonKerberosUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        Assert.assertNotNull((Object)kp.getMetadata("kcc"));
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private Configuration setupConfForKerberos(File confDir) throws Exception {
        Configuration conf = this.createBaseKMSConf(confDir, null);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        return conf;
    }

    @Test
    public void testDelegationTokensOpsHttpPseudo() throws Exception {
        this.testDelegationTokensOps(false, false);
    }

    @Test
    public void testDelegationTokensOpsHttpKerberized() throws Exception {
        this.testDelegationTokensOps(false, true);
    }

    @Test
    public void testDelegationTokensOpsHttpsPseudo() throws Exception {
        this.testDelegationTokensOps(true, false);
    }

    @Test
    public void testDelegationTokensOpsHttpsKerberized() throws Exception {
        this.testDelegationTokensOps(true, true);
    }

    private Text getTokenService(KeyProvider provider) {
        Assert.assertTrue((String)"KeyProvider should be an instance of LoadBalancingKMSClientProvider", (boolean)(provider instanceof LoadBalancingKMSClientProvider));
        Assert.assertEquals((String)"Num client providers should be 1", (long)1L, (long)((LoadBalancingKMSClientProvider)provider).getProviders().length);
        Text tokenService = new Text(((LoadBalancingKMSClientProvider)provider).getProviders()[0].getCanonicalServiceName());
        return tokenService;
    }

    private void testDelegationTokensOps(boolean ssl, final boolean kerb) throws Exception {
        String password;
        String keystore;
        File confDir = TestKMS.getTestDir();
        Configuration conf = kerb ? this.setupConfForKerberos(confDir) : this.createBaseKMSConf(confDir, null);
        if (ssl) {
            String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestKMS.class);
            KeyStoreTestUtil.setupSSLConfig((String)confDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
            keystore = confDir.getAbsolutePath() + "/serverKS.jks";
            password = "serverP";
        } else {
            keystore = null;
            password = null;
        }
        TestKMS.writeConf(confDir, conf);
        this.runServer(keystore, password, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration clientConf = new Configuration();
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                clientConf.set("hadoop.security.key.provider.path", TestKMS.createKMSUri(this.getKMSUrl()).toString());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void run() throws Exception {
                        UserGroupInformation otherUgi;
                        KeyProvider kp = TestKMS.this.createProvider(uri, clientConf);
                        clientConf.unset("hadoop.security.key.provider.path");
                        KeyProviderDelegationTokenExtension kpdte = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
                        Credentials credentials = new Credentials();
                        final Token[] tokens = kpdte.addDelegationTokens("client1", credentials);
                        Text tokenService = TestKMS.this.getTokenService(kp);
                        Assert.assertEquals((long)1L, (long)credentials.getAllTokens().size());
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)credentials.getToken(tokenService).getKind());
                        for (Token token : tokens) {
                            if (!token.getKind().equals((Object)KMSDelegationToken.TOKEN_KIND)) {
                                LOG.info("Skipping token {}", (Object)token);
                                continue;
                            }
                            LOG.info("Got dt for " + uri + "; " + token);
                            try {
                                token.renew(clientConf);
                                Assert.fail((String)"client should not be allowed to renew token withrenewer=client1");
                            }
                            catch (Exception e) {
                                DelegationTokenIdentifier identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
                                GenericTestUtils.assertExceptionContains((String)("tries to renew a token (" + identifier + ") with non-matching renewer"), (Throwable)e);
                            }
                        }
                        if (kerb) {
                            UserGroupInformation.loginUserFromKeytab((String)"client1", (String)keytab.getAbsolutePath());
                            otherUgi = UserGroupInformation.getLoginUser();
                        } else {
                            otherUgi = UserGroupInformation.createUserForTesting((String)"client1", (String[])new String[]{"other group"});
                            UserGroupInformation.setLoginUser((UserGroupInformation)otherUgi);
                        }
                        try {
                            otherUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    boolean renewed = false;
                                    for (Token token : tokens) {
                                        if (!token.getKind().equals((Object)KMSDelegationToken.TOKEN_KIND)) {
                                            LOG.info("Skipping token {}", (Object)token);
                                            continue;
                                        }
                                        LOG.info("Got dt for " + uri + "; " + token);
                                        long tokenLife = token.renew(clientConf);
                                        LOG.info("Renewed token of kind {}, new lifetime:{}", (Object)token.getKind(), (Object)tokenLife);
                                        Thread.sleep(100L);
                                        long newTokenLife = token.renew(clientConf);
                                        LOG.info("Renewed token of kind {}, new lifetime:{}", (Object)token.getKind(), (Object)newTokenLife);
                                        Assert.assertTrue((newTokenLife > tokenLife ? 1 : 0) != 0);
                                        renewed = true;
                                    }
                                    Assert.assertTrue((boolean)renewed);
                                    for (Token token : tokens) {
                                        if (!token.getKind().equals((Object)KMSDelegationToken.TOKEN_KIND)) {
                                            LOG.info("Skipping token {}", (Object)token);
                                            continue;
                                        }
                                        LOG.info("Got dt for " + uri + "; " + token);
                                        token.cancel(clientConf);
                                        LOG.info("Cancelled token of kind {}", (Object)token.getKind());
                                        try {
                                            token.renew(clientConf);
                                            Assert.fail((String)"should not be able to renew a canceled token");
                                        }
                                        catch (Exception e) {
                                            LOG.info("Expected exception when renewing token", (Throwable)e);
                                        }
                                    }
                                    return null;
                                }
                            });
                            kp.close();
                            Void void_ = null;
                            return void_;
                        }
                        finally {
                            otherUgi.logoutUserFromKeytab();
                        }
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testDelegationTokensUpdatedInUGI() throws Exception {
        Configuration conf = new Configuration();
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir, conf);
        conf.set("hadoop.kms.authentication.delegation-token.max-lifetime.sec", "5");
        conf.set("hadoop.kms.authentication.delegation-token.renew-interval.sec", "5");
        TestKMS.writeConf(confDir, conf);
        this.runServer(null, null, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration clientConf = new Configuration();
                URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                clientConf.set("hadoop.security.key.provider.path", TestKMS.createKMSUri(this.getKMSUrl()).toString());
                final KeyProvider kp = TestKMS.this.createProvider(uri, clientConf);
                final KeyProviderDelegationTokenExtension kpdte = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
                InetSocketAddress kmsAddr = new InetSocketAddress(this.getKMSUrl().getHost(), this.getKMSUrl().getPort());
                final HashSet job1Token = new HashSet();
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        Credentials credentials = new Credentials();
                        kpdte.addDelegationTokens("client", credentials);
                        Text tokenService = TestKMS.this.getTokenService(kp);
                        Assert.assertEquals((long)1L, (long)credentials.getAllTokens().size());
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)credentials.getToken(tokenService).getKind());
                        UserGroupInformation.getCurrentUser().addCredentials(credentials);
                        LOG.info("Added kms dt to credentials: {}", (Object)UserGroupInformation.getCurrentUser().getCredentials().getAllTokens());
                        Token token = UserGroupInformation.getCurrentUser().getCredentials().getToken(tokenService);
                        Assert.assertNotNull((Object)token);
                        job1Token.add(token);
                        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
                        DataInputStream dis = new DataInputStream(buf);
                        DelegationTokenIdentifier id = new DelegationTokenIdentifier(token.getKind());
                        id.readFields((DataInput)dis);
                        dis.close();
                        long maxTime = id.getMaxDate();
                        Thread.sleep(5100L);
                        Assert.assertTrue((String)("maxTime " + maxTime + " is not less than now."), (maxTime > 0L && maxTime < Time.now() ? 1 : 0) != 0);
                        try {
                            kp.getKeys();
                            Assert.fail((String)"Operation should fail since dt is expired.");
                        }
                        catch (Exception e) {
                            LOG.info("Expected error.", (Throwable)e);
                        }
                        return null;
                    }
                });
                Assert.assertFalse((boolean)job1Token.isEmpty());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        Credentials newCreds = new Credentials();
                        kpdte.addDelegationTokens("client", newCreds);
                        Text tokenService = TestKMS.this.getTokenService(kp);
                        Assert.assertEquals((long)1L, (long)newCreds.getAllTokens().size());
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)newCreds.getToken(tokenService).getKind());
                        Credentials oldCreds = new Credentials();
                        for (Token token : job1Token) {
                            if (!token.getKind().equals((Object)KMSDelegationToken.TOKEN_KIND)) continue;
                            oldCreds.addToken(tokenService, token);
                        }
                        UserGroupInformation.getCurrentUser().addCredentials(oldCreds);
                        LOG.info("Added old kms dt to credentials: {}", (Object)UserGroupInformation.getCurrentUser().getCredentials().getAllTokens());
                        try {
                            kp.getKeys();
                            Assert.fail((String)"Operation should fail since dt is expired.");
                        }
                        catch (Exception e) {
                            LOG.info("Expected error.", (Throwable)e);
                        }
                        Assert.assertEquals((long)1L, (long)newCreds.getAllTokens().size());
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)newCreds.getToken(tokenService).getKind());
                        UserGroupInformation.getCurrentUser().addCredentials(newCreds);
                        LOG.info("Credetials now are: {}", (Object)UserGroupInformation.getCurrentUser().getCredentials().getAllTokens());
                        kp.getKeys();
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSWithZKSigner() throws Exception {
        this.doKMSWithZK(true, false);
    }

    @Test
    public void testKMSWithZKDTSM() throws Exception {
        this.doKMSWithZK(false, true);
    }

    @Test
    public void testKMSWithZKSignerAndDTSM() throws Exception {
        this.doKMSWithZK(true, true);
    }

    private <T> T runServerWithZooKeeper(boolean zkDTSM, boolean zkSigner, KMSCallable<T> callable) throws Exception {
        return this.runServerWithZooKeeper(zkDTSM, zkSigner, callable, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runServerWithZooKeeper(boolean zkDTSM, boolean zkSigner, KMSCallable<T> callable, int kmsSize) throws Exception {
        TestingServer zkServer = null;
        try {
            zkServer = new TestingServer();
            zkServer.start();
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "kerberos");
            File testDir = TestKMS.getTestDir();
            conf = this.createBaseKMSConf(testDir, conf);
            conf.set("hadoop.kms.authentication.type", "kerberos");
            conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
            conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
            conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
            if (zkSigner) {
                conf.set("hadoop.kms.authentication.signer.secret.provider", "zookeeper");
                conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.path", "/testKMSWithZKDTSM");
                conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string", zkServer.getConnectString());
            }
            if (zkDTSM) {
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.enable", "true");
            }
            if (zkDTSM && !zkSigner) {
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.zkConnectionString", zkServer.getConnectString());
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.znodeWorkingPath", "testZKPath");
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.zkAuthType", "none");
            }
            for (KMSACLs.Type type : KMSACLs.Type.values()) {
                conf.set(type.getAclConfigKey(), type.toString());
            }
            conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
            conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
            conf.set("key.acl.k0.ALL", "*");
            conf.set("key.acl.k1.ALL", "*");
            conf.set("key.acl.k2.ALL", "*");
            conf.set("key.acl.k3.ALL", "*");
            TestKMS.writeConf(testDir, conf);
            int[] ports = new int[kmsSize];
            for (int i = 0; i < ports.length; ++i) {
                ports[i] = -1;
            }
            T t = this.runServer(ports, null, null, testDir, callable);
            return t;
        }
        finally {
            if (zkServer != null) {
                zkServer.stop();
                zkServer.close();
            }
        }
    }

    public void doKMSWithZK(boolean zkDTSM, boolean zkSigner) throws Exception {
        KMSCallable<KeyProvider> c = new KMSCallable<KeyProvider>(){

            @Override
            public KeyProvider call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                KeyProvider kp = (KeyProvider)TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<KeyProvider>(){

                    @Override
                    public KeyProvider run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("k1", new byte[16], new KeyProvider.Options(conf));
                        kp.createKey("k2", new byte[16], new KeyProvider.Options(conf));
                        kp.createKey("k3", new byte[16], new KeyProvider.Options(conf));
                        return kp;
                    }
                });
                return kp;
            }
        };
        this.runServerWithZooKeeper(zkDTSM, zkSigner, c);
    }

    @Test
    public void testKMSHAZooKeeperDelegationToken() throws Exception {
        int kmsSize = 2;
        this.doKMSWithZKWithDelegationToken(true, true, 2);
    }

    private void doKMSWithZKWithDelegationToken(boolean zkDTSM, boolean zkSigner, int kmsSize) throws Exception {
        KMSCallable<Void> c = new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                URI[] uris = TestKMS.createKMSHAUri(this.getKMSHAUrl());
                final Credentials credentials = new Credentials();
                UserGroupInformation nonKerberosUgi = UserGroupInformation.getCurrentUser();
                final String lbUri = this.generateLoadBalancingKeyProviderUriString();
                final LoadBalancingKMSClientProvider lbkp = TestKMS.this.createHAProvider(URI.create(lbUri), uris, conf);
                conf.unset("hadoop.security.key.provider.path");
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProviderDelegationTokenExtension kpdte = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)lbkp);
                        kpdte.addDelegationTokens("foo", credentials);
                        return null;
                    }
                });
                nonKerberosUgi.addCredentials(credentials);
                nonKerberosUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        int i = 0;
                        for (KMSClientProvider provider : lbkp.getProviders()) {
                            String key = "k" + i++;
                            LOG.info("Connect to {} to create key {}.", (Object)provider, (Object)key);
                            provider.createKey(key, new KeyProvider.Options(conf));
                        }
                        return null;
                    }
                });
                final Collection tokens = credentials.getAllTokens();
                TestKMS.this.doAs("foo", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        Assert.assertEquals((long)1L, (long)tokens.size());
                        Token token = (Token)tokens.iterator().next();
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)token.getKind());
                        LOG.info("Got dt for token: {}", (Object)token);
                        long tokenLife = token.renew(conf);
                        LOG.info("Renewed token {}, new lifetime:{}", (Object)token, (Object)tokenLife);
                        Thread.sleep(10L);
                        long newTokenLife = token.renew(conf);
                        LOG.info("Renewed token {}, new lifetime:{}", (Object)token, (Object)newTokenLife);
                        Assert.assertTrue((newTokenLife > tokenLife ? 1 : 0) != 0);
                        LOG.info("Got dt for token: {}", (Object)token);
                        token.cancel(conf);
                        LOG.info("Cancelled token {}", (Object)token);
                        try {
                            token.renew(conf);
                            Assert.fail((String)"should not be able to renew a canceled token");
                        }
                        catch (Exception e) {
                            LOG.info("Expected exception when renewing token", (Throwable)e);
                        }
                        return null;
                    }
                });
                final Credentials newCredentials = new Credentials();
                TestKMS.this.doAs("SET_KEY_MATERIAL", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProviderDelegationTokenExtension kpdte = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)lbkp);
                        kpdte.addDelegationTokens("foo", newCredentials);
                        return null;
                    }
                });
                TestKMS.this.doAs("foo", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KMSClientProvider kp1 = lbkp.getProviders()[0];
                        URL[] urls = this.getKMSHAUrl();
                        Collection tokens = newCredentials.getAllTokens();
                        Assert.assertEquals((long)1L, (long)tokens.size());
                        Token token = (Token)tokens.iterator().next();
                        Assert.assertEquals((Object)KMSDelegationToken.TOKEN_KIND, (Object)token.getKind());
                        Text text = SecurityUtil.buildTokenService((InetSocketAddress)new InetSocketAddress(urls[0].getHost(), urls[0].getPort()));
                        token.setService(text);
                        conf.set("hadoop.security.key.provider.path", lbUri);
                        long tokenLife = 0L;
                        for (KMSClientProvider kp : lbkp.getProviders()) {
                            long renewedTokenLife = token.renew(conf);
                            LOG.info("Renewed token of kind {}, new lifetime:{}", (Object)token.getKind(), (Object)renewedTokenLife);
                            Assert.assertTrue((renewedTokenLife > tokenLife ? 1 : 0) != 0);
                            tokenLife = renewedTokenLife;
                            Thread.sleep(10L);
                        }
                        token.cancel(conf);
                        try {
                            token.renew(conf);
                            Assert.fail((String)"should not be able to renew a canceled token");
                        }
                        catch (IOException e) {
                            LOG.info("Expected exception when renewing token", (Throwable)e);
                        }
                        return null;
                    }
                });
                return null;
            }
        };
        this.runServerWithZooKeeper(zkDTSM, zkSigner, c, kmsSize);
    }

    @Test
    public void testProxyUserKerb() throws Exception {
        this.doProxyUserTest(true);
    }

    @Test
    public void testProxyUserSimple() throws Exception {
        this.doProxyUserTest(false);
    }

    public void doProxyUserTest(final boolean kerberos) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.kms.proxyuser.client.users", "foo,bar");
        conf.set("hadoop.kms.proxyuser.client.hosts", "*");
        conf.set("key.acl.kaa.ALL", "client");
        conf.set("key.acl.kbb.ALL", "foo");
        conf.set("key.acl.kcc.ALL", "foo1");
        conf.set("key.acl.kdd.ALL", "bar");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                UserGroupInformation proxyUgi = null;
                if (kerberos) {
                    proxyUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"client", (String)keytab.getAbsolutePath());
                } else {
                    proxyUgi = UserGroupInformation.createRemoteUser((String)"client");
                    UserGroupInformation.setLoginUser((UserGroupInformation)proxyUgi);
                }
                final UserGroupInformation clientUgi = proxyUgi;
                clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        final KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.createKey("kaa", new KeyProvider.Options(conf));
                        UserGroupInformation fooUgi = UserGroupInformation.createProxyUser((String)"foo", (UserGroupInformation)clientUgi);
                        fooUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                Assert.assertNotNull((Object)kp.createKey("kbb", new KeyProvider.Options(conf)));
                                return null;
                            }
                        });
                        UserGroupInformation foo1Ugi = UserGroupInformation.createProxyUser((String)"foo1", (UserGroupInformation)clientUgi);
                        foo1Ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                try {
                                    kp.createKey("kcc", new KeyProvider.Options(conf));
                                    Assert.fail();
                                }
                                catch (AuthorizationException authorizationException) {
                                }
                                catch (Exception ex) {
                                    Assert.fail((String)ex.getMessage());
                                }
                                return null;
                            }
                        });
                        UserGroupInformation barUgi = UserGroupInformation.createProxyUser((String)"bar", (UserGroupInformation)clientUgi);
                        barUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                Assert.assertNotNull((Object)kp.createKey("kdd", new KeyProvider.Options(conf)));
                                return null;
                            }
                        });
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testWebHDFSProxyUserKerb() throws Exception {
        this.doWebHDFSProxyUserTest(true);
    }

    @Test
    public void testWebHDFSProxyUserSimple() throws Exception {
        this.doWebHDFSProxyUserTest(false);
    }

    @Test
    public void testTGTRenewal() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("max.ticket.lifetime", "3");
        kdcConf.setProperty("min.ticket.lifetime", "3");
        TestKMS.setUpMiniKdc(kdcConf);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.kms.proxyuser.client.users", "*");
        conf.set("hadoop.kms.proxyuser.client.hosts", "*");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
                UserGroupInformation.loginUserFromKeytab((String)"client", (String)keytab.getAbsolutePath());
                final UserGroupInformation clientUgi = UserGroupInformation.getCurrentUser();
                clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        Thread.sleep(3100L);
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        kp.getKeys();
                        Thread.sleep(3100L);
                        kp = TestKMS.this.createProvider(uri, conf);
                        ((KeyProviderDelegationTokenExtension.DelegationTokenExtension)kp).addDelegationTokens("myuser", new Credentials());
                        UserGroupInformation anotherUgi = UserGroupInformation.createProxyUser((String)"client1", (UserGroupInformation)clientUgi);
                        anotherUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                Thread.sleep(3100L);
                                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                                kp.getKeys();
                                return null;
                            }
                        });
                        return null;
                    }
                });
                return null;
            }
        });
    }

    public void doWebHDFSProxyUserTest(final boolean kerberos) throws Exception {
        Configuration conf = new Configuration();
        if (kerberos) {
            conf.set("hadoop.security.authentication", "kerberos");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.security.kms.client.timeout", "300");
        conf.set("hadoop.kms.proxyuser.client.users", "foo,bar");
        conf.set("hadoop.kms.proxyuser.client.hosts", "*");
        conf.set("key.acl.kaa.ALL", "foo");
        conf.set("key.acl.kbb.ALL", "foo1");
        conf.set("key.acl.kcc.ALL", "bar");
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                conf.setInt("hadoop.security.key.default.bitlength", 128);
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                UserGroupInformation proxyUgi = null;
                proxyUgi = kerberos ? UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"client", (String)keytab.getAbsolutePath()) : UserGroupInformation.createRemoteUser((String)"client");
                final UserGroupInformation clientUgi = proxyUgi;
                clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        UserGroupInformation fooUgi = UserGroupInformation.createProxyUser((String)"foo", (UserGroupInformation)clientUgi);
                        fooUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                                Assert.assertNotNull((Object)kp.createKey("kaa", new KeyProvider.Options(conf)));
                                return null;
                            }
                        });
                        UserGroupInformation foo1Ugi = UserGroupInformation.createProxyUser((String)"foo1", (UserGroupInformation)clientUgi);
                        foo1Ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                try {
                                    KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                                    kp.createKey("kbb", new KeyProvider.Options(conf));
                                    Assert.fail();
                                }
                                catch (Exception ex) {
                                    GenericTestUtils.assertExceptionContains((String)"Error while authenticating with endpoint", (Throwable)ex);
                                    GenericTestUtils.assertExceptionContains((String)"Forbidden", (Throwable)ex.getCause().getCause());
                                }
                                return null;
                            }
                        });
                        UserGroupInformation barUgi = UserGroupInformation.createProxyUser((String)"bar", (UserGroupInformation)clientUgi);
                        barUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                                Assert.assertNotNull((Object)kp.createKey("kcc", new KeyProvider.Options(conf)));
                                return null;
                            }
                        });
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void testKMSJMX() throws Exception {
        Configuration conf = new Configuration();
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir, conf);
        String processName = "testkmsjmx";
        conf.set("hadoop.kms.metrics.process.name", "testkmsjmx");
        TestKMS.writeConf(confDir, conf);
        this.runServer(null, null, confDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                int len;
                URL jmxUrl = new URL(this.getKMSUrl() + "/jmx?user.name=whatever&qry=Hadoop:service=" + "testkmsjmx" + ",name=JvmMetrics");
                LOG.info("Requesting jmx from " + jmxUrl);
                StringBuilder sb = new StringBuilder();
                InputStream in = jmxUrl.openConnection().getInputStream();
                byte[] buffer = new byte[65536];
                while ((len = in.read(buffer)) > 0) {
                    sb.append(new String(buffer, 0, len));
                }
                LOG.info("jmx returned: " + sb.toString());
                Assert.assertTrue((boolean)sb.toString().contains("JvmMetrics"));
                return null;
            }
        });
    }

    @Test
    public void testFilterInitializer() throws Exception {
        Configuration conf = new Configuration();
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir, conf);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.kms.authentication.token.validity", "1");
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.set("hadoop.http.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.http.authentication.kerberos.keytab", keytab.getAbsolutePath());
        TestKMS.writeConf(testDir, conf);
        this.runServer(null, null, testDir, new KMSCallable<Void>(){

            @Override
            public Void call() throws Exception {
                final Configuration conf = new Configuration();
                URL url = this.getKMSUrl();
                final URI uri = TestKMS.createKMSUri(this.getKMSUrl());
                TestKMS.this.doAs("client", new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        KeyProvider kp = TestKMS.this.createProvider(uri, conf);
                        Assert.assertTrue((boolean)kp.getKeys().isEmpty());
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private static class KerberosConfiguration
    extends javax.security.auth.login.Configuration {
        private String principal;
        private String keytab;
        private boolean isInitiator;

        private KerberosConfiguration(String principal, File keytab, boolean client) {
            this.principal = principal;
            this.keytab = keytab.getAbsolutePath();
            this.isInitiator = client;
        }

        public static javax.security.auth.login.Configuration createClientConfig(String principal, File keytab) {
            return new KerberosConfiguration(principal, keytab, true);
        }

        private static String getKrb5LoginModuleName() {
            return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", this.keytab);
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", Boolean.toString(this.isInitiator));
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                options.put("ticketCache", ticketCache);
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConfiguration.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    public static abstract class KMSCallable<T>
    implements Callable<T> {
        private List<URL> kmsUrl;

        protected URL getKMSUrl() {
            return this.kmsUrl.get(0);
        }

        protected URL[] getKMSHAUrl() {
            URL[] urls = new URL[this.kmsUrl.size()];
            return this.kmsUrl.toArray(urls);
        }

        protected void addKMSUrl(URL url) {
            if (this.kmsUrl == null) {
                this.kmsUrl = new ArrayList<URL>();
            }
            this.kmsUrl.add(url);
        }

        protected String generateLoadBalancingKeyProviderUriString() {
            if (this.kmsUrl == null || this.kmsUrl.size() == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.kmsUrl.size(); ++i) {
                sb.append("kms://" + this.kmsUrl.get(0).getProtocol() + "@");
                URL url = this.kmsUrl.get(i);
                sb.append(url.getAuthority());
                if (url.getPath() != null) {
                    sb.append(url.getPath());
                }
                if (i >= this.kmsUrl.size() - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }
}

