/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.eclipse.jetty.server.Response;

@InterfaceAudience.Private
public class KMSAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    public static final String CONFIG_PREFIX = "hadoop.kms.authentication.";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
        Configuration conf = KMSWebApp.getConfiguration();
        return this.getKMSConfiguration(conf);
    }

    @VisibleForTesting
    Properties getKMSConfiguration(Configuration conf) {
        Properties props = new Properties();
        Map propsWithPrefixMap = conf.getPropsWithPrefix(CONFIG_PREFIX);
        for (Map.Entry entry : propsWithPrefixMap.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String authType = props.getProperty("type");
        if (authType.equals("simple")) {
            props.setProperty("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("kerberos")) {
            props.setProperty("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
        }
        props.setProperty("delegation-token.token-kind", "kms-dt");
        return props;
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Map proxyuserConf = KMSWebApp.getConfiguration().getValByRegex("hadoop\\.kms\\.proxyuser\\.");
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : proxyuserConf.entrySet()) {
            conf.set(((String)entry.getKey()).substring("hadoop.kms.".length()), (String)entry.getValue());
        }
        return conf;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        KMSResponse kmsResponse = new KMSResponse(response);
        super.doFilter(request, (ServletResponse)kmsResponse, filterChain);
        if (kmsResponse.statusCode != 200 && kmsResponse.statusCode != 201 && kmsResponse.statusCode != 401) {
            KMSWebApp.getInvalidCallsMeter().mark();
        }
        if (kmsResponse.statusCode == 401) {
            KMSWebApp.getUnauthenticatedCallsMeter().mark();
            String method = ((HttpServletRequest)request).getMethod();
            StringBuffer requestURL = ((HttpServletRequest)request).getRequestURL();
            String queryString = ((HttpServletRequest)request).getQueryString();
            if (queryString != null) {
                requestURL.append("?").append(queryString);
            }
            if (!method.equals("OPTIONS")) {
                KMSWebApp.getKMSAudit().unauthenticated(request.getRemoteHost(), method, requestURL.toString(), kmsResponse.msg);
            }
        }
    }

    private static class KMSResponse
    extends HttpServletResponseWrapper {
        public int statusCode;
        public String msg;

        public KMSResponse(ServletResponse response) {
            super((HttpServletResponse)response);
        }

        public void setStatus(int sc) {
            this.statusCode = sc;
            super.setStatus(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.statusCode = sc;
            this.msg = msg;
            ServletResponse response = this.getResponse();
            if (response instanceof Response) {
                ((Response)response).setStatusWithReason(sc, msg);
            } else {
                KMS.LOG.warn("The wrapped response object is instance of {}, not org.eclipse.jetty.server.Response. Can't set custom error message", response.getClass());
            }
            super.sendError(sc, HtmlQuoting.quoteHtmlChars((String)msg));
        }

        public void sendError(int sc) throws IOException {
            this.statusCode = sc;
            super.sendError(sc);
        }

        @Deprecated
        public void setStatus(int sc, String sm) {
            this.statusCode = sc;
            this.msg = sm;
            super.setStatus(sc, sm);
        }
    }
}

