/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.io.DataInputBuffer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HRegionInfo
implements Comparable<HRegionInfo> {
    @Deprecated
    public static final byte VERSION = 1;
    private static final Log LOG = LogFactory.getLog(HRegionInfo.class);
    private static final int ENC_SEPARATOR = 46;
    public static final int MD5_HEX_LENGTH = 32;
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private String regionNameStr = "";
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private volatile String encodedName = NO_HASH;
    private byte[] encodedNameAsBytes = null;
    private TableName tableName = null;
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, TableName.META_TABLE_NAME);

    private static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString((byte[])regionName, (int)(regionName.length - 32 - 1), (int)32);
        } else {
            int hashVal = Math.abs(JenkinsHash.getInstance().hash(regionName, regionName.length, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public String getShortNameToLog() {
        return HRegionInfo.prettyPrint(this.getEncodedName());
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/hbase:meta";
        }
        return encodedRegionName;
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        this.hashCode = result ^= Arrays.hashCode(this.tableName.getName());
    }

    private HRegionInfo(long regionId, TableName tableName) {
        this.regionId = regionId;
        this.tableName = tableName;
        this.regionName = HRegionInfo.createRegionName(tableName, null, regionId, false);
        this.regionNameStr = Bytes.toStringBinary((byte[])this.regionName);
        this.setHashCode();
    }

    @Deprecated
    public HRegionInfo() {
    }

    public HRegionInfo(TableName tableName) {
        this(tableName, null, null);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableName, startKey, endKey, false);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        this.tableName = tableName;
        this.offLine = false;
        this.regionId = regionid;
        this.regionName = HRegionInfo.createRegionName(this.tableName, startKey, this.regionId, true);
        this.regionNameStr = Bytes.toStringBinary((byte[])this.regionName);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableName = tableName;
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.regionNameStr = Bytes.toStringBinary((byte[])this.regionName);
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.tableName;
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, String id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)id), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, boolean newFormat) {
        byte[] b = new byte[tableName.getName().length + 2 + id.length + (startKey == null ? 0 : startKey.length) + (newFormat ? 34 : 0)];
        int offset = tableName.getName().length;
        System.arraycopy(tableName.getName(), 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex((byte[])b, (int)0, (int)offset);
            byte[] md5HashBytes = Bytes.toBytes((String)md5Hash);
            if (md5HashBytes.length != 32) {
                LOG.error((Object)("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length));
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            offset += 32;
            b[offset++] = 46;
        }
        return b;
    }

    @Deprecated
    public static byte[] getTableName(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        byte[] buff = new byte[offset];
        System.arraycopy(regionName, 0, buff, 0, offset);
        return buff;
    }

    public static TableName getTable(byte[] regionName) {
        return TableName.valueOf((byte[])HRegionInfo.getTableName(regionName));
    }

    public static byte[] getStartKey(byte[] regionName) throws IOException {
        return HRegionInfo.parseRegionName(regionName)[1];
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        for (int i = regionName.length - 1; i > 0; --i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[regionName.length - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, regionName.length - offset - 1);
        byte[][] elements = new byte[][]{tableName, startKey, id};
        return elements;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        if (HRegionInfo.hasEncodedName(this.regionName)) {
            return this.regionNameStr;
        }
        return this.regionNameStr + "." + this.getEncodedName();
    }

    public synchronized String getEncodedName() {
        if (this.encodedName == NO_HASH) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes((String)this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    @Deprecated
    public byte[] getTableName() {
        return this.getTable().toBytes();
    }

    public TableName getTable() {
        if (this.tableName == null || this.tableName.getName().length == 0) {
            this.tableName = HRegionInfo.getTable(this.getRegionName());
        }
        return this.tableName;
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo((byte[])rangeStartKey, (byte[])rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])rangeStartKey) + " > " + Bytes.toStringBinary((byte[])rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo((byte[])rangeStartKey, (byte[])this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo((byte[])rangeEndKey, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo((byte[])row, (byte[])this.startKey) >= 0 && (Bytes.compareTo((byte[])row, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY));
    }

    public boolean isMetaTable() {
        return this.isMetaRegion();
    }

    public boolean isMetaRegion() {
        return this.tableName.equals((Object)FIRST_META_REGIONINFO.getTable());
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
        }
        return true;
    }

    public String toString() {
        return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + this.regionNameStr + "', STARTKEY => '" + Bytes.toStringBinary((byte[])this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary((byte[])this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)o) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Deprecated
    public byte getVersion() {
        return 1;
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.getVersion());
        Bytes.writeByteArray((DataOutput)out, (byte[])this.endKey);
        out.writeBoolean(this.offLine);
        out.writeLong(this.regionId);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.regionName);
        out.writeBoolean(this.split);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.startKey);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.tableName.getName());
        out.writeInt(this.hashCode);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version == 0) {
            this.endKey = Bytes.readByteArray((DataInput)in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray((DataInput)in);
            this.regionNameStr = Bytes.toStringBinary((byte[])this.regionName);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray((DataInput)in);
            try {
                HTableDescriptor htd = new HTableDescriptor();
                htd.readFields(in);
                this.tableName = htd.getTableName();
            }
            catch (EOFException eofe) {
                throw new IOException("HTD not found in input buffer", eofe);
            }
            this.hashCode = in.readInt();
        } else if (this.getVersion() == version) {
            this.endKey = Bytes.readByteArray((DataInput)in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray((DataInput)in);
            this.regionNameStr = Bytes.toStringBinary((byte[])this.regionName);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray((DataInput)in);
            this.tableName = TableName.valueOf((byte[])Bytes.readByteArray((DataInput)in));
            this.hashCode = in.readInt();
        } else {
            throw new IOException("Non-migratable/unknown version=" + this.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void readFields(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(bytes, 0, bytes.length);
            this.readFields((DataInput)in);
        }
        finally {
            in.close();
        }
    }

    @Override
    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = this.tableName.compareTo(o.tableName);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])this.startKey, (byte[])o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])this.endKey, (byte[])o.endKey);
        if (result != 0) {
            if (this.getStartKey().length != 0 && this.getEndKey().length == 0) {
                return 1;
            }
            if (o.getStartKey().length != 0 && o.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (this.regionId > o.regionId) {
            return 1;
        }
        if (this.regionId < o.regionId) {
            return -1;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    public KeyValue.KVComparator getComparator() {
        return this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
    }

    HBaseProtos.RegionInfo convert() {
        return HRegionInfo.convert(this);
    }

    public static HBaseProtos.RegionInfo convert(HRegionInfo info) {
        if (info == null) {
            return null;
        }
        HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(info.getTable()));
        builder.setRegionId(info.getRegionId());
        if (info.getStartKey() != null) {
            builder.setStartKey(ByteString.copyFrom((byte[])info.getStartKey()));
        }
        if (info.getEndKey() != null) {
            builder.setEndKey(ByteString.copyFrom((byte[])info.getEndKey()));
        }
        builder.setOffline(info.isOffline());
        builder.setSplit(info.isSplit());
        return builder.build();
    }

    public static HRegionInfo convert(HBaseProtos.RegionInfo proto) {
        if (proto == null) {
            return null;
        }
        TableName tableName = ProtobufUtil.toTableName(proto.getTableName());
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return FIRST_META_REGIONINFO;
        }
        long regionId = proto.getRegionId();
        byte[] startKey = null;
        byte[] endKey = null;
        if (proto.hasStartKey()) {
            startKey = proto.getStartKey().toByteArray();
        }
        if (proto.hasEndKey()) {
            endKey = proto.getEndKey().toByteArray();
        }
        boolean split = false;
        if (proto.hasSplit()) {
            split = proto.getSplit();
        }
        HRegionInfo hri = new HRegionInfo(tableName, startKey, endKey, split, regionId);
        if (proto.hasOffline()) {
            hri.setOffline(proto.getOffline());
        }
        return hri;
    }

    public byte[] toByteArray() {
        byte[] bytes = this.convert().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static HRegionInfo parseFromOrNull(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        try {
            return HRegionInfo.parseFrom(bytes);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    public static HRegionInfo parseFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                HBaseProtos.RegionInfo ri = ((HBaseProtos.RegionInfo.Builder)HBaseProtos.RegionInfo.newBuilder().mergeFrom(bytes, pblen, bytes.length - pblen)).build();
                return HRegionInfo.convert(ri);
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
        }
        try {
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(bytes);
            return hri;
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    public byte[] toDelimitedByteArray() throws IOException {
        return ProtobufUtil.toDelimitedByteArray((Message)this.convert());
    }

    public static Pair<HRegionInfo, ServerName> getHRegionInfoAndServerName(Result r) {
        HRegionInfo info = HRegionInfo.getHRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
        ServerName sn = HRegionInfo.getServerName(r);
        return new Pair((Object)info, (Object)sn);
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = HRegionInfo.parseFromOrNull(bytes);
        return info;
    }

    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) throws IOException {
        HRegionInfo splitA = HRegionInfo.getHRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        HRegionInfo splitB = HRegionInfo.getHRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType((Object)splitA, (Object)splitB);
    }

    public static HRegionInfo getHRegionInfo(Result r, byte[] qualifier) {
        byte[] bytes = r.getValue(HConstants.CATALOG_FAMILY, qualifier);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(bytes);
    }

    public static ServerName getServerName(Result r) {
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (value == null || value.length == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString((byte[])value);
        value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        if (value == null || value.length == 0) {
            return null;
        }
        return new ServerName(hostAndPort, Bytes.toLong((byte[])value));
    }

    public static long getSeqNumDuringOpen(Result r) {
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER);
        if (value == null || value.length == 0) {
            return -1L;
        }
        Long result = Bytes.toLong((byte[])value);
        if (result == null) {
            return -1L;
        }
        return result;
    }

    public static HRegionInfo parseFrom(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
            return HRegionInfo.convert(HBaseProtos.RegionInfo.parseDelimitedFrom((InputStream)in));
        }
        if (in.markSupported()) {
            in.reset();
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(in);
            return hri;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(pbuf);
        SequenceInputStream sis = new SequenceInputStream(bais, in);
        HRegionInfo hri = new HRegionInfo();
        hri.readFields(new DataInputStream(sis));
        return hri;
    }

    public static byte[] toDelimitedByteArray(HRegionInfo ... infos) throws IOException {
        byte[][] bytes = new byte[infos.length][];
        int size = 0;
        for (int i = 0; i < infos.length; ++i) {
            bytes[i] = infos[i].toDelimitedByteArray();
            size += bytes[i].length;
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HRegionInfo> parseDelimitedFrom(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Can't build an object with empty bytes array");
        }
        DataInputBuffer in = new DataInputBuffer();
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        try {
            in.reset(bytes, offset, length);
            while (in.available() > 0) {
                HRegionInfo hri = HRegionInfo.parseFrom((DataInputStream)in);
                hris.add(hri);
            }
        }
        finally {
            in.close();
        }
        return hris;
    }

    public static boolean areAdjacent(HRegionInfo regionA, HRegionInfo regionB) {
        if (regionA == null || regionB == null) {
            throw new IllegalArgumentException("Can't check whether adjacent for null region");
        }
        HRegionInfo a = regionA;
        HRegionInfo b = regionB;
        if (Bytes.compareTo((byte[])a.getStartKey(), (byte[])b.getStartKey()) > 0) {
            a = regionB;
            b = regionA;
        }
        return Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getStartKey()) == 0;
    }
}

