/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SubstringComparator
extends ByteArrayComparable {
    private String substr;

    public SubstringComparator(String substr) {
        super(Bytes.toBytes((String)substr.toLowerCase()));
        this.substr = substr.toLowerCase();
    }

    @Override
    public byte[] getValue() {
        return Bytes.toBytes((String)this.substr);
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.toString((byte[])value, (int)offset, (int)length).toLowerCase().contains(this.substr) ? 0 : 1;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.SubstringComparator.Builder builder = ComparatorProtos.SubstringComparator.newBuilder();
        builder.setSubstr(this.substr);
        return builder.build().toByteArray();
    }

    public static SubstringComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.SubstringComparator proto;
        try {
            proto = ComparatorProtos.SubstringComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new SubstringComparator(proto.getSubstr());
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubstringComparator)) {
            return false;
        }
        SubstringComparator comparator = (SubstringComparator)other;
        return super.areSerializedFieldsEqual(comparator) && this.substr.equals(comparator.substr);
    }
}

