/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.RpcCallback;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class BlockingRpcCallback<R>
implements RpcCallback<R> {
    private R result;
    private boolean resultSet = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(R parameter) {
        BlockingRpcCallback blockingRpcCallback = this;
        synchronized (blockingRpcCallback) {
            this.result = parameter;
            this.resultSet = true;
            this.notify();
        }
    }

    public synchronized R get() throws IOException {
        while (!this.resultSet) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                InterruptedIOException exception = new InterruptedIOException(ie.getMessage());
                exception.initCause(ie);
                throw exception;
            }
        }
        return this.result;
    }
}

