/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClientSmallScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientSmallReversedScanner
extends ReversedClientScanner {
    private static final Log LOG = LogFactory.getLog(ClientSmallReversedScanner.class);
    private RegionServerCallable<Result[]> smallScanCallable = null;
    private ClientSmallScanner.SmallScannerCallableFactory callableFactory;

    public ClientSmallReversedScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection) throws IOException {
        this(conf, scan, tableName, connection, new ClientSmallScanner.SmallScannerCallableFactory());
    }

    @VisibleForTesting
    ClientSmallReversedScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection, ClientSmallScanner.SmallScannerCallableFactory callableFactory) throws IOException {
        super(conf, scan, tableName, connection);
        this.callableFactory = callableFactory;
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        boolean regionChanged = true;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals((byte[])startKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                return false;
            }
            localStartKey = this.createClosestRowBefore(startKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            regionChanged = false;
            localStartKey = this.createClosestRowBefore(this.lastResult.getRow());
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = this.callableFactory.getCallable(this.scan, this.getConnection(), this.getTable(), this.scanMetrics, localStartKey, cacheNum, this.rpcControllerFactory);
        if (this.scanMetrics != null && regionChanged) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    protected void loadCache() throws IOException {
        Result[] values = null;
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        boolean currentRegionDone = false;
        while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
            values = this.caller.callWithRetries(this.smallScanCallable, this.scannerTimeout);
            this.currentRegion = this.smallScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    this.cache.add(rs);
                    for (Cell kv : rs.rawCells()) {
                        remainingResultSize -= KeyValueUtil.ensureKeyValue((Cell)kv).heapSize();
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            }
            if (this.smallScanCallable.hasMoreResultsContext()) {
                currentRegionDone = !this.smallScanCallable.getServerHasMoreResults();
                continue;
            }
            currentRegionDone = countdown > 0;
        }
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    @VisibleForTesting
    protected void setScannerCallableFactory(ClientSmallScanner.SmallScannerCallableFactory callableFactory) {
        this.callableFactory = callableFactory;
    }

    @VisibleForTesting
    protected void setRpcRetryingCaller(RpcRetryingCaller<Result[]> caller) {
        this.caller = caller;
    }

    @VisibleForTesting
    protected void setRpcControllerFactory(RpcControllerFactory rpcControllerFactory) {
        this.rpcControllerFactory = rpcControllerFactory;
    }
}

