/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class TableConfiguration {
    private final long writeBufferSize;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int retries;
    private final int maxKeyValueSize;

    TableConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", 100);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxKeyValueSize = conf.getInt("hbase.client.keyvalue.maxsize", -1);
    }

    @VisibleForTesting
    protected TableConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = 100;
        this.scannerMaxResultSize = 0x200000L;
        this.retries = 31;
        this.maxKeyValueSize = -1;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }
}

