/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.ZooKeeperRegistry;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HConnectionManager {
    static final Log LOG = LogFactory.getLog(HConnectionManager.class);
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    private static final String CLIENT_NONCES_ENABLED_KEY = "hbase.client.nonces.enabled";
    static final Map<HConnectionKey, HConnectionImplementation> CONNECTION_INSTANCES;
    public static final int MAX_CACHED_CONNECTION_INSTANCES;
    private static volatile NonceGenerator nonceGenerator;
    private static Object nonceGeneratorCreateLock;

    private HConnectionManager() {
    }

    @VisibleForTesting
    public static NonceGenerator injectNonceGeneratorForTesting(HConnection conn, NonceGenerator cnm) {
        NonceGenerator ng = conn.getNonceGenerator();
        LOG.warn((Object)("Nonce generator is being replaced by test code for " + cnm.getClass().getName()));
        ((HConnectionImplementation)conn).nonceGenerator = cnm;
        return ng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static HConnection getConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionImplementation)HConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                HConnectionManager.deleteConnection(connectionKey, true);
                connection = (HConnectionImplementation)HConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return HConnectionManager.createConnection(conf, false, null, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return HConnectionManager.createConnection(conf, false, pool, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, User user) throws IOException {
        return HConnectionManager.createConnection(conf, false, null, user);
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        return HConnectionManager.createConnection(conf, false, pool, user);
    }

    @Deprecated
    static HConnection createConnection(Configuration conf, boolean managed) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return HConnectionManager.createConnection(conf, managed, null, provider.getCurrent());
    }

    @Deprecated
    static HConnection createConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        String className = conf.get("hbase.client.connection.impl", HConnectionImplementation.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE, ExecutorService.class, User.class);
            constructor.setAccessible(true);
            return (HConnection)constructor.newInstance(conf, managed, pool, user);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void deleteConnection(Configuration conf) {
        HConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    public static void deleteStaleConnection(HConnection connection) {
        HConnectionManager.deleteConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections(boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(CONNECTION_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                HConnectionManager.deleteConnection(connectionKey, staleConnection);
            }
            CONNECTION_INSTANCES.clear();
        }
    }

    @Deprecated
    public static void deleteAllConnections() {
        HConnectionManager.deleteAllConnections(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> e : CONNECTION_INSTANCES.entrySet()) {
                if (e.getValue() != connection) continue;
                HConnectionManager.deleteConnection(e.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    CONNECTION_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"), (Throwable)new Exception());
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final TableName tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = HConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    public static Throwable findException(Object exception) {
        if (exception == null || !(exception instanceof Throwable)) {
            return null;
        }
        Throwable cur = (Throwable)exception;
        while (cur != null) {
            if (cur instanceof RegionMovedException || cur instanceof RegionOpeningException || cur instanceof RegionTooBusyException) {
                return cur;
            }
            if (cur instanceof RemoteException) {
                RemoteException re = (RemoteException)cur;
                if ((cur = re.unwrapRemoteException(new Class[]{RegionOpeningException.class, RegionMovedException.class, RegionTooBusyException.class})) == null) {
                    cur = re.unwrapRemoteException();
                }
                if (cur != re) continue;
                return null;
            }
            cur = cur.getCause();
        }
        return null;
    }

    public static void setServerSideHConnectionRetries(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, retries);
        log.debug((Object)(sn + " HConnection server-to-server retries=" + retries));
    }

    static {
        nonceGenerator = null;
        nonceGeneratorCreateLock = new Object();
        MAX_CACHED_CONNECTION_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        CONNECTION_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_CONNECTION_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_CONNECTION_INSTANCES;
            }
        };
    }

    static class ServerErrorTracker {
        private final ConcurrentMap<HRegionLocation, ServerErrors> errorsByServer = new ConcurrentHashMap<HRegionLocation, ServerErrors>();
        private final long canRetryUntil;
        private final int maxRetries;
        private final String startTrackingTime;

        public ServerErrorTracker(long timeout, int maxRetries) {
            this.maxRetries = maxRetries;
            this.canRetryUntil = EnvironmentEdgeManager.currentTimeMillis() + timeout;
            this.startTrackingTime = new Date().toString();
        }

        boolean canRetryMore(int numRetry) {
            return numRetry < this.maxRetries || this.maxRetries > 1 && EnvironmentEdgeManager.currentTimeMillis() < this.canRetryUntil;
        }

        long calculateBackoffTime(HRegionLocation server, long basePause) {
            ServerErrors errorStats = (ServerErrors)this.errorsByServer.get(server);
            long result = errorStats != null ? ConnectionUtils.getPauseTime(basePause, errorStats.retries.get()) : 0L;
            return result;
        }

        void reportServerError(HRegionLocation server) {
            ServerErrors errors = (ServerErrors)this.errorsByServer.get(server);
            if (errors != null) {
                errors.addError();
            } else {
                errors = this.errorsByServer.putIfAbsent(server, new ServerErrors());
                if (errors != null) {
                    errors.addError();
                }
            }
        }

        String getStartTrackingTime() {
            return this.startTrackingTime;
        }

        private static class ServerErrors {
            public final AtomicInteger retries = new AtomicInteger(0);

            private ServerErrors() {
            }

            public void addError() {
                this.retries.incrementAndGet();
            }
        }
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
    public static class HConnectionImplementation
    implements HConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final long pause;
        private final int numTries;
        final int rpcTimeout;
        private NonceGenerator nonceGenerator = null;
        private final boolean usePrefetch;
        private final int prefetchRegionLimit;
        private volatile boolean closed;
        private volatile boolean aborted;
        ClusterStatusListener clusterStatusListener;
        private final Object userRegionLock = new Object();
        private final Object masterAndZKLock = new Object();
        private long keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
        private final DelayedClosing delayedClosing = DelayedClosing.createAndStart(this);
        private volatile ExecutorService batchPool = null;
        private volatile boolean cleanupPool = false;
        private final Configuration conf;
        private RpcClient rpcClient;
        private final ConcurrentMap<TableName, ConcurrentSkipListMap<byte[], HRegionLocation>> cachedRegionLocations = new ConcurrentHashMap<TableName, ConcurrentSkipListMap<byte[], HRegionLocation>>();
        private final Set<ServerName> cachedServers = new ConcurrentSkipListSet<ServerName>();
        private final Set<Integer> regionCachePrefetchDisabledTables = new CopyOnWriteArraySet<Integer>();
        private int refCount;
        private boolean managed;
        private User user;
        Registry registry;
        protected String clusterId = null;
        private final ConcurrentHashMap<String, Object> stubs = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private ZooKeeperKeepAliveConnection keepAliveZookeeper;
        private AtomicInteger keepAliveZookeeperUserCount = new AtomicInteger(0);
        private boolean canCloseZKW = true;
        private static final long keepAlive = 300000L;
        final MasterServiceState masterServiceState = new MasterServiceState(this);

        HConnectionImplementation(Configuration conf, boolean managed) throws IOException {
            this(conf, managed, null, null);
        }

        HConnectionImplementation(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            this(conf);
            this.user = user;
            this.batchPool = pool;
            this.managed = managed;
            this.registry = this.setupRegistry();
            this.retrieveClusterId();
            this.rpcClient = new RpcClient(this.conf, this.clusterId);
            boolean shouldListen = conf.getBoolean("hbase.status.published", false);
            Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (shouldListen) {
                if (listenerClass == null) {
                    LOG.warn((Object)"hbase.status.published is true, but hbase.status.listener.class is not set - not listening status");
                } else {
                    this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            HConnectionImplementation.this.clearCaches(sn);
                            HConnectionImplementation.this.rpcClient.cancelConnections(sn.getHostname(), sn.getPort(), new SocketException(sn.getServerName() + " is dead: closing its connection."));
                        }
                    }, conf, listenerClass);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HConnectionImplementation(Configuration conf) {
            this.conf = conf;
            this.closed = false;
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numTries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            if (conf.getBoolean(HConnectionManager.CLIENT_NONCES_ENABLED_KEY, true)) {
                Object object = nonceGeneratorCreateLock;
                synchronized (object) {
                    if (nonceGenerator == null) {
                        nonceGenerator = new PerClientRandomNonceGenerator();
                    }
                    this.nonceGenerator = nonceGenerator;
                }
            } else {
                this.nonceGenerator = new NoNonceGenerator();
            }
            this.usePrefetch = conf.getBoolean(HConstants.HBASE_CLIENT_PREFETCH, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
        }

        @Override
        public HTableInterface getTable(String tableName) throws IOException {
            return this.getTable(TableName.valueOf((String)tableName));
        }

        @Override
        public HTableInterface getTable(byte[] tableName) throws IOException {
            return this.getTable(TableName.valueOf((byte[])tableName));
        }

        @Override
        public HTableInterface getTable(TableName tableName) throws IOException {
            return this.getTable(tableName, this.getBatchPool());
        }

        @Override
        public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf((String)tableName), pool);
        }

        @Override
        public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf((byte[])tableName), pool);
        }

        @Override
        public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
            if (this.managed) {
                throw new IOException("The connection has to be unmanaged.");
            }
            return new HTable(tableName, (HConnection)this, pool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExecutorService getBatchPool() {
            if (this.batchPool == null) {
                HConnectionImplementation hConnectionImplementation = this;
                synchronized (hConnectionImplementation) {
                    if (this.batchPool == null) {
                        int maxThreads = this.conf.getInt("hbase.hconnection.threads.max", 256);
                        int coreThreads = this.conf.getInt("hbase.hconnection.threads.core", 256);
                        if (maxThreads == 0) {
                            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
                        }
                        if (coreThreads == 0) {
                            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
                        }
                        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
                        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
                        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(this.toString() + "-shared-")));
                        tpe.allowCoreThreadTimeOut(true);
                        this.batchPool = tpe;
                    }
                    this.cleanupPool = true;
                }
            }
            return this.batchPool;
        }

        protected ExecutorService getCurrentBatchPool() {
            return this.batchPool;
        }

        private void shutdownBatchPool() {
            if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
                this.batchPool.shutdown();
                try {
                    if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.batchPool.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.batchPool.shutdownNow();
                }
            }
        }

        private Registry setupRegistry() throws IOException {
            String registryClass = this.conf.get("hbase.client.registry.impl", ZooKeeperRegistry.class.getName());
            Registry registry = null;
            try {
                registry = (Registry)Class.forName(registryClass).newInstance();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            registry.init(this);
            return registry;
        }

        RpcClient setRpcClient(RpcClient rpcClient) {
            RpcClient oldRpcClient = this.rpcClient;
            this.rpcClient = rpcClient;
            return oldRpcClient;
        }

        public String toString() {
            return "hconnection-0x" + Integer.toHexString(this.hashCode());
        }

        void retrieveClusterId() {
            if (this.clusterId != null) {
                return;
            }
            this.clusterId = this.registry.getClusterId();
            if (this.clusterId == null) {
                this.clusterId = "default-cluster";
                LOG.debug((Object)("clusterid came back null, using default " + this.clusterId));
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
            try {
                if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                    String errorMsg = "The node " + zkw.baseZNode + " is not in ZooKeeper. " + "It should have been written by the master. " + "Check the value configured in 'zookeeper.znode.parent'. " + "There could be a mismatch with the one configured in the master.";
                    LOG.error((Object)errorMsg);
                    throw new MasterNotRunningException(errorMsg);
                }
            }
            catch (KeeperException e) {
                String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
            }
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            MasterKeepAliveConnection m = this.getKeepAliveMasterService();
            m.close();
            return true;
        }

        @Override
        public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(tableName, row) : this.locateRegion(tableName, row);
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
            return this.getRegionLocation(TableName.valueOf((byte[])tableName), row, reload);
        }

        @Override
        public boolean isTableEnabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.isTableEnabled(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.isTableDisabled(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals((Object)info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            regionCount.incrementAndGet();
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, this, visitor, tableName);
            return available.get() && regionCount.get() > 0;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName) throws IOException {
            return this.isTableAvailable(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName, final byte[][] splitKeys) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals((Object)info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            if (!Bytes.equals((byte[])info.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                                for (byte[] splitKey : splitKeys) {
                                    if (!Bytes.equals((byte[])info.getStartKey(), (byte[])splitKey)) continue;
                                    regionCount.incrementAndGet();
                                    break;
                                }
                            } else {
                                regionCount.incrementAndGet();
                            }
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, this, visitor, tableName);
            return available.get() && regionCount.get() == splitKeys.length + 1;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
            return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            return this.locateRegion(HRegionInfo.getTable(regionName), HRegionInfo.getStartKey(regionName), false, true);
        }

        @Override
        public boolean isDeadServer(ServerName sn) {
            if (this.clusterStatusListener == null) {
                return false;
            }
            return this.clusterStatusListener.isDeadServer(sn);
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
            return this.locateRegions(tableName, false, true);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return this.locateRegions(TableName.valueOf((byte[])tableName));
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.conf, this, tableName, offlined);
            ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
            for (HRegionInfo regionInfo : regions.keySet()) {
                locations.add(this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true));
            }
            return locations;
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
            return this.locateRegions(TableName.valueOf((byte[])tableName), useCache, offlined);
        }

        @Override
        public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true, true);
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(TableName.valueOf((byte[])tableName), row);
        }

        @Override
        public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
            if (this.isTableDisabled(tableName)) {
                throw new TableNotEnabledException(tableName.getNameAsString() + " is disabled.");
            }
            return this.locateRegion(tableName, row, false, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.relocateRegion(TableName.valueOf((byte[])tableName), row);
        }

        private HRegionLocation locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.getName().length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                return this.registry.getMetaRegionLocation();
            }
            return this.locateRegionInMeta(TableName.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock, retry);
        }

        private void prefetchRegionCache(final TableName tableName, byte[] row) {
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                        if (regionInfo == null) {
                            return true;
                        }
                        if (!regionInfo.getTable().equals((Object)tableName)) {
                            return false;
                        }
                        if (regionInfo.isOffline()) {
                            return true;
                        }
                        ServerName serverName = HRegionInfo.getServerName(result);
                        if (serverName == null) {
                            return true;
                        }
                        long seqNum = HRegionInfo.getSeqNumDuringOpen(result);
                        HRegionLocation loc = new HRegionLocation(regionInfo, serverName, seqNum);
                        HConnectionImplementation.this.cacheLocation(tableName, null, loc);
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, this, visitor, tableName, row, this.prefetchRegionLimit, TableName.META_TABLE_NAME);
            }
            catch (IOException e) {
                if (ExceptionUtil.isInterrupt((Throwable)e)) {
                    Thread.currentThread().interrupt();
                }
                LOG.warn((Object)"Encountered problems when prefetch hbase:meta table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegionInMeta(TableName parentTable, TableName tableName, byte[] row, boolean useCache, Object regionLockObject, boolean retry) throws IOException {
            HRegionLocation location;
            if (useCache && (location = this.getCachedLocation(tableName, row)) != null) {
                return location;
            }
            int localNumRetries = retry ? this.numTries : 1;
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block28: {
                    if (tries >= localNumRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary((byte[])row) + " after " + this.numTries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        Result regionInfoRow;
                        metaLocation = this.locateRegion(parentTable, metaKey, true, false);
                        if (metaLocation == null) break block28;
                        ClientProtos.ClientService.BlockingInterface service = this.getClient(metaLocation.getServerName());
                        if (useCache) {
                            if (TableName.META_TABLE_NAME.equals((Object)parentTable) && this.usePrefetch && this.getRegionCachePrefetch(tableName)) {
                                Object object = regionLockObject;
                                synchronized (object) {
                                    location = this.getCachedLocation(tableName, row);
                                    if (location != null) {
                                        return location;
                                    }
                                    this.prefetchRegionCache(tableName, row);
                                }
                            }
                            if ((location = this.getCachedLocation(tableName, row)) != null) {
                                return location;
                            }
                        } else {
                            this.forceDeleteCachedLocation(tableName, row);
                        }
                        if ((regionInfoRow = ProtobufUtil.getRowOrBefore(service, metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY)) == null) {
                            throw new TableNotFoundException(tableName);
                        }
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(regionInfoRow);
                        if (regionInfo == null) {
                            throw new IOException("HRegionInfo was null or empty in " + parentTable + ", row=" + regionInfoRow);
                        }
                        if (!regionInfo.getTable().equals((Object)tableName)) {
                            throw new TableNotFoundException("Table '" + tableName + "' was not found, got: " + regionInfo.getTable() + ".");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        ServerName serverName = HRegionInfo.getServerName(regionInfoRow);
                        if (serverName == null) {
                            throw new NoServerForRegionException("No server address listed in " + parentTable + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary((byte[])row));
                        }
                        if (this.isDeadServer(serverName)) {
                            throw new RegionServerStoppedException("hbase:meta says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                        }
                        location = new HRegionLocation(regionInfo, serverName, HRegionInfo.getSeqNumDuringOpen(regionInfoRow));
                        this.cacheLocation(tableName, null, location);
                        return location;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                        if (e instanceof RemoteException) {
                            e = ((RemoteException)e).unwrapRemoteException();
                        }
                        if (tries < this.numTries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + parentTable + ", metaLocation=" + (metaLocation == null ? "null" : "{" + metaLocation + "}") + ", attempt=" + tries + " of " + this.numTries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            throw new InterruptedIOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        HRegionLocation getCachedLocation(TableName tableName, byte[] row) {
            ConcurrentSkipListMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            Map.Entry<byte[], HRegionLocation> e = tableLocations.floorEntry(row);
            if (e == null) {
                return null;
            }
            HRegionLocation possibleRegion = e.getValue();
            byte[] endKey = possibleRegion.getRegionInfo().getEndKey();
            if (Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW) || tableName.getRowComparator().compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0) {
                return possibleRegion;
            }
            return null;
        }

        void forceDeleteCachedLocation(TableName tableName, byte[] row) {
            HRegionLocation rl = null;
            ConcurrentSkipListMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            rl = this.getCachedLocation(tableName, row);
            if (rl != null) {
                tableLocations.remove(rl.getRegionInfo().getStartKey());
            }
            if (rl != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed " + rl.getHostname() + ":" + rl.getPort() + " as a location of " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + tableName + " from cache"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearCaches(ServerName serverName) {
            if (!this.cachedServers.contains(serverName)) {
                return;
            }
            boolean deletedSomething = false;
            Set<ServerName> set = this.cachedServers;
            synchronized (set) {
                if (!this.cachedServers.contains(serverName)) {
                    return;
                }
                for (Map tableLocations : this.cachedRegionLocations.values()) {
                    for (Map.Entry e : tableLocations.entrySet()) {
                        HRegionLocation value = (HRegionLocation)e.getValue();
                        if (value == null || !serverName.equals(value.getServerName())) continue;
                        tableLocations.remove(e.getKey());
                        deletedSomething = true;
                    }
                }
                this.cachedServers.remove(serverName);
            }
            if (deletedSomething && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed all cached region locations that map to " + serverName));
            }
        }

        private ConcurrentSkipListMap<byte[], HRegionLocation> getTableLocations(TableName tableName) {
            ConcurrentSkipListMap<byte[], HRegionLocation> old;
            ConcurrentSkipListMap result = (ConcurrentSkipListMap)this.cachedRegionLocations.get(tableName);
            if (result == null && (old = this.cachedRegionLocations.putIfAbsent(tableName, result = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR))) != null) {
                return old;
            }
            return result;
        }

        @Override
        public void clearRegionCache() {
            this.cachedRegionLocations.clear();
            this.cachedServers.clear();
        }

        @Override
        public void clearRegionCache(TableName tableName) {
            this.cachedRegionLocations.remove(tableName);
        }

        @Override
        public void clearRegionCache(byte[] tableName) {
            this.clearRegionCache(TableName.valueOf((byte[])tableName));
        }

        private void cacheLocation(TableName tableName, HRegionLocation source, HRegionLocation location) {
            boolean updateCache;
            boolean isNewCacheEntry;
            boolean isFromMeta = source == null;
            byte[] startKey = location.getRegionInfo().getStartKey();
            ConcurrentSkipListMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            HRegionLocation oldLocation = tableLocations.putIfAbsent(startKey, location);
            boolean bl = isNewCacheEntry = oldLocation == null;
            if (isNewCacheEntry) {
                this.cachedServers.add(location.getServerName());
                return;
            }
            if (oldLocation.equals(source)) {
                updateCache = true;
            } else {
                long newLocationSeqNum = location.getSeqNum();
                boolean isStaleMetaRecord = isFromMeta && oldLocation.getSeqNum() > newLocationSeqNum;
                boolean isStaleRedirect = !isFromMeta && oldLocation.getSeqNum() >= newLocationSeqNum;
                boolean isStaleUpdate = isStaleMetaRecord || isStaleRedirect;
                boolean bl2 = updateCache = !isStaleUpdate;
            }
            if (updateCache) {
                tableLocations.replace(startKey, oldLocation, location);
                this.cachedServers.add(location.getServerName());
            }
        }

        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
            return this.getAdmin(serverName, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean master) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException(serverName + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            AdminProtos.AdminService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (AdminProtos.AdminService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
                    stub = AdminProtos.AdminService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            if (this.isDeadServer(sn)) {
                throw new RegionServerStoppedException(sn + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), sn.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            ClientProtos.ClientService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (ClientProtos.ClientService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, this.user, this.rpcTimeout);
                    stub = ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        static String getStubKey(String serviceName, String rsHostnamePort) {
            return serviceName + "@" + rsHostnamePort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper == null) {
                    if (this.closed) {
                        throw new IOException(this.toString() + " closed");
                    }
                    this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
                }
                this.keepAliveZookeeperUserCount.incrementAndGet();
                this.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                return this.keepAliveZookeeper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
            if (zkw == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeperUserCount.decrementAndGet() <= 0) {
                    this.keepZooKeeperWatcherAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeZooKeeperWatcher() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                    this.keepAliveZookeeper.internalClose();
                    this.keepAliveZookeeper = null;
                }
                this.keepAliveZookeeperUserCount.set(0);
            }
        }

        @Override
        public MasterProtos.MasterService.BlockingInterface getMaster() throws MasterNotRunningException {
            return this.getKeepAliveMasterService();
        }

        private void resetMasterServiceState(MasterServiceState mss) {
            ++mss.userCount;
            mss.keepAliveUntil = Long.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(this.masterServiceState)) {
                    MasterServiceStubMaker stubMaker = new MasterServiceStubMaker();
                    this.masterServiceState.stub = stubMaker.makeStub();
                }
                this.resetMasterServiceState(this.masterServiceState);
            }
            final MasterProtos.MasterService.BlockingInterface stub = this.masterServiceState.stub;
            return new MasterKeepAliveConnection(){
                MasterServiceState mss;
                {
                    this.mss = HConnectionImplementation.this.masterServiceState;
                }

                public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest request) throws ServiceException {
                    return stub.addColumn(controller, request);
                }

                public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest request) throws ServiceException {
                    return stub.deleteColumn(controller, request);
                }

                public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest request) throws ServiceException {
                    return stub.modifyColumn(controller, request);
                }

                public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest request) throws ServiceException {
                    return stub.moveRegion(controller, request);
                }

                public MasterProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController controller, MasterProtos.DispatchMergingRegionsRequest request) throws ServiceException {
                    return stub.dispatchMergingRegions(controller, request);
                }

                public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest request) throws ServiceException {
                    return stub.assignRegion(controller, request);
                }

                public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest request) throws ServiceException {
                    return stub.unassignRegion(controller, request);
                }

                public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
                    return stub.offlineRegion(controller, request);
                }

                public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
                    return stub.deleteTable(controller, request);
                }

                public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
                    return stub.enableTable(controller, request);
                }

                public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
                    return stub.disableTable(controller, request);
                }

                public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest request) throws ServiceException {
                    return stub.modifyTable(controller, request);
                }

                public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest request) throws ServiceException {
                    return stub.createTable(controller, request);
                }

                public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
                    return stub.shutdown(controller, request);
                }

                public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
                    return stub.stopMaster(controller, request);
                }

                public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
                    return stub.balance(controller, request);
                }

                public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest request) throws ServiceException {
                    return stub.setBalancerRunning(controller, request);
                }

                public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController controller, MasterProtos.RunCatalogScanRequest request) throws ServiceException {
                    return stub.runCatalogScan(controller, request);
                }

                public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                    return stub.enableCatalogJanitor(controller, request);
                }

                public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                    return stub.isCatalogJanitorEnabled(controller, request);
                }

                public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                    return stub.execMasterService(controller, request);
                }

                public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
                    return stub.snapshot(controller, request);
                }

                public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
                    return stub.getCompletedSnapshots(controller, request);
                }

                public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
                    return stub.deleteSnapshot(controller, request);
                }

                public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
                    return stub.isSnapshotDone(controller, request);
                }

                public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
                    return stub.restoreSnapshot(controller, request);
                }

                public MasterProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
                    return stub.isRestoreSnapshotDone(controller, request);
                }

                public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                    return stub.execProcedure(controller, request);
                }

                public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
                    return stub.isProcedureDone(controller, request);
                }

                public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                    return stub.isMasterRunning(controller, request);
                }

                public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
                    return stub.modifyNamespace(controller, request);
                }

                public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
                    return stub.createNamespace(controller, request);
                }

                public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
                    return stub.deleteNamespace(controller, request);
                }

                public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
                    return stub.getNamespaceDescriptor(controller, request);
                }

                public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
                    return stub.listNamespaceDescriptors(controller, request);
                }

                public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
                    return stub.listTableDescriptorsByNamespace(controller, request);
                }

                public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
                    return stub.listTableNamesByNamespace(controller, request);
                }

                @Override
                public void close() {
                    HConnectionImplementation.release(this.mss);
                }

                public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                    return stub.getSchemaAlterStatus(controller, request);
                }

                public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest request) throws ServiceException {
                    return stub.getTableDescriptors(controller, request);
                }

                public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest request) throws ServiceException {
                    return stub.getTableNames(controller, request);
                }

                public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest request) throws ServiceException {
                    return stub.getClusterStatus(controller, request);
                }
            };
        }

        private static void release(MasterServiceState mss) {
            if (mss != null && mss.connection != null) {
                ((HConnectionImplementation)mss.connection).releaseMaster(mss);
            }
        }

        private boolean isKeepAliveMasterConnectedAndRunning(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return false;
            }
            try {
                return mss.isMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (ServiceException se) {
                LOG.warn((Object)"Checking master connection", (Throwable)se);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMaster(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --mss.userCount;
                if (mss.userCount <= 0) {
                    mss.keepAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        private void closeMasterService(MasterServiceState mss) {
            if (mss.getStub() != null) {
                LOG.info((Object)("Closing master protocol: " + mss));
                mss.clearStub();
            }
            mss.userCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeMaster() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                this.closeMasterService(this.masterServiceState);
            }
        }

        void updateCachedLocation(HRegionInfo hri, HRegionLocation source, ServerName serverName, long seqNum) {
            HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
            this.cacheLocation(hri.getTable(), source, newHrl);
        }

        void deleteCachedLocation(HRegionInfo hri, HRegionLocation source) {
            ConcurrentSkipListMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(hri.getTable());
            tableLocations.remove(hri.getStartKey(), source);
        }

        @Override
        public void deleteCachedRegionLocation(HRegionLocation location) {
            if (location == null) {
                return;
            }
            TableName tableName = location.getRegionInfo().getTable();
            ConcurrentSkipListMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            HRegionLocation removedLocation = (HRegionLocation)tableLocations.remove(location.getRegionInfo().getStartKey());
            if (LOG.isDebugEnabled() && removedLocation != null) {
                LOG.debug((Object)("Removed " + location.getRegionInfo().getRegionNameAsString() + " for tableName=" + tableName + " from cache"));
            }
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            if (rowkey == null || tableName == null) {
                LOG.warn((Object)("Coding error, see method javadoc. row=" + (rowkey == null ? "null" : (Object)rowkey) + ", tableName=" + (tableName == null ? "null" : tableName)));
                return;
            }
            if (source == null || source.getServerName() == null) {
                return;
            }
            HRegionLocation oldLocation = this.getCachedLocation(tableName, rowkey);
            if (oldLocation == null || !source.getServerName().equals(oldLocation.getServerName())) {
                return;
            }
            HRegionInfo regionInfo = oldLocation.getRegionInfo();
            Throwable cause = HConnectionManager.findException(exception);
            if (cause != null) {
                if (cause instanceof RegionTooBusyException || cause instanceof RegionOpeningException) {
                    return;
                }
                if (cause instanceof RegionMovedException) {
                    RegionMovedException rme = (RegionMovedException)cause;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostnamePort()));
                    }
                    this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
                    return;
                }
            }
            this.deleteCachedLocation(regionInfo, source);
        }

        @Override
        public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            this.updateCachedLocations(TableName.valueOf((byte[])tableName), rowkey, exception, source);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            this.processBatch(list, TableName.valueOf((byte[])tableName), pool, results);
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            ObjectResultFiller<R> cb = new ObjectResultFiller<R>(results, callback);
            AsyncProcess asyncProcess = this.createAsyncProcess(tableName, pool, cb, this.conf);
            asyncProcess.submitAll(list);
            asyncProcess.waitUntilDone();
            if (asyncProcess.hasError()) {
                throw asyncProcess.getErrors();
            }
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.processBatchCallback(list, TableName.valueOf((byte[])tableName), pool, results, callback);
        }

        protected <R> AsyncProcess createAsyncProcess(TableName tableName, ExecutorService pool, AsyncProcess.AsyncProcessCallback<R> callback, Configuration conf) {
            return new AsyncProcess<R>(this, tableName, pool, callback, conf, RpcRetryingCallerFactory.instantiate(conf), RpcControllerFactory.instantiate(conf));
        }

        int getNumberOfCachedRegionLocations(TableName tableName) {
            Map tableLocs = (Map)this.cachedRegionLocations.get(tableName);
            if (tableLocs == null) {
                return 0;
            }
            return tableLocs.values().size();
        }

        boolean isRegionCached(TableName tableName, byte[] row) {
            HRegionLocation location = this.getCachedLocation(tableName, row);
            return location != null;
        }

        @Override
        public void setRegionCachePrefetch(TableName tableName, boolean enable) {
            if (!enable) {
                this.regionCachePrefetchDisabledTables.add(Bytes.mapKey((byte[])tableName.getName()));
            } else {
                this.regionCachePrefetchDisabledTables.remove(Bytes.mapKey((byte[])tableName.getName()));
            }
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            this.setRegionCachePrefetch(TableName.valueOf((byte[])tableName), enable);
        }

        @Override
        public boolean getRegionCachePrefetch(TableName tableName) {
            return this.usePrefetch && !this.regionCachePrefetchDisabledTables.contains(Bytes.mapKey((byte[])tableName.getName()));
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return this.getRegionCachePrefetch(TableName.valueOf((byte[])tableName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
                Object object = this.masterAndZKLock;
                synchronized (object) {
                    if (this.keepAliveZookeeper != null) {
                        LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                        this.closeZooKeeperWatcher();
                    }
                }
            } else {
                if (t != null) {
                    LOG.fatal((Object)msg, t);
                } else {
                    LOG.fatal((Object)msg);
                }
                this.aborted = true;
                this.close();
                this.closed = true;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            return this.registry.getCurrentNrHRS();
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.delayedClosing.stop("Closing connection");
            this.closeMaster();
            this.shutdownBatchPool();
            this.closed = true;
            this.closeZooKeeperWatcher();
            this.stubs.clear();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
            if (this.rpcClient != null) {
                this.rpcClient.stop();
            }
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    HConnectionManager.deleteStaleConnection(this);
                } else {
                    HConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.refCount = 1;
            this.close();
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest((List<TableName>)null);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public String[] getTableNames() throws IOException {
            TableName[] tableNames = this.listTableNames();
            String[] result = new String[tableNames.length];
            for (int i = 0; i < tableNames.length; ++i) {
                result[i] = tableNames[i].getNameAsString();
            }
            return result;
        }

        @Override
        public TableName[] listTableNames() throws IOException {
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                TableName[] tableNameArray = ProtobufUtil.getTableNameArray(master.getTableNames(null, MasterProtos.GetTableNamesRequest.newBuilder().build()).getTableNamesList());
                return tableNameArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptors(List<String> names) throws IOException {
            ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
            for (String name : names) {
                tableNames.add(TableName.valueOf((String)name));
            }
            return this.getHTableDescriptorsByTableName(tableNames);
        }

        @Override
        public NonceGenerator getNonceGenerator() {
            return this.nonceGenerator;
        }

        @Override
        public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
            MasterProtos.GetTableDescriptorsResponse htds;
            if (tableName == null) {
                return null;
            }
            if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                htds = master.getTableDescriptors(null, req);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
            if (!htds.getTableSchemaList().isEmpty()) {
                return HTableDescriptor.convert((HBaseProtos.TableSchema)htds.getTableSchemaList().get(0));
            }
            throw new TableNotFoundException(tableName.getNameAsString());
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            return this.getHTableDescriptor(TableName.valueOf((byte[])tableName));
        }

        private static class ObjectResultFiller<Res>
        implements AsyncProcess.AsyncProcessCallback<Res> {
            private final Object[] results;
            private Batch.Callback<Res> callback;

            ObjectResultFiller(Object[] results, Batch.Callback<Res> callback) {
                this.results = results;
                this.callback = callback;
            }

            @Override
            public void success(int pos, byte[] region, Row row, Res result) {
                assert (pos < this.results.length);
                this.results[pos] = result;
                if (this.callback != null) {
                    this.callback.update(region, row.getRow(), result);
                }
            }

            @Override
            public boolean failure(int pos, byte[] region, Row row, Throwable t) {
                assert (pos < this.results.length);
                this.results[pos] = t;
                return true;
            }

            @Override
            public boolean retriableFailure(int originalIndex, Row row, byte[] region, Throwable exception) {
                return true;
            }
        }

        private static class DelayedClosing
        extends Chore
        implements Stoppable {
            private HConnectionImplementation hci;
            Stoppable stoppable;

            private DelayedClosing(HConnectionImplementation hci, Stoppable stoppable) {
                super("ZooKeeperWatcher and Master delayed closing for connection " + hci, 60000, stoppable);
                this.hci = hci;
                this.stoppable = stoppable;
            }

            static DelayedClosing createAndStart(HConnectionImplementation hci) {
                Stoppable stoppable = new Stoppable(){
                    private volatile boolean isStopped = false;

                    @Override
                    public void stop(String why) {
                        this.isStopped = true;
                    }

                    @Override
                    public boolean isStopped() {
                        return this.isStopped;
                    }
                };
                return new DelayedClosing(hci, stoppable);
            }

            protected void closeMasterProtocol(MasterServiceState protocolState) {
                if (System.currentTimeMillis() > protocolState.keepAliveUntil) {
                    this.hci.closeMasterService(protocolState);
                    protocolState.keepAliveUntil = Long.MAX_VALUE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void chore() {
                Object object = this.hci.masterAndZKLock;
                synchronized (object) {
                    if (this.hci.canCloseZKW && System.currentTimeMillis() > this.hci.keepZooKeeperWatcherAliveUntil) {
                        this.hci.closeZooKeeperWatcher();
                        this.hci.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                    }
                    this.closeMasterProtocol(this.hci.masterServiceState);
                    this.closeMasterProtocol(this.hci.masterServiceState);
                }
            }

            @Override
            public void stop(String why) {
                this.stoppable.stop(why);
            }

            @Override
            public boolean isStopped() {
                return this.stoppable.isStopped();
            }
        }

        class MasterServiceStubMaker
        extends StubMaker {
            private MasterProtos.MasterService.BlockingInterface stub;

            MasterServiceStubMaker() {
            }

            @Override
            protected String getServiceName() {
                return MasterProtos.MasterService.getDescriptor().getName();
            }

            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            MasterProtos.MasterService.BlockingInterface makeStub() throws MasterNotRunningException {
                return (MasterProtos.MasterService.BlockingInterface)super.makeStub();
            }

            @Override
            protected Object makeStub(BlockingRpcChannel channel) {
                this.stub = MasterProtos.MasterService.newBlockingStub((BlockingRpcChannel)channel);
                return this.stub;
            }

            @Override
            protected void isMasterRunning() throws ServiceException {
                this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
        }

        abstract class StubMaker {
            StubMaker() {
            }

            protected abstract String getServiceName();

            protected abstract Object makeStub(BlockingRpcChannel var1);

            protected abstract void isMasterRunning() throws ServiceException;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object makeStubNoRetries() throws IOException, KeeperException, ServiceException {
                ZooKeeperKeepAliveConnection zkw;
                try {
                    zkw = HConnectionImplementation.this.getKeepAliveZooKeeperWatcher();
                }
                catch (IOException e) {
                    ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                    throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
                }
                try {
                    HConnectionImplementation.this.checkIfBaseNodeAvailable(zkw);
                    ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                    if (sn == null) {
                        String msg = "ZooKeeper available but no active master location found";
                        LOG.info((Object)msg);
                        throw new MasterNotRunningException(msg);
                    }
                    if (HConnectionImplementation.this.isDeadServer(sn)) {
                        throw new MasterNotRunningException(sn + " is dead.");
                    }
                    String key = HConnectionImplementation.getStubKey(this.getServiceName(), sn.getHostAndPort());
                    HConnectionImplementation.this.connectionLock.putIfAbsent(key, key);
                    Object stub = null;
                    String string = (String)HConnectionImplementation.this.connectionLock.get(key);
                    synchronized (string) {
                        stub = HConnectionImplementation.this.stubs.get(key);
                        if (stub == null) {
                            BlockingRpcChannel channel = HConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, HConnectionImplementation.this.user, HConnectionImplementation.this.rpcTimeout);
                            stub = this.makeStub(channel);
                            this.isMasterRunning();
                            HConnectionImplementation.this.stubs.put(key, stub);
                        }
                    }
                    string = stub;
                    return string;
                }
                finally {
                    zkw.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            Object makeStub() throws MasterNotRunningException {
                Object object = HConnectionImplementation.this.masterAndZKLock;
                synchronized (object) {
                    Throwable exceptionCaught = null;
                    Object stub = null;
                    int tries = 0;
                    while (!HConnectionImplementation.this.closed && stub == null) {
                        ++tries;
                        try {
                            stub = this.makeStubNoRetries();
                        }
                        catch (IOException e) {
                            exceptionCaught = e;
                        }
                        catch (KeeperException e) {
                            exceptionCaught = e;
                        }
                        catch (ServiceException e) {
                            exceptionCaught = e;
                        }
                        if (exceptionCaught == null) continue;
                        if (tries < HConnectionImplementation.this.numTries && !ExceptionUtil.isInterrupt((Throwable)exceptionCaught)) {
                            long pauseTime = ConnectionUtils.getPauseTime(HConnectionImplementation.this.pause, tries - 1);
                            LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; retrying after sleep of " + pauseTime + ", exception=" + exceptionCaught));
                            try {
                                Thread.sleep(pauseTime);
                                continue;
                            }
                            catch (InterruptedException e) {
                                throw new MasterNotRunningException("Thread was interrupted while trying to connect to master.", e);
                            }
                        }
                        LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; no more retrying."), exceptionCaught);
                        throw new MasterNotRunningException((Exception)exceptionCaught);
                    }
                    if (stub == null) {
                        throw new MasterNotRunningException("Connection was closed while trying to get master");
                    }
                    return stub;
                }
            }
        }

        static class MasterServiceState {
            HConnection connection;
            MasterProtos.MasterService.BlockingInterface stub;
            int userCount;
            long keepAliveUntil = Long.MAX_VALUE;

            MasterServiceState(HConnection connection) {
                this.connection = connection;
            }

            public String toString() {
                return "MasterService";
            }

            Object getStub() {
                return this.stub;
            }

            void clearStub() {
                this.stub = null;
            }

            boolean isMasterRunning() throws ServiceException {
                MasterProtos.IsMasterRunningResponse response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
                return response != null ? response.getIsMasterRunning() : false;
            }
        }

        private static class NoNonceGenerator
        implements NonceGenerator {
            private NoNonceGenerator() {
            }

            @Override
            public long getNonceGroup() {
                return 0L;
            }

            @Override
            public long newNonce() {
                return 0L;
            }
        }
    }
}

