/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");

    private static HTable getAclTable(Configuration conf) throws IOException {
        return new HTable(conf, ACL_TABLE_NAME);
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(HTable ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Configuration conf, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(ht), userName, tableName, family, qual, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(ht), userName, namespace, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessControllerRunning(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        HBaseAdmin ha = null;
        try {
            ha = new HBaseAdmin(conf);
            boolean bl = ha.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
        finally {
            if (ha != null) {
                ha.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revoke(Configuration conf, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(ht), username, tableName, family, qualifier, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revoke(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(ht), userName, namespace, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UserPermission> getUserPermissions(Configuration conf, String tableRegex) throws Throwable {
        List<Object> permList = new ArrayList();
        HTable ht = null;
        HBaseAdmin ha = null;
        try {
            ha = new HBaseAdmin(conf);
            ht = new HTable(conf, ACL_TABLE_NAME);
            CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            HTableDescriptor[] htds = null;
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = ProtobufUtil.getUserPermissions(protocol);
            } else if (tableRegex.charAt(0) == '@') {
                String namespace = tableRegex.substring(1);
                permList = ProtobufUtil.getUserPermissions(protocol, Bytes.toBytes((String)namespace));
            } else {
                for (HTableDescriptor hd : htds = ha.listTables(Pattern.compile(tableRegex))) {
                    permList.addAll(ProtobufUtil.getUserPermissions(protocol, hd.getTableName()));
                }
            }
        }
        finally {
            if (ht != null) {
                ht.close();
            }
            if (ha != null) {
                ha.close();
            }
        }
        return permList;
    }
}

