/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.io.VersionedWritable;

@InterfaceAudience.Public
public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, ServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private List<RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;
    private Boolean balancerOn;

    @Deprecated
    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, List<RegionState> rit, String[] masterCoprocessors, Boolean balancerOn) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
        this.balancerOn = balancerOn;
    }

    public Collection<ServerName> getDeadServerNames() {
        if (this.deadServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers != null ? this.liveServers.size() : 0;
    }

    @Deprecated
    public int getDeadServers() {
        return this.getDeadServersSize();
    }

    public int getDeadServersSize() {
        return this.deadServers != null ? this.deadServers.size() : 0;
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        int serverSize = this.getServersSize();
        return serverSize != 0 ? (double)load / (double)serverSize : 0.0;
    }

    public int getRegionsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count += e.getValue().getNumberOfRegions();
            }
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count = (int)((long)count + e.getValue().getNumberOfRequests());
            }
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        return this.getVersion() == ((ClusterStatus)((Object)o)).getVersion() && this.getHBaseVersion().equals(((ClusterStatus)((Object)o)).getHBaseVersion()) && this.liveServers.equals(((ClusterStatus)((Object)o)).liveServers) && this.deadServers.containsAll(((ClusterStatus)((Object)o)).deadServers) && Arrays.equals(this.masterCoprocessors, ((ClusterStatus)((Object)o)).masterCoprocessors) && this.master.equals((Object)((ClusterStatus)((Object)o)).master) && this.backupMasters.containsAll(((ClusterStatus)((Object)o)).backupMasters);
    }

    public int hashCode() {
        return 2 + this.hbaseVersion.hashCode() + this.liveServers.hashCode() + this.deadServers.hashCode() + this.master.hashCode() + this.backupMasters.hashCode();
    }

    public byte getVersion() {
        return 2;
    }

    public Collection<ServerName> getServers() {
        if (this.liveServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters != null ? this.backupMasters.size() : 0;
    }

    public Collection<ServerName> getBackupMasters() {
        if (this.backupMasters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public ServerLoad getLoad(ServerName sn) {
        return this.liveServers != null ? this.liveServers.get(sn) : null;
    }

    @InterfaceAudience.Private
    public List<RegionState> getRegionsInTransition() {
        return this.intransition;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public long getLastMajorCompactionTsForTable(TableName table) {
        long result = Long.MAX_VALUE;
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            for (RegionLoad rl : load.getRegionsLoad().values()) {
                if (!table.equals((Object)HRegionInfo.getTable(rl.getName()))) continue;
                result = Math.min(result, rl.getLastMajorCompactionTs());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    public long getLastMajorCompactionTsForRegion(byte[] region) {
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            RegionLoad rl = load.getRegionsLoad().get(region);
            if (rl == null) continue;
            return rl.getLastMajorCompactionTs();
        }
        return 0L;
    }

    public boolean isBalancerOn() {
        return this.balancerOn != null && this.balancerOn != false;
    }

    public Boolean getBalancerOn() {
        return this.balancerOn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.master);
        int backupMastersSize = this.getBackupMastersSize();
        sb.append("\nNumber of backup masters: " + backupMastersSize);
        if (backupMastersSize > 0) {
            for (ServerName serverName : this.backupMasters) {
                sb.append("\n  " + serverName);
            }
        }
        int serversSize = this.getServersSize();
        sb.append("\nNumber of live region servers: " + serversSize);
        if (serversSize > 0) {
            for (ServerName serverName : this.liveServers.keySet()) {
                sb.append("\n  " + serverName.getServerName());
            }
        }
        int n = this.getDeadServersSize();
        sb.append("\nNumber of dead region servers: " + n);
        if (n > 0) {
            for (ServerName serverName : this.deadServers) {
                sb.append("\n  " + serverName);
            }
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestsCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        int n2 = this.intransition != null ? this.intransition.size() : 0;
        sb.append("\nNumber of regions in transition: " + n2);
        if (n2 > 0) {
            for (RegionState state : this.intransition) {
                sb.append("\n  " + state.toDescriptiveString());
            }
        }
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Options {
        private boolean includeHBaseVersion = true;
        private boolean includeLiveServers = true;
        private boolean includeDeadServers = true;
        private boolean includeMaster = true;
        private boolean includeBackupMasters = true;
        private boolean includeRegionState = true;
        private boolean includeClusterId = true;
        private boolean includeMasterCoprocessors = true;
        private boolean includeBalancerOn = true;

        private Options() {
        }

        public static Options getDefaultOptions() {
            return new Options();
        }

        public Options excludeHBaseVersion() {
            this.includeHBaseVersion = false;
            return this;
        }

        public Options excludeLiveServers() {
            this.includeLiveServers = false;
            return this;
        }

        public Options excludeDeadServers() {
            this.includeDeadServers = false;
            return this;
        }

        public Options excludeMaster() {
            this.includeMaster = false;
            return this;
        }

        public Options excludeBackupMasters() {
            this.includeBackupMasters = false;
            return this;
        }

        public Options excludeRegionState() {
            this.includeRegionState = false;
            return this;
        }

        public Options excludeClusterId() {
            this.includeClusterId = false;
            return this;
        }

        public Options excludeMasterCoprocessors() {
            this.includeMasterCoprocessors = false;
            return this;
        }

        public Options excludeBalancerOn() {
            this.includeBalancerOn = false;
            return this;
        }

        public boolean includeHBaseVersion() {
            return this.includeHBaseVersion;
        }

        public boolean includeLiveServers() {
            return this.includeLiveServers;
        }

        public boolean includeDeadServers() {
            return this.includeDeadServers;
        }

        public boolean includeMaster() {
            return this.includeMaster;
        }

        public boolean includeBackupMasters() {
            return this.includeBackupMasters;
        }

        public boolean includeRegionState() {
            return this.includeRegionState;
        }

        public boolean includeClusterId() {
            return this.includeClusterId;
        }

        public boolean includeMasterCoprocessors() {
            return this.includeMasterCoprocessors;
        }

        public boolean includeBalancerOn() {
            return this.includeBalancerOn;
        }

        public Options reset() {
            this.includeHBaseVersion = true;
            this.includeLiveServers = true;
            this.includeDeadServers = true;
            this.includeMaster = true;
            this.includeBackupMasters = true;
            this.includeRegionState = true;
            this.includeClusterId = true;
            this.includeMasterCoprocessors = true;
            this.includeBalancerOn = true;
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ClusterStatus info: [");
            builder.append("include hbase version: " + this.includeHBaseVersion + ", ");
            builder.append("include cluster id: " + this.includeClusterId + ", ");
            builder.append("include master info: " + this.includeMaster + ", ");
            builder.append("include backup masters info: " + this.includeBackupMasters + ", ");
            builder.append("include live servers info: " + this.includeLiveServers + ", ");
            builder.append("include dead servers info: " + this.includeDeadServers + ", ");
            builder.append("include masters coprocessors: " + this.includeMasterCoprocessors + ", ");
            builder.append("include region state: " + this.includeRegionState + ", ");
            builder.append("include balancer on: " + this.includeBalancerOn + "]");
            return builder.toString();
        }
    }

    public static class Builder {
        private String hbaseVersion = null;
        private Map<ServerName, ServerLoad> liveServers = null;
        private Collection<ServerName> deadServers = null;
        private ServerName master = null;
        private Collection<ServerName> backupMasters = null;
        private List<RegionState> intransition = null;
        private String clusterId = null;
        private String[] masterCoprocessors = null;
        private Boolean balancerOn = null;

        private Builder() {
        }

        public Builder setHBaseVersion(String hbaseVersion) {
            this.hbaseVersion = hbaseVersion;
            return this;
        }

        public Builder setLiveServers(Map<ServerName, ServerLoad> liveServers) {
            this.liveServers = liveServers;
            return this;
        }

        public Builder setDeadServers(Collection<ServerName> deadServers) {
            this.deadServers = deadServers;
            return this;
        }

        public Builder setMaster(ServerName master) {
            this.master = master;
            return this;
        }

        public Builder setBackupMasters(Collection<ServerName> backupMasters) {
            this.backupMasters = backupMasters;
            return this;
        }

        public Builder setRegionState(List<RegionState> intransition) {
            this.intransition = intransition;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setMasterCoprocessors(String[] masterCoprocessors) {
            this.masterCoprocessors = masterCoprocessors;
            return this;
        }

        public Builder setBalancerOn(Boolean balancerOn) {
            this.balancerOn = balancerOn;
            return this;
        }

        public ClusterStatus build() {
            return new ClusterStatus(this.hbaseVersion, this.clusterId, this.liveServers, this.deadServers, this.master, this.backupMasters, this.intransition, this.masterCoprocessors, this.balancerOn);
        }
    }
}

