/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteArrayHashKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
public class HRegionInfo
implements Comparable<HRegionInfo> {
    private static final Log LOG = LogFactory.getLog(HRegionInfo.class);
    private static final int ENC_SEPARATOR = 46;
    public static final int MD5_HEX_LENGTH = 32;
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    public static final String REPLICA_ID_FORMAT = "%04X";
    public static final byte REPLICA_ID_DELIMITER = 95;
    private static final int MAX_REPLICA_ID = 65535;
    public static final int DEFAULT_REPLICA_ID = 0;
    public static final String INVALID_REGION_NAME_FORMAT_MESSAGE = "Invalid regionName format";
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private String encodedName = null;
    private byte[] encodedNameAsBytes = null;
    private int replicaId = 0;
    private TableName tableName = null;
    static final String DISPLAY_KEYS_KEY = "hbase.display.keys";
    public static final byte[] HIDDEN_END_KEY = Bytes.toBytes((String)"hidden-end-key");
    public static final byte[] HIDDEN_START_KEY = Bytes.toBytes((String)"hidden-start-key");
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, TableName.META_TABLE_NAME);

    private static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString((byte[])regionName, (int)(regionName.length - 32 - 1), (int)32);
        } else {
            ByteArrayHashKey key = new ByteArrayHashKey(regionName, 0, regionName.length);
            int hashVal = Math.abs(JenkinsHash.getInstance().hash((HashKey)key, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public String getShortNameToLog() {
        return HRegionInfo.prettyPrint(this.getEncodedName());
    }

    public static String getShortNameToLog(HRegionInfo ... hris) {
        return HRegionInfo.getShortNameToLog(Arrays.asList(hris));
    }

    public static String getShortNameToLog(List<HRegionInfo> hris) {
        return hris.stream().map(hri -> hri.getShortNameToLog()).collect(Collectors.toList()).toString();
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/hbase:meta";
        }
        return encodedRegionName;
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        result ^= Arrays.hashCode(this.tableName.getName());
        this.hashCode = result ^= this.replicaId;
    }

    private HRegionInfo(long regionId, TableName tableName) {
        this(regionId, tableName, 0);
    }

    public HRegionInfo(long regionId, TableName tableName, int replicaId) {
        this.regionId = regionId;
        this.tableName = tableName;
        this.replicaId = replicaId;
        this.regionName = HRegionInfo.createRegionName(tableName, null, regionId, replicaId, false);
        this.setHashCode();
    }

    public HRegionInfo(TableName tableName) {
        this(tableName, null, null);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableName, startKey, endKey, false);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, regionid, 0);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid, int replicaId) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        this.tableName = tableName;
        this.offLine = false;
        this.regionId = regionid;
        this.replicaId = replicaId;
        if (this.replicaId > 65535) {
            throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
        }
        this.regionName = HRegionInfo.createRegionName(this.tableName, startKey, this.regionId, replicaId, true);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableName = tableName;
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.tableName;
        this.replicaId = other.replicaId;
    }

    public HRegionInfo(HRegionInfo other, int replicaId) {
        this(other);
        this.replicaId = replicaId;
        this.setHashCode();
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, String id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)id), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, int replicaId, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)Long.toString(regionid)), replicaId, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, id, 0, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, int replicaId, boolean newFormat) {
        int len = tableName.getName().length + 2 + id.length + (startKey == null ? 0 : startKey.length);
        if (newFormat) {
            len += 34;
        }
        byte[] replicaIdBytes = null;
        if (replicaId > 0) {
            replicaIdBytes = Bytes.toBytes((String)String.format(REPLICA_ID_FORMAT, replicaId));
            len += 1 + replicaIdBytes.length;
        }
        byte[] b = new byte[len];
        int offset = tableName.getName().length;
        System.arraycopy(tableName.getName(), 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (replicaIdBytes != null) {
            b[offset++] = 95;
            System.arraycopy(replicaIdBytes, 0, b, offset, replicaIdBytes.length);
            offset += replicaIdBytes.length;
        }
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex((byte[])b, (int)0, (int)offset);
            byte[] md5HashBytes = Bytes.toBytes((String)md5Hash);
            if (md5HashBytes.length != 32) {
                LOG.error((Object)("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length));
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            offset += 32;
            b[offset++] = 46;
        }
        return b;
    }

    public static TableName getTable(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        byte[] buff = new byte[offset];
        System.arraycopy(regionName, 0, buff, 0, offset);
        return TableName.valueOf((byte[])buff);
    }

    public static byte[] getStartKey(byte[] regionName) throws IOException {
        return HRegionInfo.parseRegionName(regionName)[1];
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format: " + Bytes.toStringBinary((byte[])regionName));
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        int endOffset = regionName.length;
        if (regionName.length > 34 && regionName[regionName.length - 1] == 46 && regionName[regionName.length - 32 - 2] == 46) {
            endOffset = endOffset - 32 - 2;
        }
        byte[] replicaId = null;
        int idEndOffset = endOffset;
        for (int i = endOffset - 1; i > 0; --i) {
            if (regionName[i] == 95) {
                replicaId = new byte[endOffset - i - 1];
                System.arraycopy(regionName, i + 1, replicaId, 0, endOffset - i - 1);
                idEndOffset = i;
            }
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format: " + Bytes.toStringBinary((byte[])regionName));
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[idEndOffset - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, idEndOffset - offset - 1);
        byte[][] elements = new byte[replicaId == null ? 3 : 4][];
        elements[0] = tableName;
        elements[1] = startKey;
        elements[2] = id;
        if (replicaId != null) {
            elements[3] = replicaId;
        }
        return elements;
    }

    public static boolean isEncodedRegionName(byte[] regionName) throws IOException {
        try {
            HRegionInfo.parseRegionName(regionName);
            return false;
        }
        catch (IOException e) {
            if (StringUtils.stringifyException((Throwable)e).contains(INVALID_REGION_NAME_FORMAT_MESSAGE)) {
                return true;
            }
            throw e;
        }
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        if (HRegionInfo.hasEncodedName(this.regionName)) {
            return Bytes.toStringBinary((byte[])this.regionName);
        }
        return Bytes.toStringBinary((byte[])this.regionName) + "." + this.getEncodedName();
    }

    public synchronized String getEncodedName() {
        if (this.encodedName == null) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes((String)this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public TableName getTable() {
        if (this.tableName == null || this.tableName.getName().length == 0) {
            this.tableName = HRegionInfo.getTable(this.getRegionName());
        }
        return this.tableName;
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo((byte[])rangeStartKey, (byte[])rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])rangeStartKey) + " > " + Bytes.toStringBinary((byte[])rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo((byte[])rangeStartKey, (byte[])this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo((byte[])rangeEndKey, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo((byte[])row, (byte[])this.startKey) >= 0 && (Bytes.compareTo((byte[])row, (byte[])this.endKey) < 0 || Bytes.equals((byte[])this.endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY));
    }

    public boolean isMetaTable() {
        return this.isMetaRegion();
    }

    public boolean isMetaRegion() {
        return this.tableName.equals((Object)FIRST_META_REGIONINFO.getTable());
    }

    public boolean isSystemTable() {
        return this.tableName.isSystemTable();
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
        }
        return true;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public String toString() {
        return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + Bytes.toStringBinary((byte[])this.regionName) + "', STARTKEY => '" + Bytes.toStringBinary((byte[])this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary((byte[])this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + (this.replicaId > 0 ? ", REPLICA_ID => " + this.replicaId : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)o) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = this.tableName.compareTo(o.tableName);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])this.startKey, (byte[])o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])this.endKey, (byte[])o.endKey);
        if (result != 0) {
            if (this.getStartKey().length != 0 && this.getEndKey().length == 0) {
                return 1;
            }
            if (o.getStartKey().length != 0 && o.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (this.regionId > o.regionId) {
            return 1;
        }
        if (this.regionId < o.regionId) {
            return -1;
        }
        int replicaDiff = this.getReplicaId() - o.getReplicaId();
        if (replicaDiff != 0) {
            return replicaDiff;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    @Deprecated
    public KeyValue.KVComparator getComparator() {
        return this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
    }

    HBaseProtos.RegionInfo convert() {
        return HRegionInfo.convert(this);
    }

    public static HBaseProtos.RegionInfo convert(HRegionInfo info) {
        if (info == null) {
            return null;
        }
        HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(info.getTable()));
        builder.setRegionId(info.getRegionId());
        if (info.getStartKey() != null) {
            builder.setStartKey(UnsafeByteOperations.unsafeWrap((byte[])info.getStartKey()));
        }
        if (info.getEndKey() != null) {
            builder.setEndKey(UnsafeByteOperations.unsafeWrap((byte[])info.getEndKey()));
        }
        builder.setOffline(info.isOffline());
        builder.setSplit(info.isSplit());
        builder.setReplicaId(info.getReplicaId());
        return builder.build();
    }

    public static HRegionInfo convert(HBaseProtos.RegionInfo proto) {
        if (proto == null) {
            return null;
        }
        TableName tableName = ProtobufUtil.toTableName(proto.getTableName());
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return RegionReplicaUtil.getRegionInfoForReplica(FIRST_META_REGIONINFO, proto.getReplicaId());
        }
        long regionId = proto.getRegionId();
        int replicaId = proto.hasReplicaId() ? proto.getReplicaId() : 0;
        byte[] startKey = null;
        byte[] endKey = null;
        if (proto.hasStartKey()) {
            startKey = proto.getStartKey().toByteArray();
        }
        if (proto.hasEndKey()) {
            endKey = proto.getEndKey().toByteArray();
        }
        boolean split = false;
        if (proto.hasSplit()) {
            split = proto.getSplit();
        }
        HRegionInfo hri = new HRegionInfo(tableName, startKey, endKey, split, regionId, replicaId);
        if (proto.hasOffline()) {
            hri.setOffline(proto.getOffline());
        }
        return hri;
    }

    public byte[] toByteArray() {
        byte[] bytes = this.convert().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static HRegionInfo parseFromOrNull(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(bytes, 0, bytes.length);
    }

    public static HRegionInfo parseFromOrNull(byte[] bytes, int offset, int len) {
        if (bytes == null || len <= 0) {
            return null;
        }
        try {
            return HRegionInfo.parseFrom(bytes, offset, len);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    public static HRegionInfo parseFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFrom(bytes, 0, bytes.length);
    }

    public static HRegionInfo parseFrom(byte[] bytes, int offset, int len) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes, offset, len)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen + offset, len - pblen);
                HBaseProtos.RegionInfo ri = builder.build();
                return HRegionInfo.convert(ri);
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        throw new DeserializationException("PB encoded HRegionInfo expected");
    }

    public byte[] toDelimitedByteArray() throws IOException {
        return ProtobufUtil.toDelimitedByteArray((Message)this.convert());
    }

    public static String getDescriptiveNameFromRegionStateForDisplay(RegionState state, Configuration conf) {
        if (conf.getBoolean(DISPLAY_KEYS_KEY, true)) {
            return state.toDescriptiveString();
        }
        String descriptiveStringFromState = state.toDescriptiveString();
        int idx = descriptiveStringFromState.lastIndexOf(" state=");
        String regionName = HRegionInfo.getRegionNameAsStringForDisplay(state.getRegion(), conf);
        return regionName + descriptiveStringFromState.substring(idx);
    }

    public static byte[] getEndKeyForDisplay(HRegionInfo hri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey) {
            return hri.getEndKey();
        }
        return HIDDEN_END_KEY;
    }

    public static byte[] getStartKeyForDisplay(HRegionInfo hri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey) {
            return hri.getStartKey();
        }
        return HIDDEN_START_KEY;
    }

    public static String getRegionNameAsStringForDisplay(HRegionInfo hri, Configuration conf) {
        return Bytes.toStringBinary((byte[])HRegionInfo.getRegionNameForDisplay(hri, conf));
    }

    public static byte[] getRegionNameForDisplay(HRegionInfo hri, Configuration conf) {
        boolean displayKey = conf.getBoolean(DISPLAY_KEYS_KEY, true);
        if (displayKey || hri.getTable().equals((Object)TableName.META_TABLE_NAME)) {
            return hri.getRegionName();
        }
        try {
            byte[][] regionNameParts = HRegionInfo.parseRegionName(hri.getRegionName());
            regionNameParts[1] = HIDDEN_START_KEY;
            int len = 0;
            for (byte[] b : regionNameParts) {
                len += b.length;
            }
            byte[] encodedRegionName = Bytes.toBytes((String)HRegionInfo.encodeRegionName(hri.getRegionName()));
            byte[] modifiedName = new byte[(len += encodedRegionName.length) + regionNameParts.length + 1];
            int lengthSoFar = 0;
            int loopCount = 0;
            for (byte[] b : regionNameParts) {
                System.arraycopy(b, 0, modifiedName, lengthSoFar, b.length);
                lengthSoFar += b.length;
                modifiedName[lengthSoFar++] = loopCount++ == 2 ? 95 : 44;
            }
            modifiedName[lengthSoFar - 1] = 46;
            System.arraycopy(encodedRegionName, 0, modifiedName, lengthSoFar, encodedRegionName.length);
            modifiedName[lengthSoFar += encodedRegionName.length] = 46;
            return modifiedName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HRegionInfo parseFrom(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
            return HRegionInfo.convert(HBaseProtos.RegionInfo.parseDelimitedFrom((InputStream)in));
        }
        throw new IOException("PB encoded HRegionInfo expected");
    }

    public static byte[] toDelimitedByteArray(HRegionInfo ... infos) throws IOException {
        byte[][] bytes = new byte[infos.length][];
        int size = 0;
        for (int i = 0; i < infos.length; ++i) {
            bytes[i] = infos[i].toDelimitedByteArray();
            size += bytes[i].length;
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HRegionInfo> parseDelimitedFrom(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Can't build an object with empty bytes array");
        }
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, length);
            while (in.available() > 0) {
                HRegionInfo hri = HRegionInfo.parseFrom((DataInputStream)in);
                hris.add(hri);
            }
        }
        return hris;
    }

    public static boolean areAdjacent(HRegionInfo regionA, HRegionInfo regionB) {
        if (regionA == null || regionB == null) {
            throw new IllegalArgumentException("Can't check whether adjacent for null region");
        }
        HRegionInfo a = regionA;
        HRegionInfo b = regionB;
        if (Bytes.compareTo((byte[])a.getStartKey(), (byte[])b.getStartKey()) > 0) {
            a = regionB;
            b = regionA;
        }
        return Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getStartKey()) == 0;
    }
}

