/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Row;

@InterfaceAudience.Private
public class Action
implements Comparable<Action> {
    private final Row action;
    private final int originalIndex;
    private long nonce = 0L;
    private int replicaId = 0;
    private int priority;

    public Action(Row action, int originalIndex) {
        this(action, originalIndex, -1);
    }

    public Action(Row action, int originalIndex, int priority) {
        this.action = action;
        this.originalIndex = originalIndex;
        this.priority = priority;
    }

    public Action(Action action, int replicaId) {
        this.action = action.action;
        this.nonce = action.nonce;
        this.originalIndex = action.originalIndex;
        this.replicaId = replicaId;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public boolean hasNonce() {
        return this.nonce != 0L;
    }

    public Row getAction() {
        return this.action;
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(Action other) {
        return this.action.compareTo(other.getAction());
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Action) {
            return this.compareTo((Action)obj) == 0;
        }
        return false;
    }

    public long getNonce() {
        return this.nonce;
    }
}

