/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RawAsyncTable;

@InterfaceAudience.Public
public interface AsyncConnection
extends Closeable {
    public Configuration getConfiguration();

    public AsyncTableRegionLocator getRegionLocator(TableName var1);

    default public RawAsyncTable getRawTable(TableName tableName) {
        return this.getRawTableBuilder(tableName).build();
    }

    public AsyncTableBuilder<RawAsyncTable> getRawTableBuilder(TableName var1);

    default public AsyncTable getTable(TableName tableName, ExecutorService pool) {
        return this.getTableBuilder(tableName, pool).build();
    }

    public AsyncTableBuilder<AsyncTable> getTableBuilder(TableName var1, ExecutorService var2);

    default public AsyncAdmin getAdmin() {
        return this.getAdminBuilder().build();
    }

    public AsyncAdminBuilder<RawAsyncHBaseAdmin> getAdminBuilder();

    default public AsyncAdmin getAdmin(ExecutorService pool) {
        return this.getAdminBuilder(pool).build();
    }

    public AsyncAdminBuilder<AsyncHBaseAdmin> getAdminBuilder(ExecutorService var1);
}

